/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.net.URLEncoder;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

public class MBeanUtils {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(MBeanUtils.class.getName());
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardDefaultContext", "DefaultContext"}};
    static Hashtable<String, int[]> seq = new Hashtable();

    private static final String encodeStr(String t) {
        return URLEncoder.encode(t);
    }

    static String createManagedName(Object component) {
        String className = component.getClass().getName();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!className.equals(exceptions[i][0])) continue;
            return exceptions[i][1];
        }
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className;
    }

    static ObjectName createObjectName(String domain, Context context) throws MalformedObjectNameException {
        ObjectName name = null;
        Host host = (Host)context.getParent();
        String path = context.getPath();
        if (path.length() < 1) {
            path = "/";
        }
        name = new ObjectName(domain + ":j2eeType=WebModule,name=//" + host.getName() + path + ",J2EEApplication=none,J2EEServer=none");
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextEnvironment environment) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = environment.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Global,name=" + environment.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + environment.getName());
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                name = new ObjectName(domain + ":type=Environment" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",name=" + environment.getName());
            } else if (container instanceof Engine) {
                name = new ObjectName(domain + ":type=Environment" + ",resourcetype=ServiceDefaultContext,name=" + environment.getName());
            }
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResource resource) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceName = MBeanUtils.encodeStr(resource.getName());
        Object container = resource.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global,class=" + resource.getType() + ",name=" + encodedResourceName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",class=" + resource.getType() + ",name=" + encodedResourceName);
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                name = new ObjectName(domain + ":type=Resource" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",class=" + resource.getType() + ",name=" + encodedResourceName);
            } else if (container instanceof Engine) {
                name = new ObjectName(domain + ":type=Resource" + ",resourcetype=ServiceDefaultContext,class=" + resource.getType() + ",name=" + encodedResourceName);
            }
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResourceLink resourceLink) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceLinkName = MBeanUtils.encodeStr(resourceLink.getName());
        Object container = resourceLink.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Global" + ",name=" + encodedResourceLinkName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + encodedResourceLinkName);
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",name=" + encodedResourceLinkName);
            } else if (container instanceof Engine) {
                name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=ServiceDefaultContext,name=" + encodedResourceLinkName);
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, DefaultContext context) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = context.getParent();
        if (container instanceof Host) {
            Host host = (Host)container;
            name = new ObjectName(domain + ":type=DefaultContext,host=" + host.getName());
        } else if (container instanceof Engine) {
            name = new ObjectName(domain + ":type=DefaultContext");
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Engine engine) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Engine");
        return name;
    }

    static ObjectName createObjectName(String domain, Host host) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Host,host=" + host.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, Loader loader) throws MalformedObjectNameException {
        DefaultContext defaultContext;
        ObjectName name = null;
        Container container = loader.getContainer();
        if (container instanceof Engine) {
            name = new ObjectName(domain + ":type=Loader");
        } else if (container instanceof Host) {
            name = new ObjectName(domain + ":type=Loader,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            name = new ObjectName(domain + ":type=Loader,path=" + path + ",host=" + host.getName());
        } else if (container == null && (defaultContext = loader.getDefaultContext()) != null) {
            Container parent = defaultContext.getParent();
            if (parent instanceof Engine) {
                name = new ObjectName(domain + ":type=DefaultLoader");
            } else if (parent instanceof Host) {
                name = new ObjectName(domain + ":type=DefaultLoader,host=" + parent.getName());
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Logger logger2) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = logger2.getContainer();
        if (container instanceof Engine) {
            name = new ObjectName(domain + ":type=Logger");
        } else if (container instanceof Host) {
            name = new ObjectName(domain + ":type=Logger,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            name = new ObjectName(domain + ":type=Logger,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Manager manager) throws MalformedObjectNameException {
        DefaultContext defaultContext;
        ObjectName name = null;
        Container container = manager.getContainer();
        if (container instanceof Engine) {
            name = new ObjectName(domain + ":type=Manager");
        } else if (container instanceof Host) {
            name = new ObjectName(domain + ":type=Manager,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            name = new ObjectName(domain + ":type=Manager,path=" + path + ",host=" + host.getName());
        } else if (container == null && (defaultContext = manager.getDefaultContext()) != null) {
            Container parent = defaultContext.getParent();
            if (parent instanceof Engine) {
                name = new ObjectName(domain + ":type=DefaultManager");
            } else if (parent instanceof Host) {
                name = new ObjectName(domain + ":type=DefaultManager,host=" + parent.getName());
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, NamingResources resources) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = resources.getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Global");
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Context,path=" + path + ",host=" + host.getName());
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=HostDefaultContext,host=" + host.getName());
            } else if (container instanceof Engine) {
                name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=ServiceDefaultContext");
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Realm realm) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = realm.getContainer();
        if (container instanceof Engine) {
            name = new ObjectName(domain + ":type=Realm");
        } else if (container instanceof Host) {
            name = new ObjectName(domain + ":type=Realm,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            name = new ObjectName(domain + ":type=Realm,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Server server) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Server");
        return name;
    }

    static ObjectName createObjectName(String domain, Service service) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Service,serviceName=" + service.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, GlassFishValve valve) throws MalformedObjectNameException {
        ObjectName name;
        if (valve instanceof ValveBase && (name = ((ValveBase)valve).getObjectName()) != null) {
            return name;
        }
        name = null;
        Container container = null;
        String className = valve.getClass().getName();
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        if (valve instanceof Contained) {
            container = ((Contained)((Object)valve)).getContainer();
        }
        if (container == null) {
            throw new MalformedObjectNameException("Cannot create mbean for non-contained valve " + valve);
        }
        if (container instanceof Engine) {
            String local = "";
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Host) {
            String local = ",host=" + container.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            String local = ",path=" + path + ",host=" + host.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        }
        return name;
    }

    static int getSeq(String key) {
        int[] i = seq.get(key);
        if (i == null) {
            i = new int[]{0};
            seq.put(key, i);
        } else {
            i[0] = i[0] + 1;
        }
        return i[0];
    }
}

