/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft06;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.Masker;
import com.sun.grizzly.websockets.ProtocolError;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.draft06.HandShake06;
import com.sun.grizzly.websockets.frametypes.BinaryFrameType;
import com.sun.grizzly.websockets.frametypes.ClosingFrameType;
import com.sun.grizzly.websockets.frametypes.ContinuationFrameType;
import com.sun.grizzly.websockets.frametypes.PingFrameType;
import com.sun.grizzly.websockets.frametypes.PongFrameType;
import com.sun.grizzly.websockets.frametypes.TextFrameType;

public class Draft06Handler
extends ProtocolHandler {
    public Draft06Handler() {
        super(false);
    }

    public Draft06Handler(boolean maskData) {
        super(maskData);
    }

    protected HandShake createHandShake(Request request) {
        return new HandShake06(request);
    }

    protected HandShake createHandShake(URL url) {
        return new HandShake06(url);
    }

    public byte[] frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] payloadBytes = frame.getBytes();
        byte[] lengthBytes = this.encodeLength(payloadBytes.length);
        int packetLength = 1 + lengthBytes.length;
        byte[] packet = new byte[packetLength + payloadBytes.length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        System.arraycopy(payloadBytes, 0, packet, packetLength, payloadBytes.length);
        if (this.maskData) {
            Masker masker = new Masker(this.handler);
            masker.generateMask();
            packet = masker.maskAndPrepend(packet, masker);
        }
        return packet;
    }

    public DataFrame unframe() {
        byte lengthCode;
        long length;
        byte[] data;
        Masker masker = new Masker(this.handler);
        if (!this.maskData) {
            masker.setMask(this.handler.get(4));
        }
        byte opcode = masker.unmask();
        boolean controlFrame = this.isControlFrame(opcode);
        boolean finalFragment = (opcode & 0x80) == 128;
        opcode = (byte)(opcode & 0x7F);
        FrameType type2 = this.valueOf(this.inFragmentedType, opcode);
        if (!finalFragment && this.inFragmentedType == 0) {
            this.inFragmentedType = opcode;
        }
        if ((long)(data = masker.unmask((int)(length = (lengthCode = masker.unmask()) <= 125 ? (long)lengthCode : this.decodeLength(masker.unmask(lengthCode == 126 ? 2 : 8))))).length != length) {
            ProtocolError e = new ProtocolError(String.format("Data read (%s) is not the expected size (%s)", data.length, length));
            e.printStackTrace();
            throw e;
        }
        DataFrame dataFrame = type2.create(finalFragment, data);
        if (!controlFrame && (this.isTextFrame(opcode) || this.inFragmentedType == 4)) {
            this.utf8Decode(finalFragment, data, dataFrame);
        }
        if (!controlFrame && finalFragment) {
            this.inFragmentedType = 0;
        }
        return dataFrame;
    }

    protected boolean isControlFrame(byte opcode) {
        return opcode == 1 || opcode == 2 || opcode == 3;
    }

    private boolean isTextFrame(byte opcode) {
        return opcode == 4;
    }

    private byte getOpcode(FrameType type2) {
        if (type2 instanceof ClosingFrameType) {
            return 1;
        }
        if (type2 instanceof PingFrameType) {
            return 2;
        }
        if (type2 instanceof PongFrameType) {
            return 3;
        }
        if (type2 instanceof TextFrameType) {
            return 4;
        }
        if (type2 instanceof BinaryFrameType) {
            return 5;
        }
        throw new ProtocolError("Unknown frame type: " + type2.getClass().getName());
    }

    private FrameType valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode & 0xF) {
            case 0: {
                return new ContinuationFrameType((fragmentType & 4) == 4);
            }
            case 1: {
                return new ClosingFrameType();
            }
            case 2: {
                return new PingFrameType();
            }
            case 3: {
                return new PongFrameType();
            }
            case 4: {
                return new TextFrameType();
            }
            case 5: {
                return new BinaryFrameType();
            }
        }
        throw new ProtocolError("Unknown frame type: " + value);
    }
}

