/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.WebSocketException;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNetworkHandler
extends BaseNetworkHandler {
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private final Request request;
    private final Response response;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final InternalInputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private UDecoder urlDecoder = new UDecoder();
    private final ProtocolHandler protocolHandler;
    private boolean isClosed;

    public ServerNetworkHandler(Request req, Response resp, ProtocolHandler protocolHandler, Mapper mapper) {
        this.request = req;
        this.response = resp;
        GrizzlyRequest grizzlyRequest = new GrizzlyRequest();
        grizzlyRequest.setRequest(this.request);
        GrizzlyResponse grizzlyResponse = new GrizzlyResponse();
        grizzlyResponse.setResponse(this.response);
        grizzlyRequest.setResponse(grizzlyResponse);
        grizzlyResponse.setRequest(grizzlyRequest);
        try {
            this.httpServletRequest = new WSServletRequestImpl(grizzlyRequest, mapper);
            this.httpServletResponse = new HttpServletResponseImpl(grizzlyResponse);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.protocolHandler = protocolHandler;
        this.inputBuffer = (InternalInputBuffer)req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
    }

    protected int read() {
        int read = 0;
        ByteChunk newChunk = new ByteChunk(8192);
        Throwable error = null;
        try {
            ByteChunk bytes = new ByteChunk();
            if (this.chunk.getLength() > 0) {
                newChunk.append(this.chunk);
            }
            if ((read = this.inputBuffer.doRead(bytes, this.request)) > 0) {
                newChunk.append(bytes);
            }
        }
        catch (Throwable e) {
            error = e;
            read = -1;
        }
        if (read == -1) {
            throw new WebSocketException("Connection closed", error);
        }
        this.chunk.setBytes(newChunk.getBytes(), 0, newChunk.getEnd());
        return read;
    }

    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)this.chunk.substract();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            if (this.chunk.getLength() == 0) {
                this.read();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        InternalOutputBuffer internalOutputBuffer = this.outputBuffer;
        synchronized (internalOutputBuffer) {
            try {
                ByteChunk buffer = new ByteChunk();
                buffer.setBytes(bytes, 0, bytes.length);
                this.outputBuffer.doWrite(buffer, this.response);
                this.outputBuffer.flush();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            return this.chunk.getLength() != 0;
        }
    }

    public HttpServletRequest getRequest() throws IOException {
        return this.httpServletRequest;
    }

    public HttpServletResponse getResponse() throws IOException {
        return this.httpServletResponse;
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.protocolHandler.getProcessorTask().setAptCancelKey(true);
            AsyncProcessorTask asyncProcessorTask = this.protocolHandler.getAsyncTask();
            asyncProcessorTask.setStage(3);
            try {
                asyncProcessorTask.doTask();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.protocolHandler.getWebSocket().onClose(null);
        }
    }

    public String toString() {
        InputReader inputStream = (InputReader)this.inputBuffer.getInputStream();
        int remoteSocketAddress = ((SocketChannel)inputStream.key.channel()).socket().getPort();
        StringBuilder sb = new StringBuilder();
        sb.append("SNH[");
        sb.append(remoteSocketAddress);
        sb.append(",").append(super.toString());
        sb.append(']');
        return sb.toString();
    }

    private class WSServletRequestImpl
    extends HttpServletRequestImpl {
        private String pathInfo;
        private String servletPath;
        private String contextPath;

        public WSServletRequestImpl(GrizzlyRequest r, Mapper mapper) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
            if (mapper != null) {
                this.updatePaths(r, mapper);
            }
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        private void updatePaths(GrizzlyRequest r, Mapper mapper) {
            Request req = r.getRequest();
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                HttpRequestURIDecoder.decode(decodedURI, ServerNetworkHandler.this.urlDecoder, null, null);
                MappingData data = new MappingData();
                mapper.map(req.remoteHost(), decodedURI, data);
                this.pathInfo = data.pathInfo.getString();
                this.servletPath = data.wrapperPath.getString();
                this.contextPath = data.contextPath.getString();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to map request", e);
                }
                this.pathInfo = null;
                this.servletPath = null;
                this.contextPath = null;
            }
        }
    }
}

