/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.ajp.AjpConfiguration;
import com.sun.grizzly.http.ajp.AjpHttpRequest;
import com.sun.grizzly.http.ajp.AjpHttpResponse;
import com.sun.grizzly.http.ajp.AjpInputBuffer;
import com.sun.grizzly.http.ajp.AjpOutputBuffer;
import com.sun.grizzly.http.ajp.ShutdownHandler;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AjpProcessorTask
extends ProcessorTask {
    private static final Logger logger = SelectorThread.logger();
    private final AjpConfiguration ajpConfiguration;

    public AjpProcessorTask(AjpConfiguration ajpConfiguration, boolean initialize) {
        super(initialize, false);
        this.ajpConfiguration = ajpConfiguration;
    }

    public AjpConfiguration getAjpConfiguration() {
        return this.ajpConfiguration;
    }

    protected Request createRequest() {
        return new AjpHttpRequest();
    }

    protected Response createResponse() {
        return new AjpHttpResponse();
    }

    protected InternalInputBuffer createInputBuffer(Request request, int requestBufferSize) {
        return new AjpInputBuffer(this.ajpConfiguration, this, request, requestBufferSize);
    }

    public void sendHeaders() {
        ((AjpOutputBuffer)this.outputBuffer).sendHeaders();
    }

    protected SocketChannelOutputBuffer createOutputBuffer(Response response, int sendBufferSize, boolean bufferResponse) {
        return new AjpOutputBuffer(response, sendBufferSize, bufferResponse);
    }

    public boolean parseRequest() throws Exception {
        ((AjpInputBuffer)this.inputBuffer).readAjpMessageHeader();
        return super.parseRequest();
    }

    public void invokeAdapter() {
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        switch (ajpRequest.getType()) {
            case 2: {
                ajpRequest.setForwardRequestProcessing(true);
                if (ajpRequest.isExpectContent()) {
                    try {
                        ((AjpInputBuffer)this.request.getInputBuffer()).parseDataChunk();
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Exception during parsing data chunk on connection: " + this.key.channel(), e);
                        }
                        this.error = true;
                    }
                }
                super.invokeAdapter();
                break;
            }
            case 7: {
                this.processShutdown();
                break;
            }
            case 10: {
                try {
                    this.processCPing();
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Exception during sending CPONG reply on connection: " + this.key.channel(), e);
                    }
                    this.error = true;
                }
                break;
            }
            default: {
                this.error = true;
                logger.log(Level.WARNING, "Invalid packet type: {0}", ajpRequest.getType());
            }
        }
    }

    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
            AjpHttpRequest req = (AjpHttpRequest)param;
            MessageBytes certString = req.sslCert();
            if (certString != null && !certString.isNull()) {
                ByteChunk certData = certString.getByteChunk();
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                X509Certificate[] jsseCerts = null;
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[]{cert};
                            continue;
                        }
                        X509Certificate[] temp = new X509Certificate[jsseCerts.length + 1];
                        System.arraycopy(jsseCerts, 0, temp, 0, jsseCerts.length);
                        temp[jsseCerts.length] = cert;
                        jsseCerts = temp;
                    }
                }
                catch (CertificateException e) {
                    logger.log(Level.SEVERE, "Certificate convertion failed", e);
                    return;
                }
                req.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            }
        } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
            Request req = (Request)param;
            if (req.remoteHost().isNull()) {
                try {
                    req.remoteHost().setString(InetAddress.getByName(req.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Unable to resolve {0}", req.remoteAddr());
                    }
                }
            }
        } else if (actionCode != ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE && actionCode != ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE && actionCode != ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE && actionCode != ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE && actionCode != ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE && actionCode != ActionCode.ACTION_ACK) {
            super.action(actionCode, param);
        }
    }

    protected void prepareResponse() {
        this.contentDelimitation = false;
        MimeHeaders headers = this.response.getMimeHeaders();
        boolean entityBody = true;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if (this.request.method().equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null && !"".equals(contentLanguage)) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        this.contentDelimitation = true;
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            headers.setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode) && !this.dropConnection;
        if (!this.keepAlive) {
            headers.setValue("Connection").setString("close");
            this.connectionHeaderValueSet = false;
        } else if (!this.http11 && !this.error) {
            headers.setValue("Connection").setString("Keep-Alive");
        }
        this.sendHeaders();
    }

    private void processShutdown() {
        String secret;
        if (!this.ajpConfiguration.isShutdownEnabled()) {
            throw new IllegalStateException("Shutdown is disabled");
        }
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        String shutdownSecret = null;
        if (ajpRequest.getLength() > 1) {
            MessageBytes tmpMessageBytes = ajpRequest.tmpMessageBytes;
            ((AjpInputBuffer)this.inputBuffer).getBytesToMB(tmpMessageBytes);
            shutdownSecret = tmpMessageBytes.toString();
            tmpMessageBytes.recycle();
        }
        if ((secret = this.ajpConfiguration.getSecret()) != null && secret.equals(shutdownSecret)) {
            throw new IllegalStateException("Secret doesn't match, no shutdown");
        }
        Queue<ShutdownHandler> shutdownHandlers = this.ajpConfiguration.getShutdownHandlers();
        for (ShutdownHandler handler : shutdownHandlers) {
            try {
                handler.onShutdown(this.key.channel());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception during ShutdownHandler execution", e);
            }
        }
    }

    private void processCPing() throws IOException {
        this.response.setCommitted(true);
        this.keepAlive = true;
        AjpOutputBuffer ajpOutputBuffer = (AjpOutputBuffer)this.outputBuffer;
        AjpHttpResponse.writeCPongReply(ajpOutputBuffer);
        ajpOutputBuffer.flush();
        ajpOutputBuffer.setFinished(true);
    }

    public void setBufferSize(int requestBufferSize) {
        if (requestBufferSize < 16384) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Buffer size is set to {0} instead of {1} for performance reasons", new Object[]{16384, requestBufferSize});
            }
            requestBufferSize = 16384;
        }
        super.setBufferSize(requestBufferSize);
    }

    protected void error() {
        this.error = true;
        this.keepAlive = false;
    }
}

