/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.impl.transport;

import com.sun.grizzly.connectioncache.impl.transport.ConnectionCacheBlockingBase;
import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.grizzly.connectioncache.spi.transport.InboundConnectionCache;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundConnectionCacheBlockingImpl<C extends Closeable>
extends ConnectionCacheBlockingBase<C>
implements InboundConnectionCache<C> {
    private final Map<C, ConnectionState<C>> connectionMap = new HashMap<C, ConnectionState<C>>();

    @Override
    protected String thisClassName() {
        return "InboundConnectionCacheBlockingImpl";
    }

    public InboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, Logger logger2) {
        super(cacheType, highWaterMark, numberToReclaim, logger2);
        if (this.debug()) {
            this.dprint(".constructor completed: " + this.getCacheType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void requestReceived(C conn) {
        if (this.debug()) {
            this.dprint("->requestReceived: connection " + conn);
        }
        try {
            int count;
            ConcurrentQueue.Handle reclaimHandle;
            ConnectionState<C> cs = this.getConnectionState(conn);
            int totalConnections = this.totalBusy + this.totalIdle;
            if (totalConnections > this.highWaterMark()) {
                this.reclaim();
            }
            if ((reclaimHandle = cs.reclaimableHandle) != null) {
                if (this.debug()) {
                    this.dprint(".requestReceived: " + conn + " removed from reclaimableQueue");
                }
                reclaimHandle.remove();
            }
            if ((count = cs.busyCount++) == 0) {
                if (this.debug()) {
                    this.dprint(".requestReceived: " + conn + " transition from idle to busy");
                }
                --this.totalIdle;
                ++this.totalBusy;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.debug()) {
                this.dprint("<-requestReceived: connection " + conn);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-requestReceived: connection " + conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void requestProcessed(C conn, int numResponsesExpected) {
        block10: {
            block9: {
                if (this.debug()) {
                    this.dprint("->requestProcessed: connection " + conn + " expecting " + numResponsesExpected + " responses");
                }
                try {
                    ConnectionState<C> cs = this.connectionMap.get(conn);
                    if (cs == null) {
                        if (this.debug()) {
                            this.dprint(".release: connection " + conn + " was closed");
                        }
                        Object var7_4 = null;
                        break block9;
                    }
                    cs.expectedResponseCount += numResponsesExpected;
                    int numResp = cs.expectedResponseCount;
                    int numBusy = --cs.busyCount;
                    if (this.debug()) {
                        this.dprint(".release: " + numResp + " responses expected");
                        this.dprint(".release: " + numBusy + " busy count for connection");
                    }
                    if (numBusy != 0) break block10;
                    --this.totalBusy;
                    ++this.totalIdle;
                    if (numResp != 0) break block10;
                    if (this.debug()) {
                        this.dprint(".release: queuing reclaimable connection " + conn);
                    }
                    if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                        this.close(conn);
                        break block10;
                    } else {
                        cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (!this.debug()) throw throwable;
                    this.dprint("<-requestProcessed");
                    throw throwable;
                }
            }
            if (!this.debug()) return;
            this.dprint("<-requestProcessed");
            return;
        }
        Object var7_5 = null;
        if (!this.debug()) return;
        this.dprint("<-requestProcessed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void responseSent(C conn) {
        block12: {
            block11: {
                if (this.debug()) {
                    this.dprint("->responseSent: " + conn);
                }
                try {
                    int waitCount;
                    ConnectionState<C> cs = this.connectionMap.get(conn);
                    if (cs == null) {
                        if (this.debug()) {
                            this.dprint(".release: connection " + conn + " was closed");
                        }
                        Object var5_3 = null;
                        break block11;
                    }
                    if ((waitCount = --cs.expectedResponseCount) == 0) {
                        if (this.debug()) {
                            this.dprint(".responseSent: " + conn + " is now reclaimable");
                        }
                        if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                            if (this.debug()) {
                                this.dprint(".responseSent: " + conn + " closing connection");
                            }
                            this.close(conn);
                            break block12;
                        }
                        cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                        if (this.debug()) {
                            this.dprint(".responseSent: " + conn + " is now reclaimable");
                        }
                        break block12;
                    }
                    if (this.debug()) {
                        this.dprint(".responseSent: " + conn + " waitCount=" + waitCount);
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!this.debug()) throw throwable;
                    this.dprint("<-responseSent: " + conn);
                    throw throwable;
                }
            }
            if (!this.debug()) return;
            this.dprint("<-responseSent: " + conn);
            return;
        }
        Object var5_4 = null;
        if (!this.debug()) return;
        this.dprint("<-responseSent: " + conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(C conn) {
        if (this.debug()) {
            this.dprint("->close: " + conn);
        }
        try {
            block13: {
                ConnectionState<C> cs = this.connectionMap.remove(conn);
                if (cs != null) {
                    int count = cs.busyCount;
                    if (this.debug()) {
                        this.dprint(".close: " + conn + " count = " + count);
                    }
                    if (count == 0) {
                        --this.totalIdle;
                    } else {
                        --this.totalBusy;
                    }
                    ConcurrentQueue.Handle rh = cs.reclaimableHandle;
                    if (rh != null) {
                        if (this.debug()) {
                            this.dprint(".close: " + conn + " connection was reclaimable");
                        }
                        rh.remove();
                    }
                    try {
                        conn.close();
                    }
                    catch (IOException exc) {
                        if (!this.debug()) break block13;
                        this.dprint(".close: " + conn + " close threw " + exc);
                    }
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.debug()) {
                this.dprint("<-close: " + conn);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-close: " + conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionState<C> getConnectionState(C conn) {
        ConnectionState<C> connectionState;
        if (this.debug()) {
            this.dprint("->getConnectionState: " + conn);
        }
        try {
            ConnectionState<C> result = this.connectionMap.get(conn);
            if (result == null) {
                if (this.debug()) {
                    this.dprint(".getConnectionState: " + conn + " creating new ConnectionState instance");
                }
                result = new ConnectionState<C>(conn);
                this.connectionMap.put(conn, result);
                ++this.totalIdle;
            }
            connectionState = result;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var5_5 = null;
                if (!this.debug()) break block6;
                this.dprint("<-getConnectionState: " + conn);
            }
            throw throwable;
        }
        if (this.debug()) {
            this.dprint("<-getConnectionState: " + conn);
        }
        return connectionState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionState<C extends Closeable> {
        final C connection;
        int busyCount;
        int expectedResponseCount;
        ConcurrentQueue.Handle<C> reclaimableHandle;

        ConnectionState(C conn) {
            this.connection = conn;
            this.busyCount = 0;
            this.expectedResponseCount = 0;
            this.reclaimableHandle = null;
        }
    }
}

