/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSelectionKeyHandler
extends BaseSelectionKeyHandler {
    protected long nextKeysExpiration = 0L;
    protected long timeout = 30000L;

    public DefaultSelectionKeyHandler() {
    }

    public DefaultSelectionKeyHandler(SelectorHandler selectorHandler) {
        super(selectorHandler);
    }

    @Override
    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        DefaultSelectionKeyHandler copyHandler = (DefaultSelectionKeyHandler)copy;
        copyHandler.timeout = this.timeout;
    }

    @Override
    public void process(SelectionKey key) {
        super.process(key);
        this.removeExpirationStamp(key);
    }

    @Override
    public void postProcess(SelectionKey key) {
        super.postProcess(key);
        this.addExpirationStamp(key);
    }

    @Override
    public void register(Iterator<SelectionKey> keyIterator, int selectionKeyOps) {
        long currentTime = System.currentTimeMillis();
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            keyIterator.remove();
            this.doRegisterKey(key, selectionKeyOps, currentTime);
        }
    }

    @Override
    public void register(SelectionKey key, int selectionKeyOps) {
        this.doRegisterKey(key, selectionKeyOps, System.currentTimeMillis());
    }

    protected void doRegisterKey(SelectionKey key, int selectionKeyOps, long currentTime) {
        if (key.isValid()) {
            key.interestOps(key.interestOps() | selectionKeyOps);
            this.addExpirationStamp(key);
        }
    }

    @Override
    public void register(SelectableChannel channel, int ops) throws ClosedChannelException {
        if (!channel.isOpen()) {
            return;
        }
        Selector selector = this.selectorHandler.getSelector();
        long time = System.currentTimeMillis();
        channel.register(selector, ops, time);
    }

    @Override
    public void register(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(Iterator<SelectionKey> iterator) {
        if (this.timeout <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = currentTime + this.timeout;
        while (iterator.hasNext()) {
            long expire;
            SelectionKey key = iterator.next();
            if (!key.isValid() || (expire = this.getExpirationStamp(key.attachment())) < 0L) continue;
            if (currentTime - expire >= this.timeout) {
                this.cancel(key);
                continue;
            }
            if (expire + this.timeout >= this.nextKeysExpiration) continue;
            this.nextKeysExpiration = expire + this.timeout;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void removeExpirationStamp(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment != null) {
            if (attachment instanceof Long) {
                key.attach(null);
            } else if (attachment instanceof SelectionKeyAttachment) {
                ((SelectionKeyAttachment)attachment).setTimeout(Long.MIN_VALUE);
            }
        }
    }

    protected void addExpirationStamp(SelectionKey key, long currentTime) {
        Object attachment = key.attachment();
        if (attachment == null) {
            key.attach(currentTime);
        } else if (attachment instanceof SelectionKeyAttachment) {
            ((SelectionKeyAttachment)attachment).setTimeout(currentTime);
        }
    }

    protected void addExpirationStamp(SelectionKey key) {
        this.addExpirationStamp(key, System.currentTimeMillis());
    }

    protected long getExpirationStamp(Object attachment) {
        if (attachment instanceof Long) {
            return (Long)attachment;
        }
        if (attachment instanceof SelectionKeyAttachment) {
            return ((SelectionKeyAttachment)attachment).getTimeout();
        }
        return -9223372036854775806L;
    }
}

