/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.web.WebContainer;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

public class WebConfigListener
implements ConfigListener,
MapperUpdateListener {
    @Inject
    public HttpService httpService;
    @Inject(optional=true)
    public ManagerProperties managerProperties;
    @Inject(optional=true)
    public List<Property> property;
    private WebContainer container;
    private Logger logger;
    private NetworkConfig networkConfig;
    volatile boolean received = false;

    public void setContainer(WebContainer container) {
        this.container = container;
    }

    public void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    public void setNetworkConfig(NetworkConfig config) {
        this.networkConfig = config;
    }

    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> tClass, T t) {
                if (WebConfigListener.this.logger.isLoggable(Level.FINE)) {
                    WebConfigListener.this.logger.fine("Web container config changed " + (Object)((Object)type2) + " " + tClass + " " + t);
                }
                try {
                    if (tClass == HttpService.class) {
                        WebConfigListener.this.container.updateHttpService((HttpService)t);
                    } else if (tClass == NetworkListener.class) {
                        if (type2 == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.addConnector((NetworkListener)t, WebConfigListener.this.httpService, true);
                        } else if (type2 == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteConnector((NetworkListener)t);
                        } else if (type2 == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateConnector((NetworkListener)t, WebConfigListener.this.httpService);
                        }
                    } else if (tClass == VirtualServer.class) {
                        if (type2 == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.createHost((VirtualServer)t, WebConfigListener.this.httpService, null);
                            WebConfigListener.this.container.loadDefaultWebModule((VirtualServer)t);
                        } else if (type2 == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteHost(WebConfigListener.this.httpService);
                        } else if (type2 == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateHost((VirtualServer)t);
                        }
                    } else if (tClass == AccessLog.class) {
                        WebConfigListener.this.container.updateAccessLog(WebConfigListener.this.httpService);
                    } else {
                        if (tClass == ManagerProperties.class) {
                            return new NotProcessed("ManagerProperties requires restart");
                        }
                        if (tClass == WebContainerAvailability.class || tClass == AvailabilityService.class) {
                            WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                        } else if (tClass != NetworkListeners.class) {
                            if (tClass == Property.class) {
                                ConfigBeanProxy config = ((Property)t).getParent();
                                if (config instanceof HttpService) {
                                    WebConfigListener.this.container.updateHttpService((HttpService)config);
                                } else if (config instanceof VirtualServer) {
                                    WebConfigListener.this.container.updateHost((VirtualServer)config);
                                } else if (config instanceof NetworkListener) {
                                    WebConfigListener.this.container.updateConnector((NetworkListener)config, WebConfigListener.this.httpService);
                                } else {
                                    WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                                }
                            } else if (tClass == SystemProperty.class && ((SystemProperty)t).getName().endsWith("LISTENER_PORT")) {
                                for (NetworkListener listener : WebConfigListener.this.networkConfig.getNetworkListeners().getNetworkListener()) {
                                    if (!listener.getPort().equals(((SystemProperty)t).getValue())) continue;
                                    WebConfigListener.this.container.updateConnector(listener, WebConfigListener.this.httpService);
                                }
                            }
                        }
                    }
                }
                catch (LifecycleException le) {
                    WebConfigListener.this.logger.log(Level.SEVERE, "webcontainer.exceptionConfigHttpService", le);
                }
                return null;
            }
        }, this.logger);
    }

    public void update(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        this.container.updateMapper(httpService, httpListener, mapper);
    }
}

