/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.jsp;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.JspTag;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jsp.api.ResourceInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInjectorImpl
implements ResourceInjector {
    protected static final Logger _logger = LogDomains.getLogger(ResourceInjectorImpl.class, "javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    private InjectionManager injectionMgr;
    private JndiNameEnvironment desc;
    private WebModule webModule;

    public ResourceInjectorImpl(WebModule webModule) {
        this.webModule = webModule;
        this.desc = webModule.getWebBundleDescriptor();
        ServerContext serverContext = webModule.getServerContext();
        if (serverContext == null) {
            throw new IllegalStateException(_rb.getString("resource.injector.noservercontext"));
        }
        this.injectionMgr = serverContext.getDefaultHabitat().getByContract(InjectionManager.class);
    }

    @Override
    public <T extends JspTag> T createTagHandlerInstance(Class<T> clazz) throws Exception {
        return this.webModule.getWebContainer().createTagHandlerInstance(this.webModule, clazz);
    }

    @Override
    public void preDestroy(JspTag handler) {
        if (this.desc != null) {
            try {
                this.injectionMgr.invokeInstancePreDestroy(handler, this.desc);
            }
            catch (Exception e) {
                String msg = _rb.getString("webcontainer.exceptionDuringJspTagHandlerPredestroy");
                msg = MessageFormat.format(msg, handler);
                _logger.log(Level.WARNING, msg, e);
            }
        }
    }
}

