/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
@ContractProvided(value=UserTransaction.class)
public class UserTransactionImpl
implements UserTransaction,
Serializable {
    static Logger _logger = LogDomains.getLogger(UserTransactionImpl.class, "javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(UserTransactionImpl.class);
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;
    private static final boolean debug = false;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private boolean checkEjbAccess;

    public UserTransactionImpl() {
        this(true);
    }

    public UserTransactionImpl(boolean doEjbAccessChecks) {
        this.init();
        this.checkEjbAccess = doEjbAccessChecks;
    }

    private void init() {
        this.initialized = true;
    }

    private void checkUserTransactionMethodAccess(ComponentInvocation inv) throws IllegalStateException, SystemException {
        TransactionOperationsManager toMgr = (TransactionOperationsManager)inv.getTransactionOperationsManager();
        if (toMgr != null && this.checkEjbAccess && !toMgr.userTransactionMethodsAllowed()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.operation_not_allowed"));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        this.transactionManager.begin();
        try {
            if (inv != null) {
                TransactionOperationsManager toMgr = (TransactionOperationsManager)((ComponentInvocation)inv).getTransactionOperationsManager();
                if (toMgr != null) {
                    toMgr.doAfterUtxBegin();
                }
                ((ComponentInvocation)inv).setTransaction(this.transactionManager.getTransaction());
                this.transactionManager.enlistComponentResources();
            }
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", ex);
            SystemException sysEx = new SystemException(ex.getMessage());
            sysEx.initCause(ex);
            throw sysEx;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        try {
            try {
                this.transactionManager.delistComponentResources(false);
                this.transactionManager.commit();
            }
            catch (RemoteException ex) {
                _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", ex);
                throw new SystemException();
            }
            Object var4_2 = null;
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
            throw throwable;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        try {
            try {
                this.transactionManager.delistComponentResources(false);
                this.transactionManager.rollback();
            }
            catch (RemoteException ex) {
                _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", ex);
                throw new SystemException();
            }
            Object var4_2 = null;
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (inv != null) {
                ((ComponentInvocation)inv).setTransaction(null);
            }
            throw throwable;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(seconds);
            return;
        }
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv != null) {
            this.checkUserTransactionMethodAccess((ComponentInvocation)inv);
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public void setForTesting(JavaEETransactionManager tm, InvocationManager im) {
        this.transactionManager = tm;
        this.invocationManager = im;
        ((JavaEETransactionManagerSimplified)this.transactionManager).invMgr = im;
    }

    Object readResolve() throws ObjectStreamException {
        Habitat h = Globals.getDefaultHabitat();
        if (h != null) {
            return h.getComponent(UserTransactionImpl.class);
        }
        return this;
    }
}

