/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.DcomInfo;
import org.jvnet.hk2.component.Habitat;

public class LogFilterForInstance {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LogFilterForInstance.class);

    public File downloadGivenInstanceLogFile(Habitat habitat, Server targetServer, Domain domain, Logger logger2, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        File instanceLogFile = null;
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            String loggingFile;
            sshL.init(node, logger2);
            SFTPClient sftpClient = sshL.getSFTPClient();
            File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
            boolean noFileFound = true;
            String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
            try {
                Vector instanceLogFileNames = sftpClient.ls(loggingDir);
                for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                    SFTPv3DirectoryEntry file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                    String fileName = file.filename;
                    if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    noFileFound = false;
                    break;
                }
            }
            catch (Exception e) {
                noFileFound = true;
            }
            if (noFileFound) {
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileName, node, sNode, instanceName);
            }
            if (!sftpClient.exists(loggingFile = loggingDir + File.separator + logFileName)) {
                loggingFile = loggingDir + File.separator + "server.log";
            } else if (!sftpClient.exists(loggingFile)) {
                loggingFile = instanceLogFileName;
            }
            long instanceLogFileSize = 0L;
            instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + loggingFile.substring(loggingFile.lastIndexOf(File.separator), loggingFile.length()));
            if (instanceLogFile.exists()) {
                instanceLogFileSize = instanceLogFile.length();
            }
            SFTPv3FileAttributes sftPv3FileAttributes = sftpClient._stat(loggingFile);
            long fileSizeOnNode = sftPv3FileAttributes.size;
            if (instanceLogFileSize != fileSizeOnNode) {
                int i;
                BufferedInputStream in = null;
                FileOutputStream file = null;
                BufferedOutputStream out = null;
                InputStream inputStream = sftpClient.read(loggingFile);
                in = new BufferedInputStream(inputStream);
                file = new FileOutputStream(instanceLogFile);
                out = new BufferedOutputStream(file);
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                out.flush();
            }
            sftpClient.close();
        } else if (node.getType().equals("DCOM")) {
            File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
            String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
            try {
                DcomInfo info = new DcomInfo(node);
                WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                if (logFileName == null || logFileName.equals("")) {
                    logFileName = "server.log";
                }
                WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, loggingDir + File.separator + logFileName);
                instanceLogFile = new File(logFileDirectoryOnServer + File.separator + logFileName);
                wrf.copyTo(instanceLogFile);
            }
            catch (WindowsException ex) {
                throw new IOException("Unable to download instance log file from DCOM Instance Node");
            }
        }
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(Habitat habitat, Server targetServer, Domain domain, Logger logger2, String instanceName, String tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            int i;
            sshL.init(node, logger2);
            Vector allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger2, instanceName, instanceLogFileDirectory);
            boolean noFileFound = true;
            String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
            SFTPClient sftpClient = sshL.getSFTPClient();
            try {
                Vector instanceLogFileNames = sftpClient.ls(sourceDir);
                for (i = 0; i < instanceLogFileNames.size(); ++i) {
                    SFTPv3DirectoryEntry file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                    String fileName = file.filename;
                    if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    noFileFound = false;
                    break;
                }
            }
            catch (Exception e) {
                noFileFound = true;
            }
            if (noFileFound) {
                sourceDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
            }
            String[] remoteFileNames = new String[allInstanceLogFileName.size()];
            for (i = 0; i < allInstanceLogFileName.size(); ++i) {
                remoteFileNames[i] = sourceDir + File.separator + allInstanceLogFileName.get(i);
            }
            sftpClient.close();
            SCPClient scpClient = sshL.getSCPClient();
            scpClient.get(remoteFileNames, tempDirectoryOnServer);
        } else if (node.getType().equals("DCOM")) {
            try {
                Vector instanceLogFileNames = this.getInstanceLogFileNames(habitat, targetServer, domain, logger2, instanceName, instanceLogFileDirectory);
                String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                DcomInfo info = new DcomInfo(node);
                WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                    String logFileName = (String)instanceLogFileNames.get(i);
                    WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, sourceDir + File.separator + logFileName);
                    File instanceLogFile = new File(tempDirectoryOnServer + File.separator + logFileName);
                    wrf.copyTo(instanceLogFile);
                }
            }
            catch (WindowsException ex) {
                throw new IOException("Unable to download instance log file from DCOM Instance Node");
            }
        }
    }

    public Vector getInstanceLogFileNames(Habitat habitat, Server targetServer, Domain domain, Logger logger2, String instanceName, String instanceLogFileDirectory) throws IOException {
        Vector<String> instanceLogFileNamesAsString;
        block15: {
            Vector instanceLogFileNames;
            Node node;
            String sNode;
            block14: {
                String fileName;
                File file;
                int i;
                sNode = targetServer.getNodeRef();
                node = domain.getNodes().getNode(sNode);
                instanceLogFileNames = new Vector();
                instanceLogFileNamesAsString = new Vector<String>();
                if (!node.isLocal()) break block14;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                File logsDir = new File(loggingDir);
                File[] allLogFileNames = logsDir.listFiles();
                boolean noFileFound = true;
                if (allLogFileNames != null) {
                    for (i = 0; i < allLogFileNames.length; ++i) {
                        file = allLogFileNames[i];
                        fileName = file.getName();
                        if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                        noFileFound = false;
                    }
                }
                if (!noFileFound) break block15;
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
                logsDir = new File(loggingDir);
                allLogFileNames = logsDir.listFiles();
                for (i = 0; i < allLogFileNames.length; ++i) {
                    file = allLogFileNames[i];
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                }
                break block15;
            }
            if (node.getType().equals("SSH")) {
                String fileName;
                SFTPv3DirectoryEntry file;
                SSHLauncher sshL = this.getSSHL(habitat);
                sshL.init(node, logger2);
                SFTPClient sftpClient = sshL.getSFTPClient();
                boolean noFileFound = true;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                try {
                    instanceLogFileNames = sftpClient.ls(loggingDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                        fileName = file.filename;
                        if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                        noFileFound = false;
                    }
                }
                catch (Exception ex) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
                    instanceLogFileNames = sftpClient.ls(loggingDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                        fileName = file.filename;
                        if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                    }
                }
                sftpClient.close();
            } else if (node.getType().equals("DCOM")) {
                try {
                    String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                    DcomInfo info = new DcomInfo(node);
                    WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                    WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, loggingDir);
                    String[] allLogFileNames = wrf.list();
                    for (int i = 0; i < allLogFileNames.length; ++i) {
                        File file = new File(allLogFileNames[i]);
                        String fileName = file.getName();
                        if (fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                    }
                }
                catch (WindowsException ex) {
                    throw new IOException("Unable to get instance log file names from DCOM Instance Node");
                }
            }
        }
        return instanceLogFileNamesAsString;
    }

    private SSHLauncher getSSHL(Habitat habitat) {
        SSHLauncher sshL = null;
        try {
            sshL = habitat.getComponent(SSHLauncher.class);
        }
        catch (NoClassDefFoundError ex) {
            throw new NoClassDefFoundError(localStrings.getLocalString("collectlogfiles.missingclusterlibraries", "Missing Cluster libraries in your ClassPath."));
        }
        return sshL;
    }

    private File makingDirectory(String path) {
        File targetDir = new File(path);
        boolean created = false;
        boolean deleted = false;
        if (targetDir.exists() && !(deleted = targetDir.delete())) {
            return targetDir;
        }
        created = targetDir.mkdir();
        if (!created) {
            return null;
        }
        return targetDir;
    }

    public String getLoggingDirectoryForNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        String loggingDir = "";
        loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }

    public String getLoggingDirectoryForNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        String loggingDir = "";
        loggingDir = node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }
}

