/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServicesUtil {
    @Inject
    private static Habitat habitat;
    private static final LocalStringManagerImpl _localStrings;
    private static final Logger _logger;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ServerEnvironment env;
    @Inject
    private AuditManager auditManager;
    private CallbackHandler callbackHandler;

    public Habitat getHabitat() {
        return habitat;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public static SecurityServicesUtil getInstance() {
        if (habitat == null) {
            return null;
        }
        return habitat.getComponent(SecurityServicesUtil.class);
    }

    public ProcessEnvironment getProcessEnv() {
        return this.processEnv;
    }

    public boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.processEnv.getProcessType().isServer();
    }

    public boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    static {
        _localStrings = new LocalStringManagerImpl(SecurityServicesUtil.class);
        _logger = LogDomains.getLogger(SecurityServicesUtil.class, "javax.enterprise.system.core.security");
    }
}

