/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourceNamingService;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.naming.JndiProxyObjectFactory;
import com.sun.enterprise.resource.naming.ProxyRefAddr;
import com.sun.enterprise.resource.naming.SerializableObjectRefAddr;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class ExternalJndiResourceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    private static final StringManager localStrings = StringManager.getManager(ExternalJndiResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(ExternalJndiResourceDeployer.class, "javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jndiRes.getJndiName(), applicationName, moduleName);
        this.createExternalJndiResource(jndiRes, resourceInfo);
    }

    public synchronized void deployResource(Object resource) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(jndiRes);
        this.createExternalJndiResource(jndiRes, resourceInfo);
    }

    private void createExternalJndiResource(ExternalJndiResource jndiRes, ResourceInfo resourceInfo) {
        if (ResourcesUtil.createInstance().isEnabled(jndiRes, resourceInfo)) {
            JavaEEResource j2eeRes = ExternalJndiResourceDeployer.toExternalJndiJavaEEResource(jndiRes, resourceInfo);
            this.installExternalJndiResource((com.sun.enterprise.resource.beans.ExternalJndiResource)j2eeRes, resourceInfo);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jndiRes.getJndiName(), "external-jndi-resource"});
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jndiRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(jndiRes, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(jndiRes);
        this.deleteResource(jndiRes, resourceInfo);
    }

    private void deleteResource(ExternalJndiResource jndiResource, ResourceInfo resourceInfo) {
        if (ResourcesUtil.createInstance().isEnabled(jndiResource, resourceInfo)) {
            JavaEEResource j2eeResource = ExternalJndiResourceDeployer.toExternalJndiJavaEEResource(jndiResource, resourceInfo);
            this.uninstallExternalJndiResource(j2eeResource, resourceInfo);
        } else {
            _logger.log(Level.FINEST, "core.resource_disabled", new Object[]{jndiResource.getJndiName(), "external-jndi"});
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ExternalJndiResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installExternalJndiResource(com.sun.enterprise.resource.beans.ExternalJndiResource extJndiRes, ResourceInfo resourceInfo) {
        try {
            Object factory;
            String factoryClass = extJndiRes.getFactoryClass();
            String jndiLookupName = extJndiRes.getJndiLookupName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "installExternalJndiResources resourceName " + resourceInfo + " factoryClass " + factoryClass + " jndiLookupName = " + jndiLookupName);
            }
            if ((factory = ConnectorsUtil.loadObject(factoryClass)) == null) {
                _logger.log(Level.WARNING, "jndi.factory_load_error", factoryClass);
                return;
            }
            if (!(factory instanceof InitialContextFactory)) {
                _logger.log(Level.WARNING, "jndi.factory_class_unexpected", factoryClass);
                return;
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            for (ResourceProperty prop : extJndiRes.getProperties()) {
                env.put(prop.getName(), prop.getValue());
            }
            Context context = null;
            try {
                context = ((InitialContextFactory)factory).getInitialContext(env);
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "jndi.initial_context_error", factoryClass);
                _logger.log(Level.SEVERE, "jndi.initial_context_error_excp", ne.getMessage());
            }
            if (context == null) {
                _logger.log(Level.SEVERE, "jndi.factory_create_error", factoryClass);
                return;
            }
            Reference ref = new Reference(extJndiRes.getResType(), "com.sun.enterprise.resource.naming.JndiProxyObjectFactory", null);
            ref.add(new SerializableObjectRefAddr("resourceInfo", resourceInfo));
            ref.add(new StringRefAddr("jndiLookupName", jndiLookupName));
            ref.add(new StringRefAddr("jndiFactoryClass", factoryClass));
            ref.add(new ProxyRefAddr(extJndiRes.getResourceInfo().getName(), env));
            this.namingService.publishObject(resourceInfo, ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", resourceInfo);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public void uninstallExternalJndiResource(JavaEEResource resource, ResourceInfo resourceInfo) {
        block2: {
            JndiProxyObjectFactory.removeInitialContext(resource.getResourceInfo());
            try {
                this.namingService.unpublishObject(resourceInfo, resourceInfo.getName());
            }
            catch (NamingException e) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Error while unpublishing resource: " + resourceInfo, e);
            }
        }
    }

    public static JavaEEResource toExternalJndiJavaEEResource(ExternalJndiResource rbean, ResourceInfo resourceInfo) {
        com.sun.enterprise.resource.beans.ExternalJndiResource jr = new com.sun.enterprise.resource.beans.ExternalJndiResource(resourceInfo);
        jr.setEnabled(ConnectorsUtil.parseBoolean(rbean.getEnabled()));
        jr.setJndiLookupName(rbean.getJndiLookupName());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List<Property> properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), property.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }
}

