/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.interfaces.QueryParser;
import com.sun.enterprise.deployment.runtime.IASEjbCMPFinder;
import com.sun.enterprise.deployment.runtime.PrefetchDisabledDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASEjbCMPEntityDescriptor
extends EjbCMPEntityDescriptor {
    private transient Class ejbClass = null;
    private String pcImplClassName = null;
    private String concreteImplClassName = null;
    private String ejbImplClassName = null;
    private String mappingProperties;
    private transient ClassLoader jcl = null;
    private String uniqueName = null;
    private String moduleDir = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(IASEjbCMPEntityDescriptor.class);
    private static final Logger _logger = DOLUtils.getDefaultLogger();
    private static final char DOT = '.';
    private static final char LIST_START = '(';
    private static final char LIST_END = ')';
    private static final char LIST_SEPARATOR = ',';
    private static final char NAME_PART_SEPARATOR = '_';
    private static final char NAME_CONCATENATOR = ' ';
    private static final String FIND = "find";
    private static final String EJB_SELECT = "ejbSelect";
    private static final String JDOSTATE = "_JDOState";
    private static final String CONCRETE_IMPL = "_ConcreteImpl";
    private static final String MAPPINGEXT = ".mapping";
    private transient Collection finders = null;
    private transient Collection selectors = null;
    private transient QueryParser queryParser = null;
    private PrefetchDisabledDescriptor prefetchDisabledDescriptor = null;
    private static final Map conversionTable = IASEjbCMPEntityDescriptor.createConversionTable();
    private Map oneOneFinders = new HashMap();
    private List arrOneOneFinders = new ArrayList();

    private void addAllInterfaceMethodsIn(Collection methodDescriptors, Class c) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            methodDescriptors.add(methods[i]);
        }
    }

    private void addAllUniqueInterfaceMethodsIn(Collection methodDescriptors, Class c) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (this.findEquivalentMethod(methodDescriptors, methods[i]) != null) continue;
            methodDescriptors.add(methods[i]);
        }
    }

    public Collection getAllUniqueMethods() {
        HashSet methods = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllUniqueInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", t);
            throw new RuntimeException(t.getMessage());
        }
        return methods;
    }

    public Collection getAllMethods() {
        HashSet methods = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getHomeClassName()));
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getRemoteClassName()));
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalHomeClassName()));
                this.addAllInterfaceMethodsIn(methods, this.jcl.loadClass(this.getLocalClassName()));
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "enterprise.deployment_error_loading_class_excp", t);
            throw new RuntimeException(t.getMessage());
        }
        return methods;
    }

    private Method findEquivalentMethod(Collection methods, Method methodToMatch) {
        if (methods == null) {
            return null;
        }
        Method matchedMethod = null;
        for (Method next : methods) {
            if (!this.methodsEqual(next, methodToMatch, false)) continue;
            matchedMethod = next;
            break;
        }
        return matchedMethod;
    }

    private boolean methodsEqual(Method m1, Method m2, boolean compareDeclaringClass) {
        String m2Name;
        boolean equal = false;
        String m1Name = m1.getName();
        if (m1Name.equals(m2Name = m2.getName())) {
            Class<?>[] m2ParamTypes;
            Class<?>[] m1ParamTypes;
            String m1DeclaringClass = m1.getDeclaringClass().getName();
            String m2DeclaringClass = m2.getDeclaringClass().getName();
            if ((!compareDeclaringClass || m1DeclaringClass.equals(m2DeclaringClass)) && (m1ParamTypes = m1.getParameterTypes()).length == (m2ParamTypes = m2.getParameterTypes()).length) {
                equal = true;
                for (int pIndex = 0; pIndex < m1ParamTypes.length; ++pIndex) {
                    String m2ParamClass;
                    String m1ParamClass = m1ParamTypes[pIndex].getName();
                    if (m1ParamClass.equals(m2ParamClass = m2ParamTypes[pIndex].getName())) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    private Class getEjbClass() {
        if (this.ejbClass == null) {
            String ejbClassName = this.getEjbClassName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("@@@@@@ Ejb name is  " + ejbClassName);
            }
            if (this.jcl == null) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_missing_classloader", "IASEjbCMPEntityDescriptor.getEjbClass");
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
            try {
                this.ejbClass = Class.forName(ejbClassName, true, this.jcl);
            }
            catch (ClassNotFoundException e) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_cannot_find_ejbclass", ejbClassName);
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
        }
        return this.ejbClass;
    }

    public Collection getFinders() {
        if (this.finders == null) {
            String ejbClassName = this.getEjbClassName();
            Class ejbClass = this.getEjbClass();
            if (super.isRemoteInterfacesSupported()) {
                Class<?> remoteHomeIntf = null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("@@@@@@ " + ejbClassName + " : Remote Interface is supported ");
                }
                try {
                    remoteHomeIntf = ejbClass.getClassLoader().loadClass(super.getHomeClassName());
                }
                catch (ClassNotFoundException ex) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", ex);
                    return null;
                }
                this.finders = this.getFinders(remoteHomeIntf);
                if (_logger.isLoggable(Level.FINE)) {
                    for (Method remoteHomeMethod : this.finders) {
                        _logger.fine("@@@@ adding Remote interface method " + remoteHomeMethod.getName());
                    }
                }
            }
            if (super.isLocalInterfacesSupported()) {
                Class<?> localHomeIntf = null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("@@@@@@ " + ejbClassName + ":  Local Interface is supported ");
                }
                try {
                    localHomeIntf = ejbClass.getClassLoader().loadClass(super.getLocalHomeClassName());
                }
                catch (ClassNotFoundException ex) {
                    _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", ex);
                    return null;
                }
                Collection localFinders = this.getFinders(localHomeIntf);
                if (this.finders == null) {
                    this.finders = localFinders;
                } else if (localFinders != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("@@@@@@ Trying to remove the Common Elements from HashSet....... ");
                    }
                    for (Method localHomeMethod : localFinders) {
                        if (this.findEquivalentMethod(this.finders, localHomeMethod) != null) continue;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("@@@@ adding local interface method " + localHomeMethod.getName());
                        }
                        this.finders.add(localHomeMethod);
                    }
                }
            }
            if (this.finders == null) {
                this.finders = new HashSet();
            }
        }
        return this.finders;
    }

    public Collection getFinders(Class homeIntf) {
        Method[] methods = homeIntf.getMethods();
        HashSet<Method> finders = new HashSet<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith(FIND)) continue;
            finders.add(methods[i]);
        }
        return finders;
    }

    public void setClassLoader(ClassLoader jcl) {
        this.jcl = jcl;
    }

    public ClassLoader getClassLoader() {
        return this.jcl;
    }

    public Collection getAllPersistentFields() {
        int i;
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> fields = new HashMap<String, PersistentFieldInfo>();
        for (i = 0; i < persFields.length; ++i) {
            fields.put(persFields[i].name, persFields[i]);
        }
        for (i = 0; i < pkeyFields.length; ++i) {
            fields.put(pkeyFields[i].name, pkeyFields[i]);
        }
        return fields.values();
    }

    public Collection getPersistentFields() {
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        HashMap<String, PersistentFieldInfo> fields = new HashMap<String, PersistentFieldInfo>();
        for (int i = 0; i < persFields.length; ++i) {
            fields.put(persFields[i].name, persFields[i]);
        }
        return fields.values();
    }

    public Collection getPrimaryKeyFields() {
        PersistenceDescriptor pers = this.getPersistenceDescriptor();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        HashMap<String, PersistentFieldInfo> pkey = new HashMap<String, PersistentFieldInfo>();
        for (int i = 0; i < pkeyFields.length; ++i) {
            pkey.put(pkeyFields[i].name, pkeyFields[i]);
        }
        return pkey.values();
    }

    public Collection getSelectors() {
        if (this.selectors == null) {
            this.selectors = new HashSet();
            Class ejbClass = this.getEjbClass();
            Method[] methods = ejbClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith(EJB_SELECT)) continue;
                this.selectors.add(methods[i]);
            }
        }
        return this.selectors;
    }

    public String getBaseName(String className) {
        if (className == null) {
            return null;
        }
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    public IASEjbCMPEntityDescriptor() {
    }

    public IASEjbCMPEntityDescriptor(EjbDescriptor other) {
        super(other);
        this.setPersistenceType("Container");
        if (other instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)other;
        }
    }

    public void setPcImplClassName(String name) {
        this.pcImplClassName = name;
    }

    public String getUniqueName() {
        if (this.uniqueName == null) {
            EjbBundleDescriptor bundle2 = this.getEjbBundleDescriptor();
            Application application = bundle2.getApplication();
            StringBuffer rc = new StringBuffer().append(this.getName()).append(' ').append(application.getRegistrationName());
            if (!application.isVirtual()) {
                rc.append(' ').append(bundle2.getModuleDescriptor().getArchiveUri());
            }
            this.uniqueName = this.getBaseName(this.getEjbClassName()) + this.getUniqueNumber(rc.toString());
        }
        return this.uniqueName;
    }

    public String getUniqueNumber(String num) {
        String newNum = "" + num.hashCode();
        newNum = newNum.replace('-', '_');
        return newNum;
    }

    public String getPcImplClassName() {
        if (this.pcImplClassName == null) {
            this.pcImplClassName = this.getUniqueName() + JDOSTATE;
            String packageName = this.getPackageName(this.getEjbClassName());
            if (packageName != null) {
                this.pcImplClassName = packageName + '.' + this.pcImplClassName;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("##### PCImplClass Name is " + this.pcImplClassName);
            }
        }
        return this.pcImplClassName;
    }

    public void setConcreteImplClassName(String name) {
        this.concreteImplClassName = name;
    }

    public String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    public String getEjbImplClassName() {
        if (this.ejbImplClassName == null) {
            String packageName = this.getPackageName(this.getEjbClassName());
            this.ejbImplClassName = this.getConcreteImplClassName();
            if (packageName != null) {
                this.ejbImplClassName = packageName + '.' + this.ejbImplClassName;
            }
        }
        return this.ejbImplClassName;
    }

    public String getConcreteImplClassName() {
        if (this.concreteImplClassName == null) {
            this.concreteImplClassName = this.getUniqueName() + CONCRETE_IMPL;
        }
        return this.concreteImplClassName;
    }

    public void setModuleDir(String moduleRootDir) {
        this.moduleDir = moduleRootDir;
    }

    public String getModuleDir() {
        if (this.moduleDir != null) {
            return this.moduleDir;
        }
        return null;
    }

    public void setMappingProperties(String mappingProperties) {
        this.mappingProperties = mappingProperties;
    }

    public String getMappingProperties() {
        return this.mappingProperties;
    }

    public boolean classesChanged() {
        return false;
    }

    public void setQueryParser(QueryParser inParser) {
        this.queryParser = inParser;
    }

    public QueryParser getQueryParser() {
        return this.queryParser;
    }

    private static Map createConversionTable() {
        HashMap<String, String> conversionTable = new HashMap<String, String>();
        conversionTable.put("Boolean", "java.lang.Boolean");
        conversionTable.put("Byte", "java.lang.Byte");
        conversionTable.put("Character", "java.lang.Character");
        conversionTable.put("Double", "java.lang.Double");
        conversionTable.put("Float", "java.lang.Float");
        conversionTable.put("Integer", "java.lang.Integer");
        conversionTable.put("Long", "java.lang.Long");
        conversionTable.put("Number", "java.lang.Number");
        conversionTable.put("Short", "java.lang.Short");
        conversionTable.put("String", "java.lang.String");
        conversionTable.put("Object", "java.lang.Object");
        return conversionTable;
    }

    private String getFullyQualifiedType(String type2) {
        String knownType = (String)conversionTable.get(type2);
        return knownType == null ? type2 : knownType;
    }

    public PrefetchDisabledDescriptor getPrefetchDisabledDescriptor() {
        return this.prefetchDisabledDescriptor;
    }

    public void setPrefetchDisabledDescriptor(PrefetchDisabledDescriptor prefetchDisabledDescriptor) {
        this.prefetchDisabledDescriptor = prefetchDisabledDescriptor;
    }

    public void addOneOneFinder(IASEjbCMPFinder finder) {
        this.arrOneOneFinders.add(finder);
    }

    public Map getOneOneFinders() {
        if (!this.arrOneOneFinders.isEmpty()) {
            if (this.queryParser == null) {
                String msg = localStrings.getLocalString("enterprise.deployment.error_missing_queryparser", "IASEjbCMPEntityDescriptor.getOneOneFinders");
                _logger.log(Level.WARNING, msg);
                throw new RuntimeException(msg);
            }
            for (IASEjbCMPFinder finder : this.arrOneOneFinders) {
                String key = this.generateKey(finder, this.queryParser);
                this.oneOneFinders.put(key, finder);
            }
            this.arrOneOneFinders.clear();
        }
        return this.oneOneFinders;
    }

    private String generateKey(IASEjbCMPFinder finder, QueryParser parser) {
        StringBuffer key = new StringBuffer();
        key.append(finder.getMethodName()).append('(');
        String queryParams = finder.getQueryParameterDeclaration();
        Iterator iter = parser.parameterTypeIterator(queryParams);
        while (iter.hasNext()) {
            String type2 = (String)iter.next();
            key.append(this.getFullyQualifiedType(type2));
            if (!iter.hasNext()) continue;
            key.append(',');
        }
        key.append(')');
        return key.toString().intern();
    }

    public IASEjbCMPFinder getIASEjbCMPFinder(Method method) {
        if (this.findEquivalentMethod(this.getFinders(), method) == null) {
            return null;
        }
        String methodName = method.getName();
        StringBuffer key = new StringBuffer();
        key.append(methodName);
        key.append('(');
        Class<?>[] paramList = method.getParameterTypes();
        for (int index = 0; index < paramList.length; ++index) {
            if (index > 0) {
                key.append(',');
            }
            key.append(paramList[index].getName());
        }
        key.append(')');
        return (IASEjbCMPFinder)this.getOneOneFinders().get(key.toString());
    }
}

