/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.LocalPassword;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ContractProvided(value=JMXAuthenticator.class)
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    SecuritySniffer snif;
    @Inject
    volatile SecurityService ss;
    @Inject
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    private AuthTokenManager authTokenManager;
    private SSLUtils sslUtils = null;
    private SecureAdmin secureAdmin;
    @Inject
    ServerEnvironment serverEnv;
    private static LocalStringManagerImpl lsm = new LocalStringManagerImpl(GenericAdminAuthenticator.class);
    private static final Logger logger = LogDomains.getLogger(GenericAdminAuthenticator.class, "javax.enterprise.system.tools.admin");
    private KeyStore truststore = null;
    private Map<String, Principal> serverPrincipals = new HashMap<String, Principal>();

    @Override
    public void postConstruct() {
        this.secureAdmin = this.domain.getSecureAdmin();
        if (this.as.usesFileRealm()) {
            try {
                String adminKeyFilePath;
                FileRealm fr;
                AuthRealm ar = this.as.getAssociatedAuthRealm();
                if (FileRealm.class.getName().equals(ar.getClassname()) && !(fr = new FileRealm(adminKeyFilePath = ar.getPropertyValue("file"))).hasAuthenticatableUser()) {
                    String emsg = lsm.getLocalString("secure.admin.empty.password", "The server requires a valid admin password to be set before it can start. Please set a password using the change-admin-password command.");
                    logger.log(Level.SEVERE, emsg);
                    throw new IllegalStateException(emsg);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage());
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public AdminAccessController.Access loginAsAdmin(String user, String password, String realm, String originHost) throws LoginException {
        return this.loginAsAdmin(user, password, realm, originHost, Collections.EMPTY_MAP, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AdminAccessController.Access loginAsAdmin(String user, String password, String realm, String originHost, Map<String, String> authRelatedHeaders, Principal requestPrincipal) throws LoginException {
        SpecialAdminIndicatorChecker adminIndicatorChecker = new SpecialAdminIndicatorChecker(this.secureAdmin, logger, authRelatedHeaders, originHost);
        if (adminIndicatorChecker.result() == SpecialAdminIndicatorChecker.Result.MISMATCHED) {
            return AdminAccessController.Access.NONE;
        }
        boolean isLocal = this.isLocalPassword(user, password);
        if (isLocal) {
            logger.fine("Accepted locally-provisioned password authentication");
            return AdminAccessController.Access.FULL;
        }
        boolean isTokenAuth = this.authenticateUsingOneTimeToken(authRelatedHeaders.get("X-GlassFish-authToken"));
        if (isTokenAuth) {
            logger.log(Level.FINE, "Authenticated using one-time auth token");
            return AdminAccessController.Access.FULL;
        }
        boolean isCertAuth = this.authorizeUsingCert(requestPrincipal);
        if (isCertAuth) {
            logger.log(Level.FINE, "Authenticated SSL client auth principal {0}", requestPrincipal.getName());
            return AdminAccessController.Access.FULL;
        }
        AdminAccessController.Access access = this.checkRemoteAccess(originHost, adminIndicatorChecker.result() == SpecialAdminIndicatorChecker.Result.MATCHED);
        if (!access.isOK()) {
            logger.log(Level.FINE, "Rejected remote access attempt, returning {0}", access.name());
            return access;
        }
        if (this.as.usesFileRealm()) {
            boolean isUsernamePasswordAuth = this.handleFileRealm(user, password);
            logger.log(Level.FINE, "Not an oterwise \"trusted sender\"; file realm user authentication {1} for admin user {0}", new Object[]{user, isUsernamePasswordAuth ? "passed" : "failed"});
            if (isUsernamePasswordAuth) {
                if (this.serverEnv.isInstance()) {
                    if (this.isAuthorizedInternalUser(user)) {
                        access = AdminAccessController.Access.FULL;
                        logger.log(Level.FINE, "Granting access to this instance; user is set up as an internal admin user");
                    } else {
                        access = AdminAccessController.Access.READONLY;
                        logger.log(Level.FINE, "Restricting the admin request to this instance to read-only access");
                    }
                } else {
                    logger.log(Level.FINE, "Granting admin access for this request; user/password authenticated as a valid admin account");
                }
            } else {
                String userToDisplay;
                String extraMsg = "";
                try {
                    userToDisplay = URLEncoder.encode(user, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    userToDisplay = "???";
                    extraMsg = ex.getLocalizedMessage();
                }
                String msg = lsm.getLocalString("authentication.failed", "User [{0}] from host {1} does not have administration access", userToDisplay, originHost) + extraMsg;
                logger.log(Level.INFO, msg);
                access = AdminAccessController.Access.NONE;
            }
            return access;
        }
        ClassLoader pc = null;
        boolean hack = false;
        boolean authenticated = false;
        try {
            pc = Thread.currentThread().getContextClassLoader();
            if (!this.sc.getCommonClassLoader().equals(pc)) {
                Thread.currentThread().setContextClassLoader(this.sc.getCommonClassLoader());
                hack = true;
            }
            Inhabitant<SecurityLifecycle> sl = this.habitat.getInhabitantByType(SecurityLifecycle.class);
            sl.get();
            this.snif.setup(System.getProperty("com.sun.aas.installRoot") + "/modules/security", Logger.getAnonymousLogger());
            LoginContextDriver.login(user, password.toCharArray(), realm);
            authenticated = true;
            boolean isConsideredInAdminGroup = this.as.getAssociatedAuthRealm().getGroupMapping() == null || this.ensureGroupMembership(user, realm);
            AdminAccessController.Access access2 = isConsideredInAdminGroup ? AdminAccessController.Access.FULL : AdminAccessController.Access.NONE;
            return access2;
        }
        catch (Exception e) {
            AdminAccessController.Access access3 = AdminAccessController.Access.NONE;
            return access3;
        }
        finally {
            if (hack) {
                Thread.currentThread().setContextClassLoader(pc);
            }
        }
    }

    private AdminAccessController.Access checkRemoteAccess(String originHost, boolean adminIndicatorCheckerMatched) {
        AdminAccessController.Access grantedAccess;
        if (this.serverEnv.isDas()) {
            if (NetUtils.isThisHostLocal(originHost) || SecureAdmin.Util.isEnabled(this.secureAdmin)) {
                grantedAccess = AdminAccessController.Access.FULL;
            } else {
                logger.log(Level.FINE, "Forbidding the admin request to the DAS; the request is remote and secure admin is not enabled");
                grantedAccess = AdminAccessController.Access.FORBIDDEN;
            }
        } else if (adminIndicatorCheckerMatched) {
            grantedAccess = AdminAccessController.Access.FULL;
            logger.log(Level.FINE, "Granting access for the admin request to this instance; the request contained the correct unique ID");
        } else {
            grantedAccess = AdminAccessController.Access.READONLY;
            logger.log(Level.FINE, "Granting read-only access for the admin request to this instance; full access was refused because the request lacked the unique ID or contained an incorrect one");
        }
        return grantedAccess;
    }

    private boolean isAuthorizedInternalUser(String username) {
        for (SecureAdminInternalUser u : SecureAdmin.Util.secureAdminInternalUsers(this.secureAdmin)) {
            if (!u.getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }

    private boolean authorizeUsingCert(Principal reqPrincipal) throws LoginException {
        if (reqPrincipal == null) {
            return false;
        }
        try {
            if (this.isPrincipalAuthorized(reqPrincipal)) {
                logger.log(Level.FINE, "Cert {0} recognized as authorized admin cert", ((Object)reqPrincipal).toString());
                return true;
            }
            logger.log(Level.FINE, "Authenticated cert {0} is not separately authorized for admin operations", ((Object)reqPrincipal).toString());
            return false;
        }
        catch (Exception ex) {
            LoginException loginEx = new LoginException();
            loginEx.initCause(ex);
            throw loginEx;
        }
    }

    private boolean isPrincipalAuthorized(Principal reqPrincipal) {
        String principalName = reqPrincipal.getName();
        for (SecureAdminPrincipal configPrincipal : SecureAdmin.Util.secureAdminPrincipals(this.secureAdmin, this.habitat)) {
            if (!configPrincipal.getDn().equals(principalName)) continue;
            return true;
        }
        return false;
    }

    private boolean authenticateUsingOneTimeToken(String oneTimeAuthToken) {
        return oneTimeAuthToken == null ? false : this.authTokenManager.consumeToken(oneTimeAuthToken);
    }

    private boolean ensureGroupMembership(String user, String realm) {
        try {
            SecurityContext secContext = SecurityContext.getCurrent();
            Set ps = secContext.getPrincipalSet();
            for (Object principal : ps) {
                Group group2;
                if (!(principal instanceof Group) || !(group2 = (Group)principal).getName().equals("asadmin")) continue;
                return true;
            }
            logger.fine("User is not the member of the special admin group");
            return false;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "User is not the member of the special admin group: {0}", e.getMessage());
            return false;
        }
    }

    private boolean handleFileRealm(String user, String password) throws LoginException {
        if (user == null || user.length() == 0) {
            String defuser = this.getDefaultAdminUser();
            if (defuser != null) {
                user = defuser;
                logger.log(Level.FINE, "Using default user: {0}", defuser);
            } else {
                logger.fine("No default user");
            }
        }
        try {
            AuthRealm ar = this.as.getAssociatedAuthRealm();
            if (FileRealm.class.getName().equals(ar.getClassname())) {
                String adminKeyFilePath = ar.getPropertyValue("file");
                FileRealm fr = new FileRealm(adminKeyFilePath);
                FileRealmUser fru = (FileRealmUser)fr.getUser(user);
                for (String group2 : fru.getGroups()) {
                    if (!group2.equals("asadmin")) continue;
                    return fr.authenticate(user, password.toCharArray()) != null;
                }
                return false;
            }
        }
        catch (NoSuchUserException ue) {
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        return false;
    }

    private String getDefaultAdminUser() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            throw new RuntimeException("Warning: Configuration is bad, realm: " + this.as.getAuthRealmName() + " does not exist!");
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            logger.fine("CAN'T FIND DEFAULT ADMIN USER: IT'S NOT A FILE REALM");
            return null;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            logger.fine("CAN'T FIND DEFAULT ADMIN USER: THE KEYFILE DOES NOT EXIST");
            return null;
        }
        try {
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            Enumeration<String> users = fr.getUserNames();
            if (users.hasMoreElements()) {
                FileRealmUser fru;
                String[] arr$;
                int len$;
                int i$;
                String au = users.nextElement();
                if (!users.hasMoreElements() && (i$ = 0) < (len$ = (arr$ = (fru = (FileRealmUser)fr.getUser(au)).getGroups()).length)) {
                    String group2 = arr$[i$];
                    if (group2.equals("asadmin")) {
                        logger.log(Level.FINE, "Attempting access using default admin user: {0}", au);
                    }
                    return au;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private boolean isLocalPassword(String user, String password) {
        if (!this.localPassword.isLocalPassword(password)) {
            logger.finest("Password is not the local password");
            return false;
        }
        logger.fine("Allowing access using local password");
        return true;
    }

    @Override
    public Subject authenticate(Object credentials) {
        String realm;
        String user = "";
        String password = "";
        String host = null;
        if (credentials instanceof String[]) {
            String[] up = (String[])credentials;
            if (up.length == 1) {
                user = up[0];
            } else if (up.length >= 2) {
                user = up[0];
                password = up[1];
                if (password == null) {
                    password = "";
                }
            }
            if (up.length > 2) {
                host = up[2];
            } else {
                try {
                    host = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if ((realm = this.as.getSystemJmxConnector().getAuthRealmName()) == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            AdminAccessController.Access result = this.loginAsAdmin(user, password, realm, host);
            if (!result.isOK()) {
                String msg = lsm.getLocalString("authentication.failed", "User [{0}] from host {1} does not have administration access", user, host);
                logger.log(Level.INFO, msg);
                throw new SecurityException(msg);
            }
            return null;
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpecialAdminIndicatorChecker {
        private final Result _result;

        private SpecialAdminIndicatorChecker(SecureAdmin sa, Logger logger2, Map<String, String> authRelatedHeaders, String originHost) {
            String requestSpecialAdminIndicator = authRelatedHeaders.get("X-GlassFish-admin");
            if (requestSpecialAdminIndicator != null) {
                if (requestSpecialAdminIndicator.equals(SecureAdmin.Util.configuredAdminIndicator(sa))) {
                    this._result = Result.MATCHED;
                    logger2.fine("Admin request contains expected domain ID");
                } else {
                    String msg = lsm.getLocalString("foreign.domain.ID", "An admin request arrived from {0} with the domain identifier {1} which does not match the domain identifier {2} configured for this server's domain; rejecting the request", originHost, requestSpecialAdminIndicator, sa.getSpecialAdminIndicator());
                    logger2.log(Level.WARNING, msg);
                    this._result = Result.MISMATCHED;
                }
            } else {
                logger2.fine("Admin request contains no domain ID; this is OK - continuing");
                this._result = Result.NOT_IN_REQUEST;
            }
        }

        private Result result() {
            return this._result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Result {
            NOT_IN_REQUEST,
            MATCHED,
            MISMATCHED;

        }
    }
}

