/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ResourcePrincipal;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.resource.common.GenericResourceInfo;
import org.glassfish.resource.common.PoolInfo;

public class ConnectorAdminServiceUtils
implements ConnectorConstants {
    private ConnectorAdminServiceUtils() {
    }

    public static ResourcePrincipal getDefaultResourcePrincipal(PoolInfo poolInfo) throws NamingException {
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        Context ic = ConnectorRuntime.getRuntime().getNamingManager().getInitialContext();
        connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
        Set mcfConfigProperties = cdi.getMCFConfigProperties();
        Iterator mcfConfPropsIter = mcfConfigProperties.iterator();
        String userName = "";
        String password = "";
        while (mcfConfPropsIter.hasNext()) {
            ConnectorConfigProperty prop = (ConnectorConfigProperty)mcfConfPropsIter.next();
            if (prop.getName().toUpperCase().equals("USERNAME") || prop.getName().toUpperCase().equals("USER")) {
                userName = prop.getValue();
                continue;
            }
            if (!prop.getName().toUpperCase().equals("PASSWORD")) continue;
            password = prop.getValue();
        }
        return new ResourcePrincipal(userName, password);
    }

    private static String getReservePrefixedJNDIName(String prefix, String resourceName) {
        return prefix + resourceName;
    }

    public static String getReservePrefixedJNDINameForPool(PoolInfo poolInfo) {
        String name = ConnectorAdminServiceUtils.getReservePrefixedJNDIName("__SYSTEM/pools/", poolInfo.getName());
        return ConnectorAdminServiceUtils.getScopedName(poolInfo, name);
    }

    private static String getScopedName(GenericResourceInfo resourceInfo, String name) {
        if (resourceInfo.getName().startsWith("java:app/")) {
            if (!name.startsWith("java:app/")) {
                name = "java:app/" + name;
            }
        } else if (resourceInfo.getName().startsWith("java:module/") && !name.startsWith("java:module/")) {
            name = "java:module/" + name;
        }
        return name;
    }

    public static String getReservePrefixedJNDINameForDescriptor(String moduleName) {
        return ConnectorAdminServiceUtils.getReservePrefixedJNDIName("__SYSTEM/descriptors/", moduleName);
    }

    public static String getReservePrefixedJNDINameForResource(String moduleName) {
        return ConnectorAdminServiceUtils.getReservePrefixedJNDIName("__SYSTEM/resource/", moduleName);
    }

    public static String getOriginalResourceName(String reservePrefixedJNDIName) {
        String prefix = null;
        if (reservePrefixedJNDIName.startsWith("__SYSTEM/pools/")) {
            prefix = "__SYSTEM/pools/";
        } else if (reservePrefixedJNDIName.startsWith("__SYSTEM/descriptors/")) {
            prefix = "__SYSTEM/descriptors/";
        } else if (reservePrefixedJNDIName.startsWith("__SYSTEM/resource/")) {
            prefix = "__SYSTEM/resource/";
        }
        return prefix == null ? reservePrefixedJNDIName : reservePrefixedJNDIName.substring(prefix.length());
    }

    public static boolean isEmbeddedConnectorModule(String moduleName) {
        return moduleName.indexOf("#") != -1;
    }

    public static String getApplicationName(String moduleName) {
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(moduleName)) {
            int idx = moduleName.indexOf("#");
            return moduleName.substring(0, idx);
        }
        return null;
    }

    public static String getConnectorModuleName(String moduleName) {
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(moduleName)) {
            int idx = moduleName.indexOf("#");
            return moduleName.substring(idx + 1);
        }
        return moduleName;
    }

    public static boolean isJMSRA(String moduleName) {
        return moduleName.equalsIgnoreCase("jmsra");
    }
}

