/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.connector.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.Connector;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="connector")
public class ConnectorHandler
extends AbstractArchiveHandler {
    @Inject
    private ConnectorsClassLoaderUtil loader;
    private static final Class[] connectorAnnotations = new Class[]{Connector.class};
    private Logger _logger = LogDomains.getLogger(ConnectorHandler.class, "javax.enterprise.resource.resourceadapter");

    public String getArchiveType() {
        return "rar";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        boolean handles = DeploymentUtils.isRAR(archive);
        if (!handles && archive instanceof FileArchive) {
            GenericAnnotationDetector detector = new GenericAnnotationDetector(connectorAnnotations);
            handles = detector.hasAnnotationInArchive(archive);
        }
        return handles;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        try {
            String moduleDir = context.getSource().getURI().getPath();
            String moduleName = context.getSource().getName();
            List<URI> appLibs = null;
            try {
                appLibs = context.getAppLibs();
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "installed libraries (--applibs and EXTENSTION_LIST) for rar [ " + moduleName + " ] :  " + appLibs);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (this.isEmbedded(context)) {
                String applicationName = ConnectorsUtil.getApplicationName(context);
                String embeddedRarName = ConnectorsUtil.getEmbeddedRarModuleName(applicationName, moduleName);
                return this.loader.createRARClassLoader(moduleDir, parent.getParent().getParent(), embeddedRarName, appLibs);
            }
            return this.loader.createRARClassLoader(moduleDir, null, moduleName, appLibs);
        }
        catch (ConnectorRuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isEmbedded(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        return archive != null && archive.getParentArchive() != null;
    }
}

