/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class CommandThreadPool
implements Startup,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private Domain domain;
    @Inject
    private Logger logger;
    private ExecutorService svc;

    @Override
    public void postConstruct() {
        List<NetworkListener> lss;
        NetworkConfig nwc;
        if (this.serverEnv.isInstance()) {
            return;
        }
        int poolSize = 5;
        Config svrConfig = this.domain.getConfigNamed("server-config");
        if (svrConfig != null && (nwc = svrConfig.getNetworkConfig()) != null && (lss = nwc.getNetworkListeners().getNetworkListener()) != null && !lss.isEmpty()) {
            for (NetworkListener ls : lss) {
                if (!"admin-listener".equals(ls.getName()) || ls.findThreadPool() == null) continue;
                poolSize = Integer.valueOf(ls.findThreadPool().getMaxThreadPoolSize());
            }
        }
        this.svc = Executors.newFixedThreadPool(poolSize, new InstanceStateThreadFactory());
    }

    public Future<InstanceCommandResult> submitJob(InstanceCommand ice, InstanceCommandResult r) {
        FutureTask<InstanceCommandResult> t = new FutureTask<InstanceCommandResult>((Runnable)((Object)ice), r);
        return this.svc.submit(t, r);
    }

    @Override
    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    private class InstanceStateThreadFactory
    implements ThreadFactory {
        private InstanceStateThreadFactory() {
        }

        public Thread newThread(Runnable runnableObj) {
            Thread t = new Thread(runnableObj);
            t.setDaemon(true);
            return t;
        }
    }
}

