/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class V2ToV3ConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    private List<String> oldJvmOptions;
    private final List<String> newJvmOptions = new ArrayList<String>();
    private static final String[] BASE_REMOVAL_LIST = new String[]{"-Djavax.management.builder.initial", "-Dsun.rmi.dgc.server.gcInterval", "-Dsun.rmi.dgc.client.gcInterval", "-Dcom.sun.enterprise.taglibs", "-Dcom.sun.enterprise.taglisteners", "-XX:LogFile"};
    private static final String[] ADD_LIST = new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+LogVMOutput", "-XX:LogFile=${com.sun.aas.instanceRoot}/logs/jvm.log", "-Djava.awt.headless=true", "-DANTLR_USE_DIRECT_CLASS_LOADING=true", "-Dosgi.shell.telnet.maxconn=1", "-Dosgi.shell.telnet.ip=127.0.0.1", "-Dgosh.args=--noshutdown -c noop=true", "-Dfelix.fileinstall.dir=${com.sun.aas.installRoot}/modules/autostart/", "-Dfelix.fileinstall.poll=5000", "-Dfelix.fileinstall.debug=3", "-Dfelix.fileinstall.bundles.new.start=true", "-Dfelix.fileinstall.bundles.startTransient=true", "-Dfelix.fileinstall.disableConfigSave=false", "-Dfelix.fileinstall.log.level=2", "-Djavax.management.builder.initial=com.sun.enterprise.v3.admin.AppServerMBeanServerBuilder", "-Dorg.glassfish.web.rfc2109_cookie_names_enforced=false", "-Djava.ext.dirs=${com.sun.aas.javaRoot}/lib/ext${path.separator}${com.sun.aas.javaRoot}/jre/lib/ext${path.separator}${com.sun.aas.instanceRoot}/lib/ext"};
    private static final String[] ADD_LIST_DAS = new String[]{"-Dosgi.shell.telnet.port=6666"};
    private static final String[] ADD_LIST_NOT_DAS = new String[]{"-Dosgi.shell.telnet.port=${OSGI_SHELL_TELNET_PORT}"};
    private static final List<String> REMOVAL_LIST = new ArrayList<String>();

    public void postConstruct() {
        if (this.configs == null || this.configs.getConfig() == null || this.configs.getConfig().isEmpty()) {
            return;
        }
        try {
            for (Config c : this.configs.getConfig()) {
                JavaConfig jc = c.getJavaConfig();
                if (jc == null) continue;
                this.newJvmOptions.clear();
                this.oldJvmOptions = Collections.unmodifiableList(jc.getJvmOptions());
                this.doAdditions("server-config".equals(c.getName()));
                this.doRemovals();
                ConfigSupport.apply(new JavaConfigChanger(), jc);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading jvm-options from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }

    private void doRemovals() {
        for (String s : this.oldJvmOptions) {
            if (this.shouldRemove(s)) continue;
            this.newJvmOptions.add(s);
        }
    }

    private void doAdditions(boolean isDas) {
        this.doAdditionsFrom(ADD_LIST);
        if (isDas) {
            this.doAdditionsFrom(ADD_LIST_DAS);
        } else {
            this.doAdditionsFrom(ADD_LIST_NOT_DAS);
        }
    }

    private void doAdditionsFrom(String[] strings) {
        for (String s : strings) {
            this.newJvmOptions.add(s);
        }
    }

    private boolean shouldRemove(String option) {
        if (!this.ok(option)) {
            return true;
        }
        for (String s : REMOVAL_LIST) {
            if (!option.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        Collections.addAll(REMOVAL_LIST, BASE_REMOVAL_LIST);
        Collections.addAll(REMOVAL_LIST, ADD_LIST);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaConfigChanger
    implements SingleConfigCode<JavaConfig> {
        private JavaConfigChanger() {
        }

        @Override
        public Object run(JavaConfig jc) throws PropertyVetoException, TransactionFailure {
            jc.setJvmOptions(V2ToV3ConfigUpgrade.this.newJvmOptions);
            return jc;
        }
    }
}

