/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.InstallNodeBaseCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileCopyProgress;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemoteScripter;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="install-node-dcom")
@Scoped(value=PerLookup.class)
public class InstallNodeDcomCommand
extends InstallNodeBaseCommand {
    @Param(name="windowsuser", shortName="w", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(name="windowsdomain", shortName="d", optional=true, defaultValue="")
    private String windowsDomain;
    private final List<HostAndCredentials> credentials = new ArrayList<HostAndCredentials>();
    private String remoteInstallDirString;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        for (String host : this.hosts) {
            if (!NetUtils.isThisHostLocal(host)) continue;
            throw new CommandException(Strings.get("install.node.nolocal", host));
        }
        if (this.windowsDomain != null && this.windowsDomain.isEmpty()) {
            this.windowsDomain = null;
        }
    }

    @Override
    final String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return 135;
    }

    @Override
    String getSshKeyFile() {
        return null;
    }

    @Override
    void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws CommandException {
        try {
            this.copyToHostsInternal(zipFile, binDirFiles);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (WindowsException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    final void precopy() throws CommandException {
        this.remoteInstallDirString = this.getInstallDir().replace('/', '\\');
        try {
            for (String host : this.hosts) {
                WindowsRemoteFileSystem wrfs;
                WindowsRemoteFile remoteInstallDir;
                String remotePassword = this.getWindowsPassword(host);
                String domain = !InstallNodeDcomCommand.ok(this.windowsDomain) ? host : this.windowsDomain;
                WindowsCredentials creds = new WindowsCredentials(host, domain, this.user, remotePassword);
                this.credentials.add(new HostAndCredentials(host, creds));
                if (this.getForce() || !(remoteInstallDir = new WindowsRemoteFile(wrfs = new WindowsRemoteFileSystem(creds), this.remoteInstallDirString)).exists()) continue;
                throw new CommandException(Strings.get("install.dir.exists", remoteInstallDir));
            }
        }
        catch (WindowsException ex) {
            throw new CommandException(ex);
        }
    }

    private void copyToHostsInternal(File zipFile, ArrayList<String> binDirFiles) throws CommandException, WindowsException {
        String zipFileName = "glassfish_install.zip";
        String unpackScriptName = "unpack.bat";
        for (String host : this.hosts) {
            WindowsCredentials creds = this.getCredentials(host);
            WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(creds);
            WindowsRemoteFile remoteInstallDir = new WindowsRemoteFile(wrfs, this.remoteInstallDirString);
            remoteInstallDir.mkdirs(this.getForce());
            WindowsRemoteFile remoteZip = new WindowsRemoteFile(remoteInstallDir, "glassfish_install.zip");
            WindowsRemoteFile unpackScript = new WindowsRemoteFile(remoteInstallDir, "unpack.bat");
            System.out.printf("Copying %d bytes", zipFile.length());
            remoteZip.copyFrom(zipFile, new WindowsRemoteFileCopyProgress(){

                public void callback(long numcopied, long numtotal) {
                    System.out.print(".");
                }

                public int getChunkSize() {
                    return 0x100000;
                }
            });
            System.out.println("");
            String fullZipFileName = this.remoteInstallDirString + "\\" + "glassfish_install.zip";
            String fullUnpackScriptPath = this.remoteInstallDirString + "\\" + "unpack.bat";
            unpackScript.copyFrom(this.makeScriptString(this.remoteInstallDirString, "glassfish_install.zip"));
            logger.fine("WROTE FILE TO REMOTE SYSTEM: " + fullZipFileName + " and " + fullUnpackScriptPath);
            this.unpackOnHosts(creds, fullUnpackScriptPath.replace('/', '\\'));
        }
    }

    private String makeScriptString(String windowsInstallDir, String zipFileName) {
        StringBuilder scriptString = new StringBuilder(windowsInstallDir.substring(0, 2));
        scriptString.append("\r\n").append("cd \"").append(windowsInstallDir).append("\"\r\n").append("jar xvf ").append(zipFileName).append("\r\n");
        return scriptString.toString();
    }

    private void unpackOnHosts(WindowsCredentials creds, String unpackScript) throws WindowsException, CommandException {
        WindowsRemoteScripter scripter = new WindowsRemoteScripter(creds);
        String out = scripter.run(unpackScript);
        if (out == null || out.length() < 50) {
            throw new CommandException(Strings.get("dcom.error.unpacking", unpackScript, out));
        }
        logger.fine("Output from Windows Unpacker:\n" + out);
    }

    private WindowsCredentials getCredentials(String host) {
        if (!InstallNodeDcomCommand.ok(host)) {
            return null;
        }
        for (HostAndCredentials hac : this.credentials) {
            if (!host.equals(hac.host)) continue;
            return hac.creds;
        }
        return null;
    }

    private class HostAndCredentials {
        private final String host;
        private final WindowsCredentials creds;

        public HostAndCredentials(String host, WindowsCredentials creds) {
            this.host = host;
            this.creds = creds;
        }
    }
}

