/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.ejb.containers.TimerBean;
import com.sun.ejb.containers.TimerLocal;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimerBeanContainer
extends StatelessSessionContainer {
    private EJBTimerService ejbTimerService;
    private EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
    private static final Logger _logger = LogDomains.getLogger(TimerBeanContainer.class, "javax.enterprise.system.container.ejb");

    protected TimerBeanContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        _logger.log(Level.INFO, "[TimerBeanContainer] Created  TimerBeanContainer: " + this.logParams[0]);
    }

    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        _logger.log(Level.INFO, "[TimerBeanContainer] Shutdown() called....");
        if (this.ejbTimerService != null) {
            this.ejbTimerService.onShutdown();
        }
        super.doConcreteContainerShutdown(appBeingUndeployed);
        this.ejbContainerUtil.unsetEJBTimerService();
    }

    public void startApplication(boolean deploy) {
        super.startApplication(deploy);
        try {
            String timerLocalIntf = "com.sun.ejb.containers.TimerLocal";
            TimerLocal timerLocal = (TimerLocal)this.createEJBLocalBusinessObjectImpl(timerLocalIntf).getClientObject(timerLocalIntf);
            Application application = this.ejbDescriptor.getApplication();
            String appID = application.getRegistrationName();
            this.ejbTimerService = new EJBTimerService(appID, timerLocal);
            this.ejbContainerUtil.setEJBTimerService(this.ejbTimerService);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.timer_service_init_error", this.logParams);
            _logger.log(Level.WARNING, "", ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    void setSessionContext(Object ejb, SessionContextImpl context) {
        if (ejb instanceof TimerBean) {
            ((TimerBean)ejb).setSessionContext(context);
        }
    }
}

