/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.CAL10NResourceBundle;
import ch.qos.cal10n.util.CAL10NResourceBundleFinder;
import ch.qos.cal10n.util.MiscUtil;
import ch.qos.cal10n.verifier.Cal10nError;
import ch.qos.cal10n.verifier.ErrorFactory;
import ch.qos.cal10n.verifier.IMessageKeyVerifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageKeyVerifier
implements IMessageKeyVerifier {
    Class<? extends Enum<?>> enumType;
    String enumTypeAsStr;

    public MessageKeyVerifier(Class<? extends Enum<?>> enumClass) {
        this.enumType = enumClass;
        this.enumTypeAsStr = enumClass.getName();
    }

    public MessageKeyVerifier(String enumTypeAsStr) {
        this.enumTypeAsStr = enumTypeAsStr;
        String errMsg = "Failed to find enum class [" + enumTypeAsStr + "]";
        try {
            this.enumType = Class.forName(enumTypeAsStr);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(errMsg, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException(errMsg, e);
        }
    }

    @Override
    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    @Override
    public String getEnumTypeAsStr() {
        return this.enumTypeAsStr;
    }

    @Override
    public List<Cal10nError> verify(Locale locale) {
        Enum<?>[] enumArray;
        ArrayList<Cal10nError> errorList = new ArrayList<Cal10nError>();
        String baseName = AnnotationExtractor.getBaseName(this.enumType);
        if (baseName == null) {
            errorList.add(new Cal10nError(Cal10nError.ErrorType.MISSING_BN_ANNOTATION, "", this.enumType, locale, ""));
            return errorList;
        }
        String charset = AnnotationExtractor.getCharset(this.enumType, Locale.FRENCH);
        CAL10NResourceBundle rb = CAL10NResourceBundleFinder.getBundle(this.getClass().getClassLoader(), baseName, locale, charset);
        ErrorFactory errorFactory = new ErrorFactory(this.enumType, locale, baseName);
        if (rb == null) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.FAILED_TO_FIND_RB, ""));
            return errorList;
        }
        Set<String> rbKeySet = this.buildKeySetFromEnumeration(((ResourceBundle)rb).getKeys());
        if (rbKeySet.size() == 0) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.EMPTY_RB, ""));
        }
        if ((enumArray = this.enumType.getEnumConstants()) == null || enumArray.length == 0) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.EMPTY_ENUM, ""));
        }
        if (errorList.size() != 0) {
            return errorList;
        }
        for (Enum<?> e : enumArray) {
            String enumKey2 = e.toString();
            if (rbKeySet.contains(enumKey2)) {
                rbKeySet.remove(enumKey2);
                continue;
            }
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.ABSENT_IN_RB, enumKey2));
        }
        for (String rbKey : rbKeySet) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.ABSENT_IN_ENUM, rbKey));
        }
        return errorList;
    }

    private Set<String> buildKeySetFromEnumeration(Enumeration<String> e) {
        HashSet<String> set = new HashSet<String>();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            set.add(s);
        }
        return set;
    }

    @Override
    public List<String> typeIsolatedVerify(Locale locale) {
        List<Cal10nError> errorList = this.verify(locale);
        ArrayList<String> strList = new ArrayList<String>();
        for (Cal10nError error : errorList) {
            strList.add(error.toString());
        }
        return strList;
    }

    @Override
    public List<Cal10nError> verifyAllLocales() {
        ArrayList<Cal10nError> errorList = new ArrayList<Cal10nError>();
        String[] localeNameArray = this.getLocaleNames();
        if (localeNameArray == null || localeNameArray.length == 0) {
            String errMsg = MessageFormat.format("Missing @LocaleData annotation in enum type [{0}]. Please see http://cal10n.qos.ch/codes.html#missingLDAnnotation", this.enumTypeAsStr);
            throw new IllegalStateException(errMsg);
        }
        for (String localeName : localeNameArray) {
            Locale locale = MiscUtil.toLocale(localeName);
            System.out.println(locale);
            List<Cal10nError> tmpList = this.verify(locale);
            errorList.addAll(tmpList);
        }
        return errorList;
    }

    @Override
    public String[] getLocaleNames() {
        String[] localeNameArray = AnnotationExtractor.getLocaleNames(this.enumType);
        return localeNameArray;
    }

    @Override
    public String getBaseName() {
        String rbName = AnnotationExtractor.getBaseName(this.enumType);
        return rbName;
    }
}

