/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiFrameworkLauncher;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;
import org.glassfish.uberjar.bootstrap.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.launch.Framework;
import org.osgi.util.tracker.ServiceTracker;

public class UberJarOSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static Logger logger = Logger.getLogger("embedded-glassfish");
    private static final String AUTO_START_BUNDLES_PROP = "org.glassfish.embedded.osgimain.autostartBundles";
    private static final String UBER_JAR_URI = "org.glassfish.embedded.osgimain.jarURI";
    private Framework framework;

    @Override
    public boolean handles(BootstrapProperties bsOptions) {
        OsgiPlatform osgiPlatform = OsgiPlatform.valueOf((String)bsOptions.getProperty("GlassFish_Platform"));
        if (osgiPlatform == null) {
            osgiPlatform = OsgiPlatform.Felix;
        }
        logger.log(Level.FINER, "platform = {0}", osgiPlatform);
        switch (osgiPlatform) {
            case Felix: 
            case Equinox: 
            case Knopflerfish: {
                return true;
            }
        }
        return false;
    }

    public void destroy() throws GlassFishException {
        if (this.framework == null) {
            logger.finer("UberJarOSGiGlassFishRuntimeBuilder.destroy called, but framework is null.");
        } else {
            try {
                this.framework.stop();
                this.framework.waitForStop(0L);
                logger.info("UberJarOSGiGlassFishRuntimeBuilder.destroy, stopped framework " + String.valueOf(this.framework));
            }
            catch (InterruptedException ex) {
                throw new GlassFishException(ex);
            }
            catch (BundleException ex) {
                throw new GlassFishException(ex);
            }
        }
    }

    @Override
    public GlassFishRuntime build(BootstrapProperties bsOptions, ClassLoader classloader) throws GlassFishException {
        String instanceRoot;
        String uberJarURI = bsOptions.getProperty(UBER_JAR_URI);
        logger.log(Level.FINER, "UberJarOSGiGlassFishRuntimeBuilder.build, uberJarUri={0}", uberJarURI);
        URI jar = null;
        try {
            jar = uberJarURI != null ? new URI(uberJarURI) : Util.whichJar(GlassFishRuntime.class);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        String installRoot = bsOptions.getInstallRoot();
        if (installRoot == null) {
            installRoot = this.getDefaultInstallRoot();
            bsOptions.setInstallRoot(installRoot);
            bsOptions.setProperty("com.sun.aas.installRootURI", new File(installRoot).toURI().toString());
        }
        if ((instanceRoot = bsOptions.getProperty("com.sun.aas.instanceRoot")) == null) {
            instanceRoot = this.getDefaultInstanceRoot();
            bsOptions.setProperty("com.sun.aas.instanceRoot", instanceRoot);
            bsOptions.setProperty("com.sun.aas.instanceRootURI", new File(instanceRoot).toURI().toString());
        }
        FileUtils.ensureWritableDir((File)new File(instanceRoot));
        try {
            this.copyConfigFile(bsOptions.getProperty("org.glassfish.embeddable.configFileURI"), instanceRoot);
        }
        catch (Exception ex) {
            throw new GlassFishException(ex);
        }
        String platform = bsOptions.getProperty("GlassFish_Platform");
        if (platform == null) {
            bsOptions.setProperty("GlassFish_Platform", OsgiPlatform.Felix.name());
        }
        System.setProperty(UBER_JAR_URI, jar.toString());
        String osgiMainModule = "jar:" + jar.toString() + "!/uber-osgi-main.jar";
        bsOptions.setProperty("glassfish.auto.start", osgiMainModule);
        String autoStartBundleLocation = "jar:" + jar.toString() + "!/modules/installroot-builder_jar/,jar:" + jar.toString() + "!/modules/instanceroot-builder_jar/,jar:" + jar.toString() + "!/modules/kernel_jar/";
        if (this.isOSGiEnv(classloader)) {
            autoStartBundleLocation = autoStartBundleLocation + ",jar:" + jar.toString() + "!/modules/osgi-modules-uninstaller_jar/";
        }
        bsOptions.setProperty(AUTO_START_BUNDLES_PROP, autoStartBundleLocation);
        System.setProperty(AUTO_START_BUNDLES_PROP, autoStartBundleLocation);
        System.setProperty("com.sun.aas.installRoot", installRoot);
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot);
        String version = this.loadVersion();
        bsOptions.setProperty("org.osgi.framework.system.packages.extra", "org.glassfish.simpleglassfishapi; version=" + version);
        bsOptions.setProperty("org.osgi.framework.storage", instanceRoot + "/osgi-cache/Felix");
        logger.logp(Level.FINER, "UberJarOSGiGlassFishRuntimeBuilder", "build", "Building file system {0}", bsOptions);
        try {
            if (!this.isOSGiEnv(classloader)) {
                OSGiFrameworkLauncher fwLauncher = new OSGiFrameworkLauncher(bsOptions.getProperties(), classloader);
                this.framework = fwLauncher.launchOSGiFrameWork();
                return fwLauncher.getService(GlassFishRuntime.class);
            }
            BundleContext context = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            Bundle autostartBundle = context.installBundle(bsOptions.getProperty("glassfish.auto.start"));
            autostartBundle.start(1);
            logger.log(Level.FINER, "Started autostartBundle {0}", autostartBundle);
            return this.getService(GlassFishRuntime.class, context);
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    private String getDefaultInstallRoot() {
        return new File(FileUtils.USER_HOME, ".glassfish8-embedded").getAbsolutePath();
    }

    private String getDefaultInstanceRoot() {
        return FileUtils.USER_HOME.toPath().resolve(Path.of(".glassfish8-embedded", "domains", "domain1")).toFile().getAbsolutePath();
    }

    private boolean isOSGiEnv(ClassLoader classloader) {
        return classloader instanceof BundleReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> type, BundleContext context) throws Exception {
        try (ServiceTracker tracker = new ServiceTracker(context, type.getName(), null);){
            tracker.open(true);
            Object object = tracker.waitForService(0L);
            return (T)object;
        }
    }

    private void copyConfigFile(String configFileURI, String instanceRoot) throws Exception {
        if (configFileURI != null && instanceRoot != null) {
            URI configFile = URI.create(configFileURI);
            InputStream stream = configFile.toURL().openConnection().getInputStream();
            File domainXml = new File(instanceRoot, "config/domain.xml");
            logger.finer("domainXML uri = " + configFileURI + ", size = " + stream.available());
            if (!domainXml.toURI().equals(configFile)) {
                domainXml.getParentFile().mkdirs();
                Util.copy(stream, new FileOutputStream(domainXml), stream.available());
                logger.finer("Created " + String.valueOf(domainXml));
            } else {
                logger.finer("Skipped creation of " + String.valueOf(domainXml));
            }
        }
    }

    private String loadVersion() {
        String string;
        block8: {
            URL manifestURL = UberJarOSGiGlassFishRuntimeBuilder.class.getResource("/META-INF/MANIFEST.MF");
            InputStream manifestStream = manifestURL.openStream();
            try {
                Manifest manifest = new Manifest(manifestStream);
                string = manifest.getMainAttributes().getValue("Bundle-Version");
                if (manifestStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (manifestStream != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load version from the manifest file.", e);
                }
            }
            manifestStream.close();
        }
        return string;
    }
}

