/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.GlassFishVariable;

public class UberJarMain {
    private static Logger logger = Logger.getLogger("embedded-glassfish");

    public static void main(String ... args) throws Exception {
        new UberJarMain().start();
    }

    private void start() throws Exception {
        this.privilegedStart();
    }

    private void privilegedStart() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Properties props = new Properties();
                    props.setProperty(GlassFishVariable.OSGI_PLATFORM.getPropertyName(), System.getProperty(GlassFishVariable.OSGI_PLATFORM.getSystemPropertyName(), OsgiPlatform.Felix.name()));
                    long startTime = System.currentTimeMillis();
                    GlassFishRuntime gfr = GlassFishRuntime.bootstrap(new BootstrapProperties(props), this.getClass().getClassLoader());
                    long timeTaken = System.currentTimeMillis() - startTime;
                    logger.info("created gfr = " + String.valueOf(gfr) + ", timeTaken = " + timeTaken);
                    startTime = System.currentTimeMillis();
                    GlassFish gf = gfr.newGlassFish(new GlassFishProperties(props));
                    timeTaken = System.currentTimeMillis() - startTime;
                    System.out.println("created gf = " + String.valueOf(gf) + ", timeTaken = " + timeTaken);
                    startTime = System.currentTimeMillis();
                    gf.start();
                    timeTaken = System.currentTimeMillis() - startTime;
                    System.out.println("started gf, timeTaken = " + timeTaken);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return null;
            }
        });
    }
}

