/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.base.io.EJBObjectInputStream;
import com.sun.ejb.base.io.EJBObjectOutputStream;
import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class J2EEObjectStreamFactoryImpl
implements J2EEObjectStreamFactory {
    public ObjectOutputStream createObjectOutputStream(final OutputStream os, final boolean replaceObject) throws IOException {
        ObjectOutputStream oos = null;
        if (System.getSecurityManager() == null) {
            oos = new EJBObjectOutputStream(os, replaceObject);
        } else {
            try {
                oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new EJBObjectOutputStream(os, replaceObject);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (IOException)ex.getException();
            }
        }
        return oos;
    }

    public ObjectInputStream createObjectInputStream(final InputStream is, final boolean resolveObject, final ClassLoader appClassLoader) throws Exception {
        ObjectInputStream ois = null;
        if (appClassLoader != null) {
            if (System.getSecurityManager() == null) {
                ois = new EJBObjectInputStream(is, appClassLoader, resolveObject);
            } else {
                try {
                    ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new EJBObjectInputStream(is, appClassLoader, resolveObject);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
            }
        } else {
            ois = new ObjectInputStream(is);
        }
        return ois;
    }
}

