# Eclipse GlassFish Project and Community

## Project description {#description}

Eclipse GlassFish is a complete application server that implements the Jakarta
EE specification. GlassFish includes implementations of all required and
optional Jakarta EE APIs, and passes all Jakarta EE TCKs. GlassFish also
includes a complete administration console, clustering support, and other
developer and production focused tools and features.

* [Eclipse GlassFish project](https://projects.eclipse.org/projects/ee4j.glassfish) at *eclipse.org*

## Contact {#contact}

### Raise questions or discuss

* [GlassFish discussion forum](https://github.com/eclipse-ee4j/glassfish/discussions)
* [Questions and answers](https://stackoverflow.com/questions/tagged/glassfish) at StackOverflow
* Chat in the **#glassfish** channel on the [Jakarta EE Slack workspace](https://jakarta.ee/connect/)

### Social media

* X.com: [@glassfish](https://x.com/glassfish) 

### Contact developers

Contact the project developers via the project's "dev" list.

* [https://accounts.eclipse.org/mailing-list/glassfish-dev](https://accounts.eclipse.org/mailing-list/glassfish-dev)

## How To Contribute {#contribute}

The Eclipse GlassFish Project is open for contributions and your help is
greatly appreciated.
The easiest way to contribute to the Eclipse GlassFish documentation is by
opening an [issue](https://github.com/eclipse-ee4j/glassfish/issues)
that contains feedback and review comments.

Contributions to the source code are also welcome. If you want to contribute code or improve the documentation or the website, please review the following links:

* [Pull Request Acceptance Workflow](pr_workflow)
* [License](LICENSE)


### Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* [http://www.eclipse.org/legal/ECA.php](http://www.eclipse.org/legal/ECA.php)

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
[https://www.eclipse.org/projects/handbook/#resources-commit](https://www.eclipse.org/projects/handbook/#resources-commit)



## Developer resources {#dev-resources}

Information regarding source code management, builds, coding standards, and
more.

* [https://projects.eclipse.org/projects/ee4j.glassfish/developer](https://projects.eclipse.org/projects/ee4j.glassfish/developer)

The project maintains the following source code repositories

* [https://github.com/eclipse-ee4j/glassfish](https://github.com/eclipse-ee4j/glassfish)
* [https://github.com/eclipse-ee4j/glassfish-ha-api](https://github.com/eclipse-ee4j/glassfish-ha-api)
* [https://github.com/eclipse-ee4j/glassfish-logging-annotation-processor](https://github.com/eclipse-ee4j/glassfish-logging-annotation-processor)
* [https://github.com/eclipse-ee4j/glassfish-shoal](https://github.com/eclipse-ee4j/glassfish-shoal)
* [https://github.com/eclipse-ee4j/glassfish-cdi-porting-tck](https://github.com/eclipse-ee4j/glassfish-cdi-porting-tck)
* [https://github.com/eclipse-ee4j/glassfish-jsftemplating](https://github.com/eclipse-ee4j/glassfish-jsftemplating)
* [https://github.com/eclipse-ee4j/glassfish-hk2-extra](https://github.com/eclipse-ee4j/glassfish-hk2-extra)
* [https://github.com/eclipse-ee4j/glassfish-hk2](https://github.com/eclipse-ee4j/glassfish-hk2)
* [https://github.com/eclipse-ee4j/glassfish-fighterfish](https://github.com/eclipse-ee4j/glassfish-fighterfish)
* [https://github.com/eclipse-ee4j/glassfish-maven-embedded-plugin](https://github.com/eclipse-ee4j/glassfish-maven-embedded-plugin)
* [https://github.com/eclipse-ee4j/bvtck-porting](https://github.com/eclipse-ee4j/bvtck-porting)
* [https://github.com/eclipse-ee4j/ditck-porting](https://github.com/eclipse-ee4j/ditck-porting)
* [https://github.com/eclipse-ee4j/cditck-porting](https://github.com/eclipse-ee4j/cditck-porting)
* [https://github.com/eclipse-ee4j/glassfish-woodstock](https://github.com/eclipse-ee4j/glassfish-woodstock)
* [https://github.com/eclipse-ee4j/glassfish-spec-version-maven-plugin](https://github.com/eclipse-ee4j/glassfish-spec-version-maven-plugin)
* [https://github.com/eclipse-ee4j/glassfish-build-maven-plugin](https://github.com/eclipse-ee4j/glassfish-build-maven-plugin)
* [https://github.com/eclipse-ee4j/glassfish-repackaged](https://github.com/eclipse-ee4j/glassfish-repackaged)
* [https://github.com/eclipse-ee4j/glassfish-copyright-plugin](https://github.com/eclipse-ee4j/glassfish-copyright-plugin)
* [https://github.com/eclipse-ee4j/glassfish-doc-plugin](https://github.com/eclipse-ee4j/glassfish-doc-plugin)
* [https://github.com/eclipse-ee4j/glassfish-security-plugin](https://github.com/eclipse-ee4j/glassfish-security-plugin)
* [https://github.com/eclipse-ee4j/jakartaee-schemas](https://github.com/eclipse-ee4j/jakartaee-schemas)
* [https://github.com/eclipse-ee4j/glassfish-firstcup-examples](https://github.com/eclipse-ee4j/glassfish-firstcup-examples)
* [https://github.com/eclipse-ee4j/glassfish-tutorial-examples](https://github.com/eclipse-ee4j/glassfish-tutorial-examples)
* [https://github.com/eclipse-ee4j/glassfish-firstcup](https://github.com/eclipse-ee4j/glassfish-firstcup)
* [https://github.com/eclipse-ee4j/glassfish-tutorial](https://github.com/eclipse-ee4j/glassfish-tutorial)

