/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.glassfish.deployment.common.Descriptor;

public class WebService
extends Descriptor {
    private String wsdlFileUri;
    private URL wsdlFileUrl;
    private String mappingFileUri;
    private File mappingFile;
    private HashMap<String, WebServiceEndpoint> endpoints;
    private WebServicesDescriptor webServicesDesc;
    private URL publishUrl;
    private String type;
    private Boolean isJaxWSBased = null;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WebService() {
        this("");
    }

    public Boolean isJaxWSBased() {
        return this.isJaxWSBased;
    }

    public void setJaxWSBased(boolean isJaxWSBased) {
        this.isJaxWSBased = isJaxWSBased;
    }

    public WebService(WebService other) {
        super((Descriptor)other);
        this.wsdlFileUri = other.wsdlFileUri;
        this.wsdlFileUrl = other.wsdlFileUrl;
        this.mappingFileUri = other.mappingFileUri;
        this.mappingFile = other.mappingFile;
        this.publishUrl = other.publishUrl;
        this.webServicesDesc = other.webServicesDesc;
        this.type = other.type;
        if (other.endpoints != null) {
            this.endpoints = new HashMap();
            for (WebServiceEndpoint wsep : other.endpoints.values()) {
                wsep.setWebService(this);
                this.endpoints.put(wsep.getEndpointName(), wsep);
            }
        } else {
            this.endpoints = null;
        }
    }

    public WebService(String name) {
        this.setName(name);
        this.endpoints = new HashMap();
    }

    public void setWebServicesDescriptor(WebServicesDescriptor webServices) {
        this.webServicesDesc = webServices;
    }

    public WebServicesDescriptor getWebServicesDescriptor() {
        return this.webServicesDesc;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.webServicesDesc.getBundleDescriptor();
    }

    public boolean hasWsdlFile() {
        return this.wsdlFileUri != null;
    }

    public void setWsdlFileUri(String uri) {
        this.wsdlFileUri = uri;
    }

    public String getWsdlFileUri() {
        return this.wsdlFileUri;
    }

    public URL getWsdlFileUrl() {
        return this.wsdlFileUrl;
    }

    public void setWsdlFileUrl(URL url) {
        this.wsdlFileUrl = url;
    }

    public String getGeneratedWsdlFilePath() {
        if (this.hasWsdlFile()) {
            String xmlDir = this.getBundleDescriptor().getApplication().getGeneratedXMLDirectory();
            if (!this.getBundleDescriptor().getModuleDescriptor().isStandalone()) {
                String uri = this.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                xmlDir = xmlDir + File.separator + uri.replaceAll("\\.", "_");
            }
            if (xmlDir == null) {
                return null;
            }
            return xmlDir + File.separator + this.wsdlFileUri;
        }
        return this.getWsdlFileUrl().getPath();
    }

    public boolean hasMappingFile() {
        return this.mappingFileUri != null;
    }

    public void setMappingFileUri(String uri) {
        this.mappingFileUri = uri;
    }

    public String getMappingFileUri() {
        return this.mappingFileUri;
    }

    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(File file) {
        this.mappingFile = file;
    }

    public void addEndpoint(WebServiceEndpoint endpoint) {
        endpoint.setWebService(this);
        this.endpoints.put(endpoint.getEndpointName(), endpoint);
    }

    public void removeEndpointByName(String endpointName) {
        WebServiceEndpoint endpoint = this.endpoints.remove(endpointName);
        endpoint.setWebService(null);
    }

    public WebServiceEndpoint getEndpointByName(String name) {
        return this.endpoints.get(name);
    }

    public void removeEndpoint(WebServiceEndpoint endpoint) {
        this.removeEndpointByName(endpoint.getEndpointName());
    }

    public Collection<WebServiceEndpoint> getEndpoints() {
        HashMap<String, WebServiceEndpoint> shallowCopy = new HashMap<String, WebServiceEndpoint>(this.endpoints);
        return shallowCopy.values();
    }

    public boolean hasClientPublishUrl() {
        return this.publishUrl != null;
    }

    public void setClientPublishUrl(URL url) {
        this.publishUrl = url;
    }

    public URL getClientPublishUrl() {
        return this.publishUrl;
    }

    public boolean hasUrlPublishing() {
        return !this.hasFilePublishing();
    }

    public boolean hasFilePublishing() {
        return this.hasClientPublishUrl() && this.publishUrl.getProtocol().equals("file");
    }

    public WebServiceEndpoint pickEndpointForRelativeImports() {
        WebServiceEndpoint pick = null;
        for (WebServiceEndpoint wse : this.endpoints.values()) {
            if (wse.isSecure()) {
                pick = wse;
                break;
            }
            pick = wse;
        }
        return pick;
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n wsdl file : ").append(this.wsdlFileUri);
        toStringBuffer.append("\n mapping file ").append(this.mappingFileUri);
        toStringBuffer.append("\n publish url ").append(this.publishUrl);
        toStringBuffer.append("\n final wsdl ").append(this.wsdlFileUrl);
        toStringBuffer.append("\n endpoints ").append(this.endpoints);
    }
}

