/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode;
import com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.JMSDestinationDefinitionNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.MailSessionNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ModuleNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Node;

@Service
public class ApplicationNode
extends AbstractBundleNode<Application> {
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/application_1_2.dtd";
    public static final String SCHEMA_ID_14 = "application_1_4.xsd";
    public static final String SCHEMA_ID_15 = "application_5.xsd";
    public static final String SCHEMA_ID_16 = "application_6.xsd";
    public static final String SCHEMA_ID = "application_7.xsd";
    public static final String SPEC_VERSION = "7";
    private static final List<String> systemIDs = ApplicationNode.initSystemIDs();
    public static final XMLElement tag = new XMLElement("application");
    private Application descriptor;

    private static final List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_14);
        systemIDs.add(SCHEMA_ID_15);
        systemIDs.add(SCHEMA_ID_16);
        return Collections.unmodifiableList(systemIDs);
    }

    public String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    @Override
    public Map<String, Class> registerRuntimeBundle(Map<String, String> publicIDToDTD, Map<String, List<Class>> versionUpgrades) {
        HashMap<String, Class> result = new HashMap<String, Class>();
        for (ConfigurationDeploymentDescriptorFile confDD : DOLUtils.getConfigurationDeploymentDescriptorFiles(this.habitat, "ear")) {
            confDD.registerBundle(result, publicIDToDTD, versionUpgrades);
        }
        return result;
    }

    @Override
    public Collection<String> elementsAllowingEmptyValue() {
        HashSet<String> result = new HashSet<String>();
        result.add("library-directory");
        return result;
    }

    @Override
    protected String topLevelTagName() {
        return "application-name";
    }

    @Override
    protected String topLevelTagValue(Application descriptor) {
        return descriptor.getAppName();
    }

    public ApplicationNode() {
        this.registerElementHandler(new XMLElement("module"), ModuleNode.class, "addModule");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addAppRole");
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.habitat.getService(JndiEnvRefNode.class, "service-ref", new Annotation[0]);
        if (serviceRefNode != null) {
            this.registerElementHandler(new XMLElement("service-ref"), serviceRefNode.getClass(), "addServiceReferenceDescriptor");
        }
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addResourceEnvReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("mail-session"), MailSessionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("connection-factory"), ConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("administered-object"), AdministeredObjectDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-connection-factory"), JMSConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-destination"), JMSDestinationDefinitionNode.class, "addResourceDescriptor");
        SaxParserHandler.registerBundleNode(this, "application");
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        Application application = this.getDescriptor();
        if (element.getQName().equals("library-directory")) {
            application.setLibraryDirectory(value);
        } else if (element.getQName().equals("application-name")) {
            application.setAppName(value);
        } else if (element.getQName().equals("initialize-in-order")) {
            application.setInitializeInOrder(Boolean.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof BundleDescriptor) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("In  " + this.toString() + " adding descriptor " + newDescriptor);
            }
            this.descriptor.addBundleDescriptor((BundleDescriptor)newDescriptor);
        } else if (newDescriptor instanceof EjbReference) {
            this.descriptor.addEjbReferenceDescriptor((EjbReference)newDescriptor);
        }
    }

    @Override
    public Application getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = Application.createApplication();
        }
        return this.descriptor;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Node writeDescriptor(Node parent, Application application) {
        Node appNode = super.writeDescriptor(parent, application);
        ApplicationNode.appendTextChild(appNode, "initialize-in-order", String.valueOf(application.isInitializeInOrder()));
        ModuleNode moduleNode = new ModuleNode();
        for (ModuleDescriptor<BundleDescriptor> md : application.getModules()) {
            moduleNode.writeDescriptor(appNode, "module", md);
        }
        if (application.getLibraryDirectoryRawValue() != null) {
            ApplicationNode.appendTextChild(appNode, "library-directory", application.getLibraryDirectoryRawValue());
        }
        this.writeEnvEntryDescriptors(appNode, application.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(appNode, application.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(appNode, application.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(appNode, application.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(appNode, application.getResourceEnvReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(appNode, application.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(appNode, application.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(appNode, application.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writeMessageDestinations(appNode, application.getMessageDestinations().iterator());
        this.writeResourceDescriptors(appNode, application.getAllResourcesDescriptors().iterator());
        return appNode;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

