/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WSDolSupport;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.StringUtils;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA_2_3.ORB;

@Service
@AnnotationHandlerFor(value=Resource.class)
public class ResourceHandler
extends AbstractResourceHandler {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Provider<WSDolSupport> wSDolSupportProvider;
    private static final Map<Class, Class> envEntryTypes = new HashMap<Class, Class>();

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Resource resourceAn = (Resource)ainfo.getAnnotation();
        return this.processResource(ainfo, rcContexts, resourceAn);
    }

    protected HandlerProcessingResult processResource(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, Resource resourceAn) throws AnnotationProcessorException {
        EnvironmentProperty[] descriptors;
        String logicalName;
        String targetClassName;
        Object resourceRefs = null;
        String defaultLogicalName = null;
        Class defaultResourceType = null;
        InjectionTarget target = null;
        if (ElementType.FIELD.equals((Object)ainfo.getElementType())) {
            Field f = (Field)ainfo.getAnnotatedElement();
            targetClassName = f.getDeclaringClass().getName();
            defaultLogicalName = targetClassName + "/" + f.getName();
            defaultResourceType = f.getType();
            target = new InjectionTarget();
            target.setFieldName(f.getName());
            target.setClassName(targetClassName);
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.METHOD.equals((Object)ainfo.getElementType())) {
            Method m = (Method)ainfo.getAnnotatedElement();
            targetClassName = m.getDeclaringClass().getName();
            this.validateInjectionMethod(m, ainfo);
            String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
            defaultLogicalName = targetClassName + "/" + propertyName;
            defaultResourceType = m.getParameterTypes()[0];
            target = new InjectionTarget();
            target.setMethodName(m.getName());
            target.setClassName(targetClassName);
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
            if (resourceAn.name().equals("") || resourceAn.type() == Object.class) {
                Class c = (Class)ainfo.getAnnotatedElement();
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtypelevelresource", "Invalid TYPE-level @Resource with name() = [{0}] and type = [{1}] in {2}. Each TYPE-level @Resource must specify both name() and type().", new Object[]{resourceAn.name(), resourceAn.type(), c}));
                return this.getDefaultFailedResult();
            }
        } else {
            return this.getDefaultFailedResult();
        }
        Class resourceType = resourceAn.type() == Object.class ? defaultResourceType : resourceAn.type();
        String string = logicalName = resourceAn.name().equals("") ? defaultLogicalName : resourceAn.name();
        if (envEntryTypes.containsKey(resourceType)) {
            resourceType = envEntryTypes.get(resourceType);
        }
        for (EnvironmentProperty desc : descriptors = this.getDescriptors(resourceType, logicalName, rcContexts, resourceAn)) {
            if (target != null) {
                desc.addInjectionTarget(target);
            }
            if (!StringUtils.ok((String)desc.getName())) {
                desc.setName(logicalName);
            }
            if (!StringUtils.ok((String)desc.getInjectResourceType())) {
                desc.setInjectResourceType(resourceType.getName());
            }
            if (!StringUtils.ok((String)desc.getDescription()) && StringUtils.ok((String)resourceAn.description())) {
                desc.setDescription(resourceAn.description());
            }
            if (!desc.hasLookupName() && !desc.isSetValueCalled() && StringUtils.ok((String)this.getResourceLookupValue(resourceAn, ainfo))) {
                desc.setLookupName(this.getResourceLookupValue(resourceAn, ainfo));
            }
            if (!StringUtils.ok((String)desc.getMappedName()) && StringUtils.ok((String)resourceAn.mappedName())) {
                desc.setMappedName(resourceAn.mappedName());
            }
            if (!(desc instanceof ResourceReferenceDescriptor)) continue;
            ResourceReferenceDescriptor rdesc = (ResourceReferenceDescriptor)desc;
            if (!rdesc.hasAuthorization()) {
                switch (resourceAn.authenticationType()) {
                    case APPLICATION: {
                        rdesc.setAuthorization("Application");
                        break;
                    }
                    case CONTAINER: {
                        rdesc.setAuthorization("Container");
                        break;
                    }
                    default: {
                        Class c = (Class)ainfo.getAnnotatedElement();
                        this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidauthenticationtype", "Invalid AuthenticationType [{0}] in @Resource with name() = [{1}] and type = [{1}] in {2}.", new Object[]{resourceAn.authenticationType(), resourceAn.name(), resourceAn.type(), c}));
                        return this.getDefaultFailedResult();
                    }
                }
            }
            if (rdesc.hasSharingScope()) continue;
            rdesc.setSharingScope(resourceAn.shareable() ? "Shareable" : "Unshareable");
        }
        return this.getDefaultProcessedResult();
    }

    private EnvironmentProperty[] getDescriptors(Class resourceType, String logicalName, ResourceContainerContext[] rcContexts, Resource resourceAn) {
        Class webServiceContext = null;
        try {
            WSDolSupport support = (WSDolSupport)this.wSDolSupportProvider.get();
            if (support != null) {
                webServiceContext = support.getType("javax.xml.ws.WebServiceContext");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (resourceType.getName().equals("javax.jms.Queue") || resourceType.getName().equals("javax.jms.Topic")) {
            return this.getMessageDestinationReferenceDescriptors(logicalName, rcContexts);
        }
        if (envEntryTypes.containsKey(resourceType) || resourceType.isEnum()) {
            return this.getEnvironmentPropertyDescriptors(logicalName, rcContexts, resourceAn);
        }
        if (resourceType == DataSource.class || resourceType.getName().equals("javax.jms.ConnectionFactory") || resourceType.getName().equals("javax.jms.QueueConnectionFactory") || resourceType.getName().equals("javax.jms.TopicConnectionFactory") || resourceType == webServiceContext || resourceType.getName().equals("javax.mail.Session") || resourceType.getName().equals("java.net.URL") || resourceType.getName().equals("javax.resource.cci.ConnectionFactory") || resourceType == ORB.class || resourceType == org.omg.CORBA.ORB.class || resourceType.getName().equals("javax.jms.XAConnectionFactory") || resourceType.getName().equals("javax.jms.XAQueueConnectionFactory") || resourceType.getName().equals("javax.jms.XATopicConnectionFactory") || DOLUtils.isRAConnectionFactory(this.habitat, resourceType.getName(), ((ResourceContainerContextImpl)rcContexts[0]).getAppFromDescriptor())) {
            return this.getResourceReferenceDescriptors(logicalName, rcContexts);
        }
        return this.getResourceEnvReferenceDescriptors(logicalName, rcContexts);
    }

    private ResourceReferenceDescriptor[] getResourceReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        ResourceReferenceDescriptor[] resourceRefs = new ResourceReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            ResourceReferenceDescriptor resourceRef = rcContexts[i].getResourceReference(logicalName);
            if (resourceRef == null) {
                resourceRef = new ResourceReferenceDescriptor();
                rcContexts[i].addResourceReferenceDescriptor(resourceRef);
            }
            resourceRefs[i] = resourceRef;
        }
        return resourceRefs;
    }

    private MessageDestinationReferenceDescriptor[] getMessageDestinationReferenceDescriptors(String logicName, ResourceContainerContext[] rcContexts) {
        MessageDestinationReferenceDescriptor[] msgDestRefs = new MessageDestinationReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            MessageDestinationReferenceDescriptor msgDestRef = rcContexts[i].getMessageDestinationReference(logicName);
            if (msgDestRef == null) {
                msgDestRef = new MessageDestinationReferenceDescriptor();
                rcContexts[i].addMessageDestinationReferenceDescriptor(msgDestRef);
            }
            msgDestRefs[i] = msgDestRef;
        }
        return msgDestRefs;
    }

    private ResourceEnvReferenceDescriptor[] getResourceEnvReferenceDescriptors(String logicName, ResourceContainerContext[] rcContexts) {
        ResourceEnvReferenceDescriptor[] resourceEnvRefs = new ResourceEnvReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            ResourceEnvReferenceDescriptor resourceEnvRef = rcContexts[i].getResourceEnvReference(logicName);
            if (resourceEnvRef == null) {
                resourceEnvRef = new ResourceEnvReferenceDescriptor();
                rcContexts[i].addResourceEnvReferenceDescriptor(resourceEnvRef);
            }
            resourceEnvRefs[i] = resourceEnvRef;
        }
        return resourceEnvRefs;
    }

    private EnvironmentProperty[] getEnvironmentPropertyDescriptors(String logicalName, ResourceContainerContext[] rcContexts, Resource annotation) {
        ArrayList<EnvironmentProperty> envEntries = new ArrayList<EnvironmentProperty>();
        for (int i = 0; i < rcContexts.length; ++i) {
            EnvironmentProperty envEntry = rcContexts[i].getEnvEntry(logicalName);
            if (envEntry != null) {
                envEntries.add(envEntry);
                continue;
            }
            envEntry = new EnvironmentProperty();
            envEntries.add(envEntry);
            rcContexts[i].addEnvEntryDescriptor(envEntry);
        }
        return envEntries.toArray(new EnvironmentProperty[envEntries.size()]);
    }

    private String getResourceLookupValue(Resource annotation, AnnotationInfo ainfo) {
        String lookupValue = "";
        try {
            lookupValue = annotation.lookup();
        }
        catch (NoSuchMethodError nsme) {
            try {
                this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongresourceclass", "Incorrect @Resource annotation class definition - missing lookup attribute"));
            }
            catch (AnnotationProcessorException ex) {
                // empty catch block
            }
        }
        return lookupValue;
    }

    static {
        envEntryTypes.put(String.class, String.class);
        envEntryTypes.put(Class.class, Class.class);
        envEntryTypes.put(Character.class, Character.class);
        envEntryTypes.put(Character.TYPE, Character.class);
        envEntryTypes.put(Character.TYPE, Character.class);
        envEntryTypes.put(Byte.class, Byte.class);
        envEntryTypes.put(Byte.TYPE, Byte.class);
        envEntryTypes.put(Byte.TYPE, Byte.class);
        envEntryTypes.put(Short.class, Short.class);
        envEntryTypes.put(Short.TYPE, Short.class);
        envEntryTypes.put(Short.TYPE, Short.class);
        envEntryTypes.put(Integer.class, Integer.class);
        envEntryTypes.put(Integer.TYPE, Integer.class);
        envEntryTypes.put(Integer.TYPE, Integer.class);
        envEntryTypes.put(Long.class, Long.class);
        envEntryTypes.put(Long.TYPE, Long.class);
        envEntryTypes.put(Long.TYPE, Long.class);
        envEntryTypes.put(Boolean.class, Boolean.class);
        envEntryTypes.put(Boolean.TYPE, Boolean.class);
        envEntryTypes.put(Boolean.TYPE, Boolean.class);
        envEntryTypes.put(Double.class, Double.class);
        envEntryTypes.put(Double.TYPE, Double.class);
        envEntryTypes.put(Double.TYPE, Double.class);
        envEntryTypes.put(Float.class, Float.class);
        envEntryTypes.put(Float.TYPE, Float.class);
        envEntryTypes.put(Float.TYPE, Float.class);
        envEntryTypes.put(Number.class, Number.class);
    }
}

