/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFileFor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.xml.sax.SAXParseException;

public class DOLUtils {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_LOCATION_TAG = "xsi:schemaLocation";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DOLUtils.class);
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.deployment.LogMessages";
    private static final String DEPLOYMENT_LOGGER = "javax.enterprise.system.tools.deployment.dol";
    public static final Logger deplLogger = Logger.getLogger("javax.enterprise.system.tools.deployment.dol", "org.glassfish.deployment.LogMessages");
    private static final String COUNTERPART_CONFIGDD_EXISTS = "AS-DEPLOYMENT-00001";
    private static final String EXCEPTION_CAUGHT = "AS-DEPLOYMENT-00002";
    private static final String INCOMPATIBLE_TYPE = "AS-DEPLOYMENT-00003";
    private static final String GFDD_OVER_WLSDD = "gfdd.over.wlsdd";
    private static final String IGNORE_WLSDD = "ignore.wlsdd";

    private DOLUtils() {
    }

    public static synchronized Logger getDefaultLogger() {
        return deplLogger;
    }

    public static boolean equals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public static List<URI> getLibraryJarURIs(BundleDescriptor bundleDesc, ReadableArchive archive) throws Exception {
        if (bundleDesc == null) {
            return Collections.emptyList();
        }
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        Application app = ((BundleDescriptor)moduleDesc.getDescriptor()).getApplication();
        return DOLUtils.getLibraryJarURIs(app, archive);
    }

    public static List<URI> getLibraryJarURIs(Application app, ReadableArchive archive) throws Exception {
        ArrayList libraryURLs = new ArrayList();
        ArrayList<URI> libraryURIs = new ArrayList<URI>();
        libraryURLs.addAll(DeploymentUtils.getManifestLibraries((ReadableArchive)archive));
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive == null) {
            return Collections.emptyList();
        }
        File appRoot = new File(parentArchive.getURI());
        libraryURLs.addAll(ASClassLoaderUtil.getAppLibDirLibrariesAsList((File)appRoot, (String)app.getLibraryDirectory(), null));
        for (URL url : libraryURLs) {
            libraryURIs.add(Util.toURI((URL)url));
        }
        return libraryURIs;
    }

    public static BundleDescriptor getCurrentBundleForContext(DeploymentContext context) {
        ExtendedDeploymentContext ctx = (ExtendedDeploymentContext)context;
        Application application = (Application)context.getModuleMetaData(Application.class);
        if (application == null) {
            return null;
        }
        if (ctx.getParentContext() == null) {
            if (application.isVirtual()) {
                return application.getStandaloneBundleDescriptor();
            }
            return application;
        }
        return application.getModuleByUri(ctx.getModuleUri());
    }

    public static boolean isRAConnectionFactory(ServiceLocator habitat, String type, Application thisApp) {
        if (DOLUtils.isRAConnectionFactory(type, thisApp)) {
            return true;
        }
        Applications applications = (Applications)habitat.getService(Applications.class, new Annotation[0]);
        if (applications != null) {
            List raApps = applications.getApplicationsWithSnifferType("connector", true);
            ApplicationRegistry appRegistry = (ApplicationRegistry)habitat.getService(ApplicationRegistry.class, new Annotation[0]);
            for (com.sun.enterprise.config.serverbeans.Application raApp : raApps) {
                ApplicationInfo appInfo = appRegistry.get(raApp.getName());
                if (!DOLUtils.isRAConnectionFactory(type, (Application)appInfo.getMetaData(Application.class))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isRAConnectionFactory(String type, Application app) {
        if (app == null) {
            return false;
        }
        for (ConnectorDescriptor cd : app.getBundleDescriptors(ConnectorDescriptor.class)) {
            if (cd.getConnectionDefinitionByCFType(type) == null) continue;
            return true;
        }
        return false;
    }

    public static ArchiveType earType() {
        return DOLUtils.getModuleType(ModuleType.EAR.toString());
    }

    public static ArchiveType ejbType() {
        return DOLUtils.getModuleType(ModuleType.EJB.toString());
    }

    public static ArchiveType carType() {
        return DOLUtils.getModuleType(ModuleType.CAR.toString());
    }

    public static ArchiveType warType() {
        return DOLUtils.getModuleType(ModuleType.WAR.toString());
    }

    public static ArchiveType rarType() {
        return DOLUtils.getModuleType(ModuleType.RAR.toString());
    }

    public static ArchiveType getModuleType(String moduleType) {
        if (moduleType == null) {
            return null;
        }
        ServiceLocator services = Globals.getDefaultHabitat();
        ArchiveType result = null;
        if (services != null) {
            result = (ArchiveType)services.getService(ArchiveType.class, moduleType, new Annotation[0]);
        }
        return result;
    }

    public static boolean isGFDDOverWLSDD() {
        return Boolean.valueOf(System.getProperty(GFDD_OVER_WLSDD));
    }

    public static boolean isIgnoreWLSDD() {
        return Boolean.valueOf(System.getProperty(IGNORE_WLSDD));
    }

    private static List<ConfigurationDeploymentDescriptorFile> sortConfigurationDDFiles(List<ConfigurationDeploymentDescriptorFile> ddFiles, ArchiveType archiveType, ReadableArchive archive) {
        ConfigurationDeploymentDescriptorFile wlsConfDD = null;
        ConfigurationDeploymentDescriptorFile gfConfDD = null;
        ConfigurationDeploymentDescriptorFile sunConfDD = null;
        for (ConfigurationDeploymentDescriptorFile ddFile : ddFiles) {
            ddFile.setArchiveType(archiveType);
            String ddPath = ddFile.getDeploymentDescriptorPath();
            if (ddPath.indexOf("weblogic") != -1) {
                wlsConfDD = ddFile;
                continue;
            }
            if (ddPath.indexOf("glassfish-") != -1) {
                gfConfDD = ddFile;
                continue;
            }
            if (ddPath.indexOf("sun-") == -1) continue;
            sunConfDD = ddFile;
        }
        ArrayList<ConfigurationDeploymentDescriptorFile> sortedConfDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        if (runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
            String runtimeAltDDPath = runtimeAltDDFile.getPath();
            DOLUtils.validateRuntimeAltDDPath(runtimeAltDDPath);
            if (runtimeAltDDPath.indexOf("glassfish-") != -1 && gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
                return sortedConfDDFiles;
            }
            if (runtimeAltDDPath.indexOf("weblogic") != -1 && wlsConfDD != null) {
                sortedConfDDFiles.add(wlsConfDD);
                return sortedConfDDFiles;
            }
        }
        if (Boolean.valueOf(System.getProperty(GFDD_OVER_WLSDD)).booleanValue()) {
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
            if (wlsConfDD != null) {
                sortedConfDDFiles.add(wlsConfDD);
            }
        } else if (Boolean.valueOf(System.getProperty(IGNORE_WLSDD)).booleanValue()) {
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
        } else {
            if (wlsConfDD != null) {
                sortedConfDDFiles.add(wlsConfDD);
            }
            if (gfConfDD != null) {
                sortedConfDDFiles.add(gfConfDD);
            }
        }
        if (sunConfDD != null) {
            sortedConfDDFiles.add(sunConfDD);
        }
        return sortedConfDDFiles;
    }

    public static void validateRuntimeAltDDPath(String runtimeAltDDPath) {
        if (runtimeAltDDPath.indexOf("glassfish-") == -1 && runtimeAltDDPath.indexOf("weblogic") == -1) {
            String msg = localStrings.getLocalString("enterprise.deployment.util.unsupportedruntimealtdd", "Unsupported external runtime alternate deployment descriptor [{0}].", new Object[]{runtimeAltDDPath});
            throw new IllegalArgumentException(msg);
        }
    }

    public static List<ConfigurationDeploymentDescriptorFile> processConfigurationDDFiles(List<ConfigurationDeploymentDescriptorFile> ddFiles, ReadableArchive archive, ArchiveType archiveType) throws IOException {
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        if (runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
            return DOLUtils.sortConfigurationDDFiles(ddFiles, archiveType, archive);
        }
        ArrayList<ConfigurationDeploymentDescriptorFile> processedConfDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        for (ConfigurationDeploymentDescriptorFile ddFile : DOLUtils.sortConfigurationDDFiles(ddFiles, archiveType, archive)) {
            if (!archive.exists(ddFile.getDeploymentDescriptorPath())) continue;
            processedConfDDFiles.add(ddFile);
        }
        return processedConfDDFiles;
    }

    public static void readAlternativeRuntimeDescriptor(ReadableArchive appArchive, ReadableArchive embeddedArchive, Archivist archivist, BundleDescriptor descriptor, String altDDPath) throws IOException, SAXParseException {
        String altRuntimeDDPath = null;
        DeploymentDescriptorFile confDD = null;
        for (ConfigurationDeploymentDescriptorFile ddFile : DOLUtils.sortConfigurationDDFiles(archivist.getConfigurationDDFiles(), archivist.getModuleType(), embeddedArchive)) {
            String ddPath = ddFile.getDeploymentDescriptorPath();
            if (ddPath.indexOf("weblogic") != -1 && appArchive.exists("weblogic" + altDDPath)) {
                confDD = ddFile;
                altRuntimeDDPath = "weblogic" + altDDPath;
                continue;
            }
            if (ddPath.indexOf("glassfish-") != -1 && appArchive.exists("glassfish-" + altDDPath)) {
                confDD = ddFile;
                altRuntimeDDPath = "glassfish-" + altDDPath;
                continue;
            }
            if (ddPath.indexOf("sun-") == -1 || !appArchive.exists("sun-" + altDDPath)) continue;
            confDD = ddFile;
            altRuntimeDDPath = "sun-" + altDDPath;
        }
        if (confDD != null && altRuntimeDDPath != null) {
            InputStream is = appArchive.getEntry(altRuntimeDDPath);
            confDD.setXMLValidation(archivist.getRuntimeXMLValidation());
            confDD.setXMLValidationLevel(archivist.getRuntimeXMLValidationLevel());
            if (appArchive.getURI() != null) {
                confDD.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
            }
            confDD.read(descriptor, is);
            is.close();
            archivist.postRuntimeDDsRead(descriptor, embeddedArchive);
        } else {
            archivist.readRuntimeDeploymentDescriptor(embeddedArchive, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRuntimeDeploymentDescriptor(List<ConfigurationDeploymentDescriptorFile> confDDFiles, ReadableArchive archive, RootDeploymentDescriptor descriptor, Archivist main, boolean warnIfMultipleDDs) throws IOException, SAXParseException {
        if (confDDFiles == null || confDDFiles.isEmpty()) {
            return;
        }
        ConfigurationDeploymentDescriptorFile confDD = confDDFiles.get(0);
        InputStream is = null;
        try {
            File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
            is = runtimeAltDDFile != null && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile() ? new FileInputStream(runtimeAltDDFile) : archive.getEntry(confDD.getDeploymentDescriptorPath());
            for (int i = 1; i < confDDFiles.size(); ++i) {
                if (!warnIfMultipleDDs) continue;
                deplLogger.log(Level.WARNING, COUNTERPART_CONFIGDD_EXISTS, new Object[]{confDDFiles.get(i).getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), confDD.getDeploymentDescriptorPath()});
            }
            confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
            if (confDD.isValidating()) {
                confDD.setXMLValidation(main.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(main.getRuntimeXMLValidationLevel());
            } else {
                confDD.setXMLValidation(false);
            }
            confDD.read(descriptor, is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void setExtensionArchivistForSubArchivist(ServiceLocator habitat, ReadableArchive archive, ModuleDescriptor md, Application app, Archivist subArchivist) {
        try {
            Collection<Sniffer> sniffers = DOLUtils.getSniffersForModule(habitat, archive, md, app);
            ArchivistFactory archivistFactory = (ArchivistFactory)habitat.getService(ArchivistFactory.class, new Annotation[0]);
            subArchivist.setExtensionArchivists(archivistFactory.getExtensionsArchivists(sniffers, subArchivist.getModuleType()));
        }
        catch (Exception e) {
            deplLogger.log(Level.WARNING, EXCEPTION_CAUGHT, new Object[]{e.getMessage(), e});
        }
    }

    private static Collection<Sniffer> getSniffersForModule(ServiceLocator habitat, ReadableArchive archive, ModuleDescriptor md, Application app) throws Exception {
        ArchiveHandler handler = (ArchiveHandler)habitat.getService(ArchiveHandler.class, md.getModuleType().toString(), new Annotation[0]);
        SnifferManager snifferManager = (SnifferManager)habitat.getService(SnifferManager.class, new Annotation[0]);
        List classPathURIs = handler.getClassPathURIs(archive);
        classPathURIs.addAll(DOLUtils.getLibraryJarURIs(app, archive));
        Types types = (Types)archive.getParentArchive().getExtraData(Types.class);
        DeployCommandParameters parameters = new DeployCommandParameters(new File(archive.getURI()));
        DeploymentContextImpl context = new DeploymentContextImpl(null, archive, (OpsParams)parameters, (ServerEnvironment)habitat.getService(ServerEnvironment.class, new Annotation[0]));
        context.setArchiveHandler(handler);
        Collection sniffers = snifferManager.getSniffers((DeploymentContext)context, classPathURIs, types);
        String type = DOLUtils.getTypeFromModuleType(md.getModuleType());
        Sniffer mainSniffer = null;
        for (Sniffer sniffer : sniffers) {
            if (!sniffer.getModuleType().equals(type)) continue;
            mainSniffer = sniffer;
        }
        if (mainSniffer == null) {
            mainSniffer = snifferManager.getSniffer(type);
            sniffers.add(mainSniffer);
        }
        String[] incompatibleTypes = mainSniffer.getIncompatibleSnifferTypes();
        List<String> allIncompatTypes = DOLUtils.addAdditionalIncompatTypes(mainSniffer, incompatibleTypes);
        ArrayList<Sniffer> sniffersToRemove = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            for (String incompatType : allIncompatTypes) {
                if (!sniffer.getModuleType().equals(incompatType)) continue;
                deplLogger.log(Level.WARNING, INCOMPATIBLE_TYPE, new Object[]{type, md.getArchiveUri(), incompatType});
                sniffersToRemove.add(sniffer);
            }
        }
        sniffers.removeAll(sniffersToRemove);
        Hashtable<String, Collection> sniffersTable = (Hashtable<String, Collection>)archive.getParentArchive().getExtraData(Hashtable.class);
        if (sniffersTable == null) {
            sniffersTable = new Hashtable<String, Collection>();
            archive.getParentArchive().setExtraData(Hashtable.class, sniffersTable);
        }
        sniffersTable.put(md.getArchiveUri(), sniffers);
        return sniffers;
    }

    private static String getTypeFromModuleType(ArchiveType moduleType) {
        if (moduleType.equals((Object)DOLUtils.warType())) {
            return "web";
        }
        if (moduleType.equals((Object)DOLUtils.ejbType())) {
            return "ejb";
        }
        if (moduleType.equals((Object)DOLUtils.carType())) {
            return "appclient";
        }
        if (moduleType.equals((Object)DOLUtils.rarType())) {
            return "connector";
        }
        return null;
    }

    private static List<String> addAdditionalIncompatTypes(Sniffer mainSniffer, String[] incompatTypes) {
        ArrayList<String> allIncompatTypes = new ArrayList<String>();
        for (String incompatType : incompatTypes) {
            allIncompatTypes.add(incompatType);
        }
        if (mainSniffer.getModuleType().equals("appclient")) {
            allIncompatTypes.add("ejb");
        } else if (mainSniffer.getModuleType().equals("ejb")) {
            allIncompatTypes.add("appclient");
        }
        return allIncompatTypes;
    }

    public static List<ConfigurationDeploymentDescriptorFile> getConfigurationDeploymentDescriptorFiles(ServiceLocator habitat, String containerType) {
        ArrayList<ConfigurationDeploymentDescriptorFile> confDDFiles = new ArrayList<ConfigurationDeploymentDescriptorFile>();
        for (ServiceHandle serviceHandle : habitat.getAllServiceHandles(ConfigurationDeploymentDescriptorFileFor.class, new Annotation[0])) {
            ActiveDescriptor descriptor = serviceHandle.getActiveDescriptor();
            String indexedType = (String)((List)descriptor.getMetadata().get("DescriptorFor")).get(0);
            if (!indexedType.equals(containerType)) continue;
            ConfigurationDeploymentDescriptorFile confDD = (ConfigurationDeploymentDescriptorFile)serviceHandle.getService();
            confDDFiles.add(confDD);
        }
        return confDDFiles;
    }

    public static boolean setElementValue(XMLElement element, String value, Object o) {
        if (SCHEMA_LOCATION_TAG.equals(element.getCompleteName())) {
            StringTokenizer st = new StringTokenizer(value);
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreElements()) {
                String schema;
                String namespace = (String)st.nextElement();
                if (st.hasMoreElements()) {
                    schema = (String)st.nextElement();
                } else {
                    schema = namespace;
                    namespace = "http://java.sun.com/xml/ns/javaee";
                }
                if (namespace.equals("http://java.sun.com/xml/ns/j2ee") || namespace.equals("http://java.sun.com/xml/ns/javaee") || namespace.equals(W3C_XML_SCHEMA)) continue;
                sb.append(namespace);
                sb.append(" ");
                sb.append(schema);
            }
            String clientSchemaLocation = sb.toString();
            if (clientSchemaLocation != null && clientSchemaLocation.length() != 0 && o instanceof RootDeploymentDescriptor) {
                ((RootDeploymentDescriptor)o).setSchemaLocation(clientSchemaLocation);
            }
            return true;
        }
        if (element.getQName().equals("metadata-complete")) {
            if (o instanceof BundleDescriptor) {
                ((BundleDescriptor)o).setFullAttribute(value);
            }
            return true;
        }
        return false;
    }

    public static List<String> getProprietarySchemaNamespaces() {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add("http://www.bea.com/ns/weblogic/");
        ns.add("http://xmlns.oracle.com/weblogic/");
        return ns;
    }

    public static List<String> getProprietaryDTDStart() {
        ArrayList<String> ns = new ArrayList<String>();
        ns.add("http://www.beasys.com/servers");
        return ns;
    }
}

