/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;

public class TracerVisitor
extends DefaultDOLVisitor
implements ApplicationVisitor,
EjbBundleVisitor {
    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            this.accept(application);
            for (BundleDescriptor ebd : application.getBundleDescriptorsOfType(DeploymentUtils.ejbType())) {
                ebd.visit(this.getSubDescriptorVisitor((Descriptor)ebd));
            }
            for (BundleDescriptor wbd : application.getBundleDescriptorsOfType(DeploymentUtils.warType())) {
                if (wbd == null) continue;
                wbd.visit(this.getSubDescriptorVisitor((Descriptor)wbd));
            }
            for (BundleDescriptor cd : application.getBundleDescriptorsOfType(DeploymentUtils.rarType())) {
                cd.visit(this.getSubDescriptorVisitor((Descriptor)cd));
            }
            for (BundleDescriptor acd : application.getBundleDescriptorsOfType(DeploymentUtils.carType())) {
                acd.visit(this.getSubDescriptorVisitor((Descriptor)acd));
            }
            super.accept(descriptor);
        } else if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)descriptor;
            this.accept(ejbBundle);
            for (EjbDescriptor anEjb : ejbBundle.getEjbs()) {
                anEjb.visit(this.getSubDescriptorVisitor(anEjb));
            }
            if (ejbBundle.hasRelationships()) {
                for (RelationshipDescriptor rd : ejbBundle.getRelationships()) {
                    this.accept(rd);
                }
            }
            for (WebService aWebService : ejbBundle.getWebServices().getWebServices()) {
                this.accept(aWebService);
            }
            super.accept(descriptor);
        } else {
            super.accept(descriptor);
        }
    }

    public void accept(Application application) {
        DOLUtils.getDefaultLogger().info("Application");
        DOLUtils.getDefaultLogger().info("name " + application.getName());
        DOLUtils.getDefaultLogger().info("smallIcon " + application.getSmallIconUri());
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        DOLUtils.getDefaultLogger().info("Ejb Bundle " + bundleDescriptor.getName());
    }

    protected void accept(EjbDescriptor ejb) {
        MessageDestinationReferencer msgDestReferencer;
        Set methods;
        DOLUtils.getDefaultLogger().info("==================");
        DOLUtils.getDefaultLogger().info(ejb.getType() + " Bean " + ejb.getName());
        DOLUtils.getDefaultLogger().info("\thomeClassName " + ejb.getHomeClassName());
        DOLUtils.getDefaultLogger().info("\tremoteClassName " + ejb.getRemoteClassName());
        DOLUtils.getDefaultLogger().info("\tlocalhomeClassName " + ejb.getLocalHomeClassName());
        DOLUtils.getDefaultLogger().info("\tlocalClassName " + ejb.getLocalClassName());
        DOLUtils.getDefaultLogger().info("\tremoteBusinessIntfs " + ejb.getRemoteBusinessClassNames());
        DOLUtils.getDefaultLogger().info("\tlocalBusinessIntfs " + ejb.getLocalBusinessClassNames());
        DOLUtils.getDefaultLogger().info("\tjndiName " + ejb.getJndiName());
        DOLUtils.getDefaultLogger().info("\tejbClassName " + ejb.getEjbClassName());
        DOLUtils.getDefaultLogger().info("\ttransactionType " + ejb.getTransactionType());
        if (!ejb.getUsesCallerIdentity().booleanValue()) {
            DOLUtils.getDefaultLogger().info("\trun-as role " + (Object)((Object)ejb.getRunAsIdentity()));
        } else {
            DOLUtils.getDefaultLogger().info("\tuse-caller-identity " + ejb.getUsesCallerIdentity());
        }
        for (EjbReference ejbReference : ejb.getEjbReferenceDescriptors()) {
            this.accept(ejbReference);
        }
        for (MethodPermission methodPermission : ejb.getPermissionedMethodsByPermission().keySet()) {
            methods = (Set)ejb.getPermissionedMethodsByPermission().get((Object)methodPermission);
            this.accept(methodPermission, methods.iterator());
        }
        if (ejb.getStyledPermissionedMethodsByPermission() != null) {
            for (MethodPermission methodPermission : ejb.getStyledPermissionedMethodsByPermission().keySet()) {
                methods = (Set)ejb.getStyledPermissionedMethodsByPermission().get((Object)methodPermission);
                this.accept(methodPermission, methods.iterator());
            }
        }
        for (RoleReference roleReference : ejb.getRoleReferences()) {
            this.accept(roleReference);
        }
        for (MethodDescriptor methodDescriptor : ejb.getMethodContainerTransactions().keySet()) {
            ContainerTransaction ct = (ContainerTransaction)((Object)ejb.getMethodContainerTransactions().get((Object)methodDescriptor));
            this.accept(methodDescriptor, ct);
        }
        for (EnvironmentProperty environmentProperty : ejb.getEnvironmentProperties()) {
            this.accept(environmentProperty);
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : ejb.getResourceReferenceDescriptors()) {
            this.accept(resourceReferenceDescriptor);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : ejb.getResourceEnvReferenceDescriptors()) {
            this.accept(resourceEnvReferenceDescriptor);
        }
        for (MessageDestinationReferencer messageDestinationReferencer : ejb.getMessageDestinationReferenceDescriptors()) {
            this.accept(messageDestinationReferencer);
        }
        if (ejb.getType().equals("Message-driven") && (msgDestReferencer = (MessageDestinationReferencer)((Object)ejb)).getMessageDestinationLinkName() != null) {
            this.accept(msgDestReferencer);
        }
        Set<ServiceReferenceDescriptor> serviceRefs = ejb.getServiceReferenceDescriptors();
        Iterator<ServiceReferenceDescriptor> iterator = serviceRefs.iterator();
        while (iterator.hasNext()) {
            this.accept(iterator.next());
        }
        if (ejb instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejb;
            PersistenceDescriptor persistenceDesc = ejbCMPEntityDescriptor.getPersistenceDescriptor();
            for (FieldDescriptor fd : persistenceDesc.getCMPFields()) {
                this.accept(fd);
            }
            for (Object method : persistenceDesc.getQueriedMethods()) {
                if (!(method instanceof MethodDescriptor)) continue;
                QueryDescriptor qd = persistenceDesc.getQueryFor((MethodDescriptor)((Object)method));
                this.accept((MethodDescriptor)((Object)method), qd);
            }
        }
    }

    protected void accept(EjbReference ejbRef) {
        DOLUtils.getDefaultLogger().info(ejbRef.toString());
    }

    protected void accept(MessageDestinationReferencer referencer) {
        DOLUtils.getDefaultLogger().info(referencer.getMessageDestinationLinkName());
    }

    protected void accept(WebService webService) {
        DOLUtils.getDefaultLogger().info(webService.getName());
    }

    protected void accept(ServiceReferenceDescriptor serviceRef) {
        DOLUtils.getDefaultLogger().info(serviceRef.getName());
    }

    protected void accept(MethodPermission pm, Iterator methods) {
        DOLUtils.getDefaultLogger().info("For method permission : " + pm.toString());
        while (methods.hasNext()) {
            DOLUtils.getDefaultLogger().info("\t" + ((MethodDescriptor)((Object)methods.next())).prettyPrint());
        }
    }

    protected void accept(RoleReference roleRef) {
        DOLUtils.getDefaultLogger().info("Security Role Reference : " + roleRef.getName() + " link " + roleRef.getValue());
    }

    protected void accept(MethodDescriptor method, ContainerTransaction ct) {
        DOLUtils.getDefaultLogger().info(ct.getTransactionAttribute() + " Container Transaction for method " + method.prettyPrint());
    }

    protected void accept(EnvironmentProperty envEntry) {
        DOLUtils.getDefaultLogger().info(envEntry.toString());
    }

    protected void accept(FieldDescriptor fd) {
        DOLUtils.getDefaultLogger().info("CMP Field " + (Object)((Object)fd));
    }

    protected void accept(MethodDescriptor method, QueryDescriptor qd) {
        DOLUtils.getDefaultLogger().info(qd.toString());
    }

    protected void accept(RelationshipDescriptor descriptor) {
        DOLUtils.getDefaultLogger().info("============ Relationships ===========");
        DOLUtils.getDefaultLogger().info("From EJB " + descriptor.getSource().getName() + " cmr field : " + descriptor.getSource().getCMRField() + "(" + descriptor.getSource().getCMRFieldType() + ")  to EJB " + descriptor.getSink().getName() + " isMany " + descriptor.getSource().getIsMany() + " cascade-delete " + descriptor.getSource().getCascadeDelete());
        DOLUtils.getDefaultLogger().info("To  EJB " + descriptor.getSink().getName() + " isMany " + descriptor.getSink().getIsMany() + " cascade-delete " + descriptor.getSink().getCascadeDelete());
        if (descriptor.getIsBidirectional()) {
            DOLUtils.getDefaultLogger().info("Bidirectional cmr field : " + descriptor.getSink().getCMRField() + "(" + descriptor.getSink().getCMRFieldType() + ")");
        }
    }

    public void accept(Descriptor descriptor) {
        DOLUtils.getDefaultLogger().info(descriptor.toString());
    }

    public DescriptorVisitor getSubDescriptorVisitor(Descriptor subDescriptor) {
        if (subDescriptor instanceof BundleDescriptor) {
            DescriptorVisitor tracerVisitor = ((BundleDescriptor)subDescriptor).getTracerVisitor();
            if (tracerVisitor == null) {
                return this;
            }
            return tracerVisitor;
        }
        return super.getSubDescriptorVisitor(subDescriptor);
    }
}

