/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentValidator
extends DefaultDOLVisitor
implements ComponentVisitor {
    protected BundleDescriptor bundleDescriptor = null;
    protected Application application;

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    @Override
    public void accept(BundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        super.accept(bundleDescriptor);
    }

    @Override
    protected void accept(MessageDestinationReferencer msgDestReferencer) {
        if (msgDestReferencer.isLinkedToMessageDestination()) {
            return;
        }
        if (msgDestReferencer.ownedByMessageDestinationRef() && msgDestReferencer.getMessageDestinationRefOwner().getJndiName() != null) {
            return;
        }
        MessageDestinationDescriptor msgDest = msgDestReferencer.resolveLinkName();
        if (msgDest == null) {
            String linkName = msgDestReferencer.getMessageDestinationLinkName();
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{"message-destination", linkName});
        } else if (msgDestReferencer instanceof MessageDestinationReferenceDescriptor) {
            ((MessageDestinationReferenceDescriptor)msgDestReferencer).setJndiName(msgDest.getJndiName());
        }
    }

    @Override
    protected void accept(ServiceReferenceDescriptor serviceRef) {
        Set portsInfo = serviceRef.getPortsInfo();
        for (ServiceRefPortInfo next : portsInfo) {
            WebServiceEndpoint portComponentLink;
            if (!next.hasPortComponentLinkName() || next.isLinkedToPortComponent() || (portComponentLink = next.resolveLinkName()) != null) continue;
            String linkName = next.getPortComponentLinkName();
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{"port-component", linkName});
        }
    }

    @Override
    protected void accept(ResourceReferenceDescriptor resRef) {
        this.computeRuntimeDefault(resRef);
    }

    @Override
    protected void accept(ResourceEnvReferenceDescriptor resourceEnvRef) {
        String refType;
        Map<String, ManagedBeanDescriptor> managedBeanMap;
        if ((resourceEnvRef.getJndiName() == null || resourceEnvRef.getJndiName().length() == 0) && (managedBeanMap = this.getManagedBeanMap()).containsKey(refType = resourceEnvRef.getRefType())) {
            ManagedBeanDescriptor desc = managedBeanMap.get(refType);
            String jndiName = this.bundleDescriptor.getModuleType() == DeploymentUtils.carType() ? desc.getAppJndiName() : desc.getGlobalJndiName();
            resourceEnvRef.setJndiName(jndiName);
            resourceEnvRef.setIsManagedBean(true);
            resourceEnvRef.setManagedBeanDescriptor(desc);
        }
        this.computeRuntimeDefault(resourceEnvRef);
    }

    protected void accept(MessageDestinationReferenceDescriptor msgDestRef) {
        this.computeRuntimeDefault(msgDestRef);
    }

    @Override
    protected void accept(MessageDestinationDescriptor msgDest) {
        this.computeRuntimeDefault(msgDest);
    }

    protected void accept(InjectionCapable injectable) {
        this.acceptWithCL(injectable);
        this.acceptWithoutCL(injectable);
    }

    protected void acceptWithCL(InjectionCapable injectable) {
        for (InjectionTarget target : injectable.getInjectionTargets()) {
            if (target.getFieldName() != null || target.getMethodName() != null) continue;
            String injectTargetName = target.getTargetName();
            String targetClassName = target.getClassName();
            ClassLoader classLoader = this.getBundleDescriptor().getClassLoader();
            Class<?> targetClazz = null;
            try {
                targetClazz = classLoader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException cnfe) {
                DOLUtils.getDefaultLogger().fine("Injection class " + targetClassName + " not found for " + injectable);
                return;
            }
            boolean matched = false;
            String setterMethodName = TypeUtil.propertyNameToSetterMethod(injectTargetName);
            for (Method next : targetClazz.getDeclaredMethods()) {
                Class<?>[] paramTypes;
                if (!next.getName().equals(setterMethodName) || next.getParameterTypes().length != 1) continue;
                target.setMethodName(next.getName());
                if (injectable.getInjectResourceType() == null && (paramTypes = next.getParameterTypes()).length == 1) {
                    String resourceType = paramTypes[0].getName();
                    injectable.setInjectResourceType(resourceType);
                }
                matched = true;
                break;
            }
            if (matched) continue;
            try {
                Field f = targetClazz.getDeclaredField(injectTargetName);
                target.setFieldName(injectTargetName);
                if (injectable.getInjectResourceType() == null) {
                    String resourceType = f.getType().getName();
                    injectable.setInjectResourceType(resourceType);
                }
                matched = true;
            }
            catch (NoSuchFieldException nsfe) {
                String msg = "No matching injection setter method or injection field found for injection property " + injectTargetName + " on class " + targetClassName + " for component dependency " + injectable;
                throw new RuntimeException(msg, nsfe);
            }
        }
    }

    protected void acceptWithoutCL(InjectionCapable injectable) {
    }

    protected void computeRunAsPrincipalDefault(RunAsIdentityDescriptor runAs, Application application) {
        if (runAs != null && (runAs.getRoleName() == null || runAs.getRoleName().length() == 0)) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.emptyRoleName");
            return;
        }
        if (runAs != null && (runAs.getPrincipal() == null || runAs.getPrincipal().length() == 0) && application != null && application.getRoleMapper() != null) {
            String principalName = null;
            String roleName = runAs.getRoleName();
            final Subject fs = (Subject)application.getRoleMapper().getRoleToSubjectMapping().get(roleName);
            if (fs != null) {
                principalName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Set<Principal> pset = fs.getPrincipals();
                        Principal prin = null;
                        if (pset.size() > 0) {
                            prin = pset.iterator().next();
                            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.computeRunAsPrincipal", new Object[]{prin.getName()});
                        }
                        return prin != null ? prin.getName() : null;
                    }
                });
            }
            if (principalName == null || principalName.length() == 0) {
                throw new RuntimeException("The RunAs role \"" + roleName + "\"" + " is not mapped to a principal.");
            }
            runAs.setPrincipal(principalName);
        }
    }

    private Map<String, ManagedBeanDescriptor> getManagedBeanMap() {
        RootDeploymentDescriptor desc;
        BundleDescriptor thisBundle = this.getBundleDescriptor();
        Set<Object> managedBeans = new HashSet();
        if (thisBundle != null && (desc = thisBundle.getModuleDescriptor().getDescriptor()) instanceof BundleDescriptor) {
            managedBeans = ((BundleDescriptor)desc).getManagedBeans();
        }
        HashMap<String, ManagedBeanDescriptor> managedBeanMap = new HashMap<String, ManagedBeanDescriptor>();
        for (ManagedBeanDescriptor managedBean : managedBeans) {
            String beanClassName = managedBean.getBeanClassName();
            managedBeanMap.put(beanClassName, managedBean);
        }
        return managedBeanMap;
    }

    private void computeRuntimeDefault(ResourceReferenceDescriptor resRef) {
        if (resRef.getType() != null && resRef.getType().equals("org.omg.CORBA.ORB")) {
            resRef.setJndiName("java:comp/ORB");
        } else if (resRef.getJndiName() == null || resRef.getJndiName().length() == 0) {
            resRef.setJndiName(this.getDefaultResourceJndiName(resRef.getName()));
        }
    }

    private void computeRuntimeDefault(ResourceEnvReferenceDescriptor resourceEnvRef) {
        if (resourceEnvRef.getRefType() != null && resourceEnvRef.getRefType().equals("javax.transaction.UserTransaction")) {
            resourceEnvRef.setJndiName("java:comp/UserTransaction");
        } else if (resourceEnvRef.getRefType() != null && resourceEnvRef.getRefType().equals("javax.transaction.TransactionSynchronizationRegistry")) {
            resourceEnvRef.setJndiName("java:comp/TransactionSynchronizationRegistry");
        } else if (resourceEnvRef.getJndiName() == null || resourceEnvRef.getJndiName().length() == 0) {
            resourceEnvRef.setJndiName(this.getDefaultResourceJndiName(resourceEnvRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationReferenceDescriptor msgDestRef) {
        if (msgDestRef.getJndiName() == null || msgDestRef.getJndiName().length() == 0) {
            msgDestRef.setJndiName(this.getDefaultResourceJndiName(msgDestRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationDescriptor msgDest) {
        if (msgDest.getJndiName() == null || msgDest.getJndiName().length() == 0) {
            msgDest.setJndiName(this.getDefaultResourceJndiName(msgDest.getName()));
        }
    }

    private String getDefaultResourceJndiName(String resName) {
        return resName;
    }
}

