/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service(name="application_deploy")
public class ApplicationValidator
extends EjbBundleValidator
implements ApplicationVisitor,
ManagedBeanVisitor {
    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            this.accept(application);
            for (BundleDescriptor ebd : application.getBundleDescriptorsOfType(DeploymentUtils.ejbType())) {
                ebd.visit(this.getSubDescriptorVisitor((Descriptor)ebd));
            }
            for (BundleDescriptor wbd : application.getBundleDescriptorsOfType(DeploymentUtils.warType())) {
                if (wbd == null) continue;
                wbd.visit(this.getSubDescriptorVisitor((Descriptor)wbd));
            }
            for (BundleDescriptor cd : application.getBundleDescriptorsOfType(DeploymentUtils.rarType())) {
                cd.visit(this.getSubDescriptorVisitor((Descriptor)cd));
            }
            for (BundleDescriptor acd : application.getBundleDescriptorsOfType(DeploymentUtils.carType())) {
                acd.visit(this.getSubDescriptorVisitor((Descriptor)acd));
            }
            for (InjectionCapable injectable : application.getInjectableResources(application)) {
                this.accept(injectable);
            }
            super.accept(descriptor);
        } else {
            super.accept(descriptor);
        }
    }

    public void accept(Application application) {
        this.application = application;
        if (application.getBundleDescriptors().size() == 0) {
            throw new IllegalArgumentException("Application [" + application.getRegistrationName() + "] contains no valid components");
        }
        ArrayList<ModuleDescriptor<BundleDescriptor>> conflicted = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        Set<ModuleDescriptor<BundleDescriptor>> modules = application.getModules();
        for (ModuleDescriptor<BundleDescriptor> moduleDescriptor : modules) {
            if (conflicted.contains(moduleDescriptor)) continue;
            boolean foundConflictedModule = false;
            for (ModuleDescriptor<BundleDescriptor> module2 : modules) {
                if (conflicted.contains(module2) || moduleDescriptor.equals(module2) || !moduleDescriptor.getModuleName().equals(module2.getModuleName())) continue;
                conflicted.add(module2);
                foundConflictedModule = true;
            }
            if (!foundConflictedModule) continue;
            conflicted.add(moduleDescriptor);
        }
        for (ModuleDescriptor moduleDescriptor : conflicted) {
            moduleDescriptor.setModuleName(moduleDescriptor.getModuleName() + moduleDescriptor.getModuleType().toString());
        }
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        this.application = bundleDescriptor.getApplication();
        super.accept(bundleDescriptor);
        String rlm = this.application.getRealm();
        for (EjbDescriptor ejb : bundleDescriptor.getEjbs()) {
            for (EjbIORConfigurationDescriptor desc : ejb.getIORConfigurationDescriptors()) {
                if (rlm == null) continue;
                desc.setRealmName(rlm);
            }
        }
    }

    public void accept(ManagedBeanDescriptor managedBean) {
        this.bundleDescriptor = managedBean.getBundle();
        this.application = this.bundleDescriptor.getApplication();
        for (EjbReference aRef : managedBean.getEjbReferenceDescriptors()) {
            this.accept(aRef);
        }
        for (Object next : managedBean.getResourceReferenceDescriptors()) {
            this.accept((ResourceReferenceDescriptor)next);
        }
        for (Object next : managedBean.getResourceEnvReferenceDescriptors()) {
            this.accept((ResourceEnvReferenceDescriptor)next);
        }
        for (Object next : managedBean.getMessageDestinationReferenceDescriptors()) {
            this.accept((MessageDestinationReferencer)next);
        }
        Set serviceRefs = managedBean.getServiceReferenceDescriptors();
        Iterator itr = serviceRefs.iterator();
        while (itr.hasNext()) {
            this.accept((ServiceReferenceDescriptor)itr.next());
        }
    }

    protected Collection getEjbDescriptors() {
        if (this.application != null) {
            return this.application.getEjbDescriptors();
        }
        return new HashSet();
    }

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public DescriptorVisitor getSubDescriptorVisitor(Descriptor subDescriptor) {
        if (subDescriptor instanceof BundleDescriptor) {
            return ((BundleDescriptor)subDescriptor).getBundleVisitor();
        }
        return super.getSubDescriptorVisitor(subDescriptor);
    }
}

