/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.CookieConfigDescriptor;
import com.sun.enterprise.deployment.SessionConfigDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.runtime.web.WebPropertyContainer;
import com.sun.enterprise.deployment.web.CookieConfig;
import java.util.Set;
import javax.servlet.SessionTrackingMode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WLSessionDescriptorNode
extends RuntimeDescriptorNode {
    private static final String COOKIE = "COOKIE";
    private static final String URL = "URL";
    private static final String SSL = "SSL";
    private static final String TIMEOUT_SECONDS = "timeoutSeconds";
    private static final String REAP_INTERVAL_SECONDS = "reapIntervalSeconds";
    private static final String MAX_SESSIONS = "maxSessions";
    private static final String DIRECTORY = "directory";
    private boolean cookieTrackingMode = true;
    private boolean urlTrackingMode = true;
    private int timeoutSecs = 3600;

    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if (name.equals("timeout-secs")) {
            this.timeoutSecs = Integer.parseInt(value);
        } else if (name.equals("invalidation-interval-secs")) {
            Integer.parseInt(value);
            this.addManagerProperty(REAP_INTERVAL_SECONDS, value);
        } else if (name.equals("max-in-memory-sessions")) {
            Integer.parseInt(value);
            this.addManagerProperty(MAX_SESSIONS, value);
        } else if (name.equals("cookie-name")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setName(value);
        } else if (name.equals("cookie-path")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setPath(value);
        } else if (name.equals("cookie-domain")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setDomain(value);
        } else if (name.equals("cookie-comment")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setComment(value);
        } else if (name.equals("cookie-secure")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setSecure(Boolean.parseBoolean(value));
        } else if (name.equals("cookie-max-age-secs")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setMaxAge(Integer.parseInt(value));
        } else if (name.equals("cookie-http-only")) {
            CookieConfig cookieConfig = this.getCookieConfig();
            cookieConfig.setHttpOnly(Boolean.parseBoolean(value));
        } else if (name.equals("cookies-enabled")) {
            this.cookieTrackingMode = Boolean.parseBoolean(value);
        } else if (name.equals("url-rewriting-enabled")) {
            this.urlTrackingMode = Boolean.parseBoolean(value);
        } else if (name.equals("persistent-store-dir")) {
            this.addStoreProperty(DIRECTORY, value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public boolean endElement(XMLElement element) {
        if ("session-descriptor".equals(element.getQName())) {
            SessionConfig runtimeSessionConfig = this.getRuntimeSessionConfig();
            SessionProperties sessionProperties = runtimeSessionConfig.getSessionProperties();
            if (sessionProperties == null) {
                sessionProperties = new SessionProperties();
                runtimeSessionConfig.setSessionProperties(sessionProperties);
            }
            this.addWebProperty(sessionProperties, TIMEOUT_SECONDS, Integer.toString(this.timeoutSecs));
            if (this.cookieTrackingMode && this.urlTrackingMode) {
                com.sun.enterprise.deployment.web.SessionConfig sessionConfig = this.getSessionConfig();
                sessionConfig.addTrackingMode(COOKIE);
                sessionConfig.addTrackingMode(URL);
            } else if (!this.cookieTrackingMode && this.urlTrackingMode) {
                com.sun.enterprise.deployment.web.SessionConfig sessionConfig = this.getSessionConfig();
                sessionConfig.removeTrackingMode(COOKIE);
                sessionConfig.addTrackingMode(URL);
            } else if (this.cookieTrackingMode && !this.urlTrackingMode) {
                com.sun.enterprise.deployment.web.SessionConfig sessionConfig = this.getSessionConfig();
                sessionConfig.addTrackingMode(COOKIE);
                sessionConfig.removeTrackingMode(URL);
            } else {
                com.sun.enterprise.deployment.web.SessionConfig sessionConfig = this.getSessionConfig();
                sessionConfig.removeTrackingMode(COOKIE);
                sessionConfig.removeTrackingMode(URL);
                sessionConfig.addTrackingMode(SSL);
            }
        }
        return super.endElement(element);
    }

    public Object getDescriptor() {
        return null;
    }

    public Node writeDescriptor(Element root, WebBundleDescriptor webBundleDescriptor) {
        StoreProperties storeProperties;
        SessionManager sessionManager;
        com.sun.enterprise.deployment.web.SessionConfig sessionConfig = webBundleDescriptor.getSessionConfig();
        SessionConfig runtimeSessionConfig = webBundleDescriptor.getSunDescriptor().getSessionConfig();
        Element scNode = null;
        if (sessionConfig != null || runtimeSessionConfig != null) {
            scNode = WLSessionDescriptorNode.appendChild(root, "session-descriptor");
        }
        if (runtimeSessionConfig != null) {
            ManagerProperties managerProperties;
            SessionManager sessionManager2;
            SessionProperties sessionProperties = runtimeSessionConfig.getSessionProperties();
            if (sessionProperties != null && sessionProperties.sizeWebProperty() > 0) {
                for (WebProperty prop : sessionProperties.getWebProperty()) {
                    String name = prop.getAttributeValue("name");
                    String value = prop.getAttributeValue("value");
                    if (!TIMEOUT_SECONDS.equals(name)) continue;
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "timeout-secs", value);
                    break;
                }
            }
            if ((sessionManager2 = runtimeSessionConfig.getSessionManager()) != null && (managerProperties = sessionManager2.getManagerProperties()) != null && managerProperties.sizeWebProperty() > 0) {
                for (WebProperty prop : managerProperties.getWebProperty()) {
                    String name = prop.getAttributeValue("name");
                    String value = prop.getAttributeValue("value");
                    if (name.equals(REAP_INTERVAL_SECONDS)) {
                        WLSessionDescriptorNode.appendTextChild((Node)scNode, "invalidation-interval-secs", value);
                        continue;
                    }
                    if (!name.equals(MAX_SESSIONS)) continue;
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "max-in-memory-sessions", value);
                }
            }
        }
        if (sessionConfig != null) {
            CookieConfig cookieConfig;
            Set<SessionTrackingMode> trackingModes = sessionConfig.getTrackingModes();
            if (trackingModes.contains(SessionTrackingMode.COOKIE)) {
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookies-enabled", "true");
            }
            if ((cookieConfig = sessionConfig.getCookieConfig()) != null) {
                if (cookieConfig.getName() != null && cookieConfig.getName().length() > 0) {
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-name", cookieConfig.getName());
                }
                if (cookieConfig.getPath() != null) {
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-path", cookieConfig.getPath());
                }
                if (cookieConfig.getDomain() != null) {
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-domain", cookieConfig.getDomain());
                }
                if (cookieConfig.getComment() != null) {
                    WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-comment", cookieConfig.getComment());
                }
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-secure", Boolean.toString(cookieConfig.isSecure()));
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-max-age-secs", Integer.toString(cookieConfig.getMaxAge()));
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "cookie-http-only", Boolean.toString(cookieConfig.isHttpOnly()));
            }
            if (trackingModes.contains(SessionTrackingMode.URL)) {
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "url-rewriting-enabled", "true");
            }
        }
        if (runtimeSessionConfig != null && (sessionManager = runtimeSessionConfig.getSessionManager()) != null && (storeProperties = sessionManager.getStoreProperties()) != null && storeProperties.sizeWebProperty() > 0) {
            for (WebProperty prop : storeProperties.getWebProperty()) {
                String name = prop.getAttributeValue("name");
                String value = prop.getAttributeValue("value");
                if (!name.equals(DIRECTORY)) continue;
                WLSessionDescriptorNode.appendTextChild((Node)scNode, "persistent-store-dir", value);
                break;
            }
        }
        return scNode;
    }

    private SessionConfig getRuntimeSessionConfig() {
        WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
        SunWebApp sunDescriptor = webBundleDescriptor.getSunDescriptor();
        SessionConfig runtimeSessionConfig = sunDescriptor.getSessionConfig();
        if (runtimeSessionConfig == null) {
            runtimeSessionConfig = new SessionConfig();
            sunDescriptor.setSessionConfig(runtimeSessionConfig);
        }
        return runtimeSessionConfig;
    }

    private void addManagerProperty(String name, String value) {
        SessionManager sessionManager = this.getSessionManager();
        ManagerProperties managerProperties = sessionManager.getManagerProperties();
        if (managerProperties == null) {
            managerProperties = new ManagerProperties();
            sessionManager.setManagerProperties(managerProperties);
        }
        this.addWebProperty(managerProperties, name, value);
    }

    private void addStoreProperty(String name, String value) {
        SessionManager sessionManager = this.getSessionManager();
        StoreProperties storeProperties = sessionManager.getStoreProperties();
        if (storeProperties == null) {
            storeProperties = new StoreProperties();
            sessionManager.setStoreProperties(storeProperties);
        }
        this.addWebProperty(storeProperties, name, value);
    }

    private void addWebProperty(WebPropertyContainer webPropertyContainer, String name, String value) {
        WebProperty webProperty = new WebProperty();
        webProperty.setAttributeValue("name", name);
        webProperty.setAttributeValue("value", value);
        webPropertyContainer.addWebProperty(webProperty);
    }

    private SessionManager getSessionManager() {
        SessionConfig runtimeSessionConfig = this.getRuntimeSessionConfig();
        SessionManager sessionManager = runtimeSessionConfig.getSessionManager();
        if (sessionManager == null) {
            sessionManager = new SessionManager();
            runtimeSessionConfig.setSessionManager(sessionManager);
        }
        return sessionManager;
    }

    private com.sun.enterprise.deployment.web.SessionConfig getSessionConfig() {
        WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
        com.sun.enterprise.deployment.web.SessionConfig sessionConfig = webBundleDescriptor.getSessionConfig();
        if (sessionConfig == null) {
            sessionConfig = new SessionConfigDescriptor();
            webBundleDescriptor.setSessionConfig(sessionConfig);
        }
        return sessionConfig;
    }

    private CookieConfig getCookieConfig() {
        com.sun.enterprise.deployment.web.SessionConfig sessionConfig = this.getSessionConfig();
        CookieConfig cookieConfig = sessionConfig.getCookieConfig();
        if (cookieConfig == null) {
            cookieConfig = new CookieConfigDescriptor();
            sessionConfig.setCookieConfig(cookieConfig);
        }
        return cookieConfig;
    }
}

