/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.web.LocaleCharsetMapNode;
import com.sun.enterprise.deployment.node.runtime.web.WebRuntimeNode;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class LocaleCharsetInfoNode
extends WebRuntimeNode {
    public LocaleCharsetInfoNode() {
        this.registerElementHandler(new XMLElement("locale-charset-map"), LocaleCharsetMapNode.class, "addLocaleCharsetMap");
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if (element.getQName().equals("locale-charset-info")) {
            LocaleCharsetInfo info = (LocaleCharsetInfo)((Object)this.getDescriptor());
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!"default-locale".equals(attributes.getQName(i))) continue;
                info.setAttributeValue("DefaultLocale", attributes.getValue(i));
            }
        } else if (element.getQName().equals("parameter-encoding")) {
            LocaleCharsetInfo info = (LocaleCharsetInfo)((Object)this.getDescriptor());
            info.setParameterEncoding(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("default-charset".equals(attributes.getQName(i))) {
                    info.setAttributeValue("ParameterEncoding", "DefaultCharset", attributes.getValue(i));
                }
                if (!"form-hint-field".equals(attributes.getQName(i))) continue;
                info.setAttributeValue("ParameterEncoding", "FormHintField", attributes.getValue(i));
            }
        } else {
            super.startElement(element, attributes);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, LocaleCharsetInfo descriptor) {
        Element locale = (Element)super.writeDescriptor(parent, nodeName, descriptor);
        if (descriptor.sizeLocaleCharsetMap() > 0) {
            LocaleCharsetMapNode lcmn = new LocaleCharsetMapNode();
            for (int i = 0; i < descriptor.sizeLocaleCharsetMap(); ++i) {
                lcmn.writeDescriptor((Node)locale, "locale-charset-map", descriptor.getLocaleCharsetMap(i));
            }
        }
        if (descriptor.isParameterEncoding()) {
            Element parameter = LocaleCharsetInfoNode.appendChild(locale, "parameter-encoding");
            if (descriptor.getAttributeValue("ParameterEncoding", "FormHintField") != null) {
                LocaleCharsetInfoNode.setAttribute(parameter, "form-hint-field", descriptor.getAttributeValue("ParameterEncoding", "FormHintField"));
            }
            if (descriptor.getAttributeValue("ParameterEncoding", "DefaultCharset") != null) {
                LocaleCharsetInfoNode.setAttribute(parameter, "default-charset", descriptor.getAttributeValue("ParameterEncoding", "DefaultCharset"));
            }
        }
        if (descriptor.getAttributeValue("DefaultLocale") != null) {
            LocaleCharsetInfoNode.setAttribute(locale, "default-locale", descriptor.getAttributeValue("DefaultLocale"));
        }
        return locale;
    }
}

