/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.application.wls;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.node.runtime.common.wls.SecurityRoleAssignmentNode;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.runtime.application.wls.ApplicationParameter;
import com.sun.enterprise.deployment.runtime.common.wls.SecurityRoleAssignment;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.glassfish.security.common.Role;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogicApplicationNode
extends RuntimeBundleNode<Application> {
    public static final String SCHEMA_ID = "weblogic-application.xsd";
    private static final List<String> systemIDs = WeblogicApplicationNode.initSystemIDs();

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        return Collections.unmodifiableList(systemIDs);
    }

    public WeblogicApplicationNode(Application descriptor) {
        super(descriptor);
    }

    public WeblogicApplicationNode() {
        super(null);
    }

    @Override
    protected void init() {
        super.init();
        this.registerElementHandler(new XMLElement("application-param"), InitParamNode.class);
        this.registerElementHandler(new XMLElement("security-role-assignment"), SecurityRoleAssignmentNode.class);
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return new XMLElement("weblogic-application");
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Application getDescriptor() {
        return (Application)this.descriptor;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EnvironmentProperty) {
            ((Application)this.descriptor).addApplicationParam((ApplicationParameter)newDescriptor);
        } else if (newDescriptor instanceof SecurityRoleAssignment) {
            SecurityRoleAssignment roleMap = (SecurityRoleAssignment)((Object)newDescriptor);
            if (this.descriptor != null && !((Application)this.descriptor).isVirtual()) {
                ((Application)this.descriptor).addWLRoleAssignments(roleMap);
                Role role = new Role(roleMap.getRoleName());
                SecurityRoleMapper rm = ((Application)this.descriptor).getRoleMapper();
                if (rm != null) {
                    if (roleMap.isExternallyDefined()) {
                        rm.assignRole((Principal)new Group(roleMap.getRoleName()), role, this.descriptor);
                    } else {
                        List<String> principals = roleMap.getPrincipalNames();
                        for (int i = 0; i < principals.size(); ++i) {
                            rm.assignRole((Principal)new PrincipalImpl(principals.get(i)), role, this.descriptor);
                        }
                    }
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, Application application) {
        Element root = WeblogicApplicationNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "http://xmlns.oracle.com/weblogic/weblogic-application");
        Set<ApplicationParameter> applicationParams = application.getApplicationParams();
        if (!applicationParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (ApplicationParameter appParam : applicationParams) {
                initParamNode.writeDescriptor((Node)root, "application-param", (EnvironmentProperty)appParam);
            }
        }
        List<SecurityRoleAssignment> wlRoleAssignments = application.getWlRoleAssignments();
        for (int i = 0; i < wlRoleAssignments.size(); ++i) {
            SecurityRoleAssignmentNode sran = new SecurityRoleAssignmentNode();
            sran.writeDescriptor((Node)root, "security-role-assignment", wlRoleAssignments.get(i));
        }
        return root;
    }
}

