/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MethodNode
extends DeploymentDescriptorNode {
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-name", "setEjbName");
        table.put("method-intf", "setEjbClassSymbol");
        table.put("method-name", "setName");
        table.put("method-param", "addParameterClass");
        return table;
    }

    public boolean endElement(XMLElement element) {
        MethodDescriptor desc;
        String qname = element.getQName();
        if ("method-params".equals(qname) && (desc = (MethodDescriptor)((Object)this.getDescriptor())).getParameterClassNames() == null) {
            desc.setEmptyParameterClassNames();
        }
        return super.endElement(element);
    }

    public Node writeDescriptor(Node parent, String nodeName, MethodDescriptor descriptor, String ejbName) {
        String methodIntfSymbol;
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeLocalizedDescriptions(methodNode, descriptor);
        if (ejbName != null && ejbName.length() > 0) {
            MethodNode.appendTextChild(methodNode, "ejb-name", ejbName);
        }
        if ((methodIntfSymbol = descriptor.getEjbClassSymbol()) != null && !methodIntfSymbol.equals("Bean")) {
            MethodNode.appendTextChild(methodNode, "method-intf", methodIntfSymbol);
        }
        MethodNode.appendTextChild(methodNode, "method-name", descriptor.getName());
        if (descriptor.getParameterClassNames() != null) {
            Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
            this.writeMethodParams(paramsNode, descriptor);
        }
        return methodNode;
    }

    public Node writeQueryMethodDescriptor(Node parent, String nodeName, MethodDescriptor descriptor) {
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        MethodNode.appendTextChild(methodNode, "method-name", descriptor.getName());
        Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
        this.writeMethodParams(paramsNode, descriptor);
        return methodNode;
    }

    public Node writeJavaMethodDescriptor(Node parent, String nodeName, MethodDescriptor descriptor) {
        return this.writeJavaMethodDescriptor(parent, nodeName, descriptor, false);
    }

    public Node writeJavaMethodDescriptor(Node parent, String nodeName, MethodDescriptor descriptor, boolean writeEmptyMethodParamsElementForVoidMethods) {
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        MethodNode.appendTextChild(methodNode, "method-name", descriptor.getName());
        if (descriptor.getParameterClassNames() != null) {
            Element paramsNode = MethodNode.appendChild(methodNode, "method-params");
            this.writeMethodParams(paramsNode, descriptor);
        } else if (writeEmptyMethodParamsElementForVoidMethods) {
            MethodNode.appendChild(methodNode, "method-params");
        }
        return methodNode;
    }

    private void writeMethodParams(Node paramsNode, MethodDescriptor descriptor) {
        String[] params = descriptor.getParameterClassNames();
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            MethodNode.appendTextChild(paramsNode, "method-param", params[i]);
        }
    }
}

