/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class J2EEDocumentBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        try {
            ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(J2EEDocumentBuilder.class.getClassLoader());
            DocumentBuilderFactory factory = null;
            try {
                factory = DocumentBuilderFactory.newInstance();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImplementation = builder.getDOMImplementation();
            Document document = builder.newDocument();
            return document;
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{"JAXP configuration error"});
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
            return null;
        }
    }

    public static Document getDocument(Descriptor descriptor, XMLNode node) {
        try {
            Node domNode = node.writeDescriptor(J2EEDocumentBuilder.newDocument(), descriptor);
            if (domNode instanceof Document) {
                return (Document)domNode;
            }
            return domNode.getOwnerDocument();
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Descriptor descriptor, RootXMLNode node, File resultFile) throws Exception {
        File f;
        if (node == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{descriptor, null});
            return;
        }
        if (resultFile.getParent() != null && !(f = new File(resultFile.getParent())).isDirectory() && !f.mkdirs()) {
            throw new IOException("Cannot create parent directory " + f.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(resultFile);
        try {
            J2EEDocumentBuilder.write(descriptor, node, out);
        }
        finally {
            out.close();
        }
    }

    public static void write(Descriptor descriptor, RootXMLNode node, OutputStream os) throws Exception {
        StreamResult output = new StreamResult(os);
        J2EEDocumentBuilder.write(descriptor, node, output);
    }

    public static void write(Descriptor descriptor, RootXMLNode node, Result output) throws Exception {
        if (node == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{descriptor, null});
            return;
        }
        try {
            Document document = J2EEDocumentBuilder.getDocument(descriptor, node);
            DOMSource source = new DOMSource(document);
            Transformer transformer = J2EEDocumentBuilder.getTransformer();
            J2EEDocumentBuilder.setTransformerProperties(node, transformer);
            transformer.transform(source, output);
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transformer getTransformer() throws Exception {
        ClassLoader currentTCL = Thread.currentThread().getContextClassLoader();
        String userTransformerFactory = System.getProperty("javax.xml.transform.TransformerFactory");
        Transformer transformer = null;
        try {
            Thread.currentThread().setContextClassLoader(J2EEDocumentBuilder.class.getClassLoader());
            if (userTransformerFactory != null) {
                System.clearProperty("javax.xml.transform.TransformerFactory");
            }
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTCL);
            if (userTransformerFactory != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", userTransformerFactory);
            }
        }
        return transformer;
    }

    private static void setTransformerProperties(RootXMLNode node, Transformer transformer) {
        if (node.getDocType() != null) {
            transformer.setOutputProperty("doctype-public", node.getDocType());
            if (node.getSystemID() != null) {
                transformer.setOutputProperty("doctype-system", node.getSystemID());
            }
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", "UTF-8");
    }

    public static String descriptorToString(Descriptor descriptor, DeploymentDescriptorFile ddFile) throws Exception {
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        if (descriptor != null) {
            J2EEDocumentBuilder.write(descriptor, ddFile.getRootXMLNode(descriptor), sr);
        }
        return sw.toString();
    }
}

