/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Node;

public class EnvEntryNode
extends DeploymentDescriptorNode {
    private boolean setValueCalled = false;

    public EnvEntryNode() {
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("env-entry-name", "setName");
        table.put("env-entry-value", "setValue");
        table.put("env-entry-type", "setType");
        table.put("mapped-name", "setMappedName");
        table.put("lookup-name", "setLookupName");
        return table;
    }

    public boolean endElement(XMLElement element) {
        if ("env-entry-name".equals(element.getQName())) {
            this.setValueCalled = false;
        } else if ("env-entry-value".equals(element.getQName())) {
            this.setValueCalled = true;
        }
        return super.endElement(element);
    }

    public void addDescriptor(Object newDescriptor) {
        if (this.setValueCalled) {
            super.addDescriptor(newDescriptor);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof EnvironmentProperty)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EnvironmentProperty envProp = (EnvironmentProperty)descriptor;
        Node envEntryNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeLocalizedDescriptions(envEntryNode, envProp);
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-name", envProp.getName());
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-type", envProp.getType());
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-value", envProp.getValue());
        EnvEntryNode.appendTextChild(envEntryNode, "mapped-name", envProp.getMappedName());
        if (envProp.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : envProp.getInjectionTargets()) {
                ijNode.writeDescriptor(envEntryNode, "injection-target", target);
            }
        }
        EnvEntryNode.appendTextChild(envEntryNode, "lookup-name", envProp.getLookupName());
        return envEntryNode;
    }
}

