/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Contract;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public abstract class ExtensionsArchivist {
    protected final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public abstract DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor var1);

    public DeploymentDescriptorFile getConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        DeploymentDescriptorFile ddFile = this.getWLSConfigurationDDFile(descriptor);
        if (ddFile == null) {
            ddFile = this.getGFConfigurationDDFile(descriptor);
        }
        if (ddFile == null) {
            ddFile = this.getSunConfigurationDDFile(descriptor);
        }
        return ddFile;
    }

    public abstract boolean supportsModuleType(ArchiveType var1);

    public abstract <T extends RootDeploymentDescriptor> T getDefaultDescriptor();

    public ModuleScanner getScanner() {
        return null;
    }

    public DeploymentDescriptorFile getWLSConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        return null;
    }

    public DeploymentDescriptorFile getGFConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        return null;
    }

    public DeploymentDescriptorFile getSunConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        return null;
    }

    public <T extends RootDeploymentDescriptor> void addExtension(RootDeploymentDescriptor root, RootDeploymentDescriptor extension) {
        root.addExtensionDescriptor(extension.getClass(), extension, null);
        extension.setModuleDescriptor(root.getModuleDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        block7: {
            DeploymentDescriptorFile confDD = this.getStandardDDFile(descriptor);
            if (archive.getURI() != null) {
                confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
            }
            InputStream is = null;
            try {
                is = archive.getEntry(confDD.getDeploymentDescriptorPath());
                if (is == null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Deployment descriptor: " + confDD.getDeploymentDescriptorPath(), " does not exist in archive: " + archive.getURI().getSchemeSpecificPart());
                    }
                    break block7;
                }
                confDD.setXMLValidation(main.getXMLValidation());
                confDD.setXMLValidationLevel(main.getXMLValidationLevel());
                RootDeploymentDescriptor rootDeploymentDescriptor = confDD.read(descriptor, is);
                return rootDeploymentDescriptor;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readRuntimeDeploymentDescriptor(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        DeploymentDescriptorFile ddFile = this.getConfigurationDDFile(descriptor);
        if (ddFile == null) {
            return descriptor;
        }
        InputStream is = null;
        InputStream gfIs = null;
        InputStream sunIs = null;
        try {
            DeploymentDescriptorFile sunConfDD;
            DeploymentDescriptorFile gfConfDD;
            DeploymentDescriptorFile confDD = this.getWLSConfigurationDDFile(descriptor);
            if (confDD != null) {
                is = archive.getEntry(confDD.getDeploymentDescriptorPath());
            }
            if ((gfConfDD = this.getGFConfigurationDDFile(descriptor)) != null) {
                gfIs = archive.getEntry(gfConfDD.getDeploymentDescriptorPath());
            }
            if ((sunConfDD = this.getSunConfigurationDDFile(descriptor)) != null) {
                sunIs = archive.getEntry(sunConfDD.getDeploymentDescriptorPath());
            }
            if (is != null && confDD != null) {
                if (gfIs != null) {
                    this.logger.log(Level.WARNING, "wls.counterpart.configdd.exists", new Object[]{gfConfDD.getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), confDD.getDeploymentDescriptorPath()});
                }
                if (sunIs != null) {
                    this.logger.log(Level.WARNING, "wls.counterpart.configdd.exists", new Object[]{sunConfDD.getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), confDD.getDeploymentDescriptorPath()});
                }
                if (archive.getURI() != null) {
                    confDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                }
                confDD.setXMLValidation(main.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(main.getRuntimeXMLValidationLevel());
                confDD.read(descriptor, is);
            } else if (gfIs != null) {
                if (sunIs != null) {
                    this.logger.log(Level.WARNING, "gf.counterpart.configdd.exists", new Object[]{sunConfDD.getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), gfConfDD.getDeploymentDescriptorPath()});
                }
                if (archive.getURI() != null) {
                    gfConfDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                }
                gfConfDD.setXMLValidation(main.getRuntimeXMLValidation());
                gfConfDD.setXMLValidationLevel(main.getRuntimeXMLValidationLevel());
                gfConfDD.read(descriptor, gfIs);
            } else if (sunIs != null && sunConfDD != null) {
                this.logger.log(Level.FINE, "sun.configdd.deprecate", new Object[]{sunConfDD.getDeploymentDescriptorPath(), archive.getURI().getSchemeSpecificPart(), gfConfDD.getDeploymentDescriptorPath()});
                if (archive.getURI() != null) {
                    sunConfDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                }
                sunConfDD.setXMLValidation(main.getRuntimeXMLValidation());
                sunConfDD.setXMLValidationLevel(main.getRuntimeXMLValidationLevel());
                sunConfDD.read(descriptor, sunIs);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            if (gfIs != null) {
                try {
                    gfIs.close();
                }
                catch (IOException ioe) {}
            }
            if (sunIs != null) {
                try {
                    sunIs.close();
                }
                catch (IOException ioe) {}
            }
        }
        return descriptor;
    }
}

