/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARBasedPersistenceHelper {
    public static boolean isComponentJar(String jarName, Set<ModuleDescriptor<BundleDescriptor>> moduleDescriptors) {
        boolean isComponentJar = false;
        for (ModuleDescriptor<BundleDescriptor> md : moduleDescriptors) {
            String archiveUri = md.getArchiveUri();
            if (!jarName.equals(archiveUri)) continue;
            isComponentJar = true;
            break;
        }
        return isComponentJar;
    }

    protected static void addLibraryAndTopLevelCandidates(ReadableArchive earArchive, Application app, boolean includeTopLevel, Map<String, ReadableArchive> probablePersistentArchives) {
        if (includeTopLevel) {
            EARTopLevelJARPURootScanner earRootScanner = new EARTopLevelJARPURootScanner(app);
            probablePersistentArchives.putAll(PersistenceArchivist.getProbablePersistenceRoots(earArchive, earRootScanner));
        }
        EARLibraryPURootScanner libPURootScannerScanner = new EARLibraryPURootScanner(app);
        probablePersistentArchives.putAll(PersistenceArchivist.getProbablePersistenceRoots(earArchive, libPURootScannerScanner));
    }

    static class EARTopLevelJARPURootScanner
    extends PersistenceArchivist.SubArchivePURootScanner {
        private final Application app;

        protected EARTopLevelJARPURootScanner(Application app) {
            this.app = app;
        }

        public String getPathOfSubArchiveToScan() {
            return "";
        }

        public boolean isProbablePuRootJar(String jarName) {
            return super.isProbablePuRootJar(jarName) && !EARBasedPersistenceHelper.isComponentJar(jarName, this.app.getModules());
        }
    }

    static class EARLibraryPURootScanner
    extends PersistenceArchivist.SubArchivePURootScanner {
        private final Application app;

        protected EARLibraryPURootScanner(Application app) {
            this.app = app;
        }

        String getPathOfSubArchiveToScan() {
            return this.app.getLibraryDirectory();
        }
    }
}

