/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ArchivistFactory
implements ContractProvider {
    @Inject
    @Optional
    ExtensionsArchivist[] extensionsArchivists;
    @Inject
    Habitat habitat;

    public Archivist getArchivist(String archiveType, ClassLoader cl) {
        Archivist result = this.getArchivist(archiveType);
        if (result != null) {
            result.setClassLoader(cl);
        }
        return result;
    }

    public Archivist getArchivist(String archiveType) {
        Archivist result = null;
        for (Inhabitant inhabitant : this.habitat.getInhabitants(ArchivistFor.class)) {
            String indexedType = (String)inhabitant.metadata().get((Object)ArchivistFor.class.getName()).get(0);
            if (!indexedType.equals(archiveType)) continue;
            result = (Archivist)inhabitant.get();
        }
        return result;
    }

    public Archivist getArchivist(ArchiveType moduleType) {
        return this.getArchivist(String.valueOf(moduleType));
    }

    public List<ExtensionsArchivist> getExtensionsArchists(ArchiveType moduleType) {
        ArrayList<ExtensionsArchivist> archivists = new ArrayList<ExtensionsArchivist>();
        for (ExtensionsArchivist ea : this.extensionsArchivists) {
            if (!ea.supportsModuleType(moduleType)) continue;
            archivists.add(ea);
        }
        return archivists;
    }
}

