/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.inject.Inject;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleScanner<T>
extends JavaEEScanner
implements Scanner<T> {
    private static final int DEFAULT_ENTRY_BUFFER_SIZE = 8192;
    @Inject
    DefaultAnnotationScanner defaultScanner;
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected Parser classParser = null;
    private Set<URI> scannedURI = new HashSet<URI>();
    private boolean needScanAnnotation = false;
    private static ExecutorService executorService = null;
    private Set<String> entries = new HashSet<String>();
    protected Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public void process(ReadableArchive archiveFile, T bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        File file = new File(archiveFile.getURI());
        this.setParser(parser);
        this.process(file, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archiveFile);
        this.calculateResults();
    }

    protected void completeProcess(T bundleDescr, ReadableArchive archive) throws IOException {
        this.addLibraryJars(bundleDescr, archive);
    }

    protected void calculateResults() {
        try {
            this.classParser.awaitTermination();
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Annotation scanning interrupted", e);
            return;
        }
        Level logLevel = System.getProperty("glassfish.deployment.dump.scanning") != null ? Level.INFO : Level.FINE;
        boolean shouldLog = this.logger.isLoggable(logLevel);
        ParsingContext context = this.classParser.getContext();
        for (String annotation : this.defaultScanner.getAnnotations()) {
            Type type = context.getTypes().getBy(annotation);
            if (type == null) continue;
            if (type instanceof AnnotationType) {
                AnnotationType at = (AnnotationType)type;
                for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                    Object t = ae instanceof Member ? ((Member)ae).getDeclaringType() : (Type)ae;
                    if (!t.wasDefinedIn(this.scannedURI)) continue;
                    if (shouldLog) {
                        this.logger.log(logLevel, "Adding " + t.getName() + " since " + ae.getName() + " is annotated with " + at.getName());
                    }
                    this.entries.add(t.getName());
                }
                continue;
            }
            if (type instanceof InterfaceModel) {
                InterfaceModel im = (InterfaceModel)type;
                for (ClassModel cm : im.allImplementations()) {
                    if (shouldLog) {
                        this.logger.log(logLevel, "Adding " + cm.getName() + " since it is implementing " + im.getName());
                    }
                    this.entries.add(cm.getName());
                }
                continue;
            }
            this.logger.log(Level.SEVERE, "Inconsistent type definition, " + annotation + " is neither an annotation nor an interface");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Done with results");
        }
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    protected void addScanJar(File jarFile) throws IOException {
        try {
            if (!jarFile.exists()) {
                return;
            }
            this.scannedURI.add(jarFile.toURI());
            if (this.needScanAnnotation) {
                this.classParser.parse(jarFile, null);
            }
        }
        catch (ZipException ze) {
            this.logger.log(Level.WARNING, ze.getMessage() + ": file path: " + jarFile.getPath());
        }
    }

    protected void addScanURI(URI jarURI) throws IOException {
        this.addScanJar(new File(jarURI));
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.scannedURI.add(directory.toURI());
        if (this.needScanAnnotation) {
            this.classParser.parse(directory, null);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String className : this.entries) {
            if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
                AnnotationUtils.getLogger().fine("Getting " + className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (NoClassDefFoundError err) {
                AnnotationUtils.getLogger().log(Level.WARNING, "Error in annotation processing: " + err);
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationUtils.getLogger().log(Level.WARNING, "Cannot load " + className + " reason : " + cnfe.getMessage(), cnfe);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) throws IOException {
        List<Object> libraryURLs = new ArrayList();
        if (bundleDesc instanceof BundleDescriptor) {
            libraryURLs = DOLUtils.getLibraryJars((BundleDescriptor)bundleDesc, moduleArchive);
        }
        for (URL url : libraryURLs) {
            try {
                File libFile = new File(url.toURI());
                if (libFile.isFile()) {
                    this.addScanJar(libFile);
                    continue;
                }
                if (!libFile.isDirectory()) continue;
                this.addScanDirectory(libFile);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    public Types getTypes() {
        return this.classParser.getContext().getTypes();
    }

    protected synchronized ExecutorService getExecutorService() {
        if (executorService != null) {
            return executorService;
        }
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        executorService = Executors.newFixedThreadPool(nrOfProcessors, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("dol-jar-scanner");
                t.setDaemon(true);
                t.setContextClassLoader(this.getClass().getClassLoader());
                return t;
            }
        });
        return executorService;
    }

    protected void setParser(Parser parser) {
        if (parser == null) {
            ParsingContext pc = new ParsingContext.Builder().logger(this.logger).executorService(this.getExecutorService()).build();
            parser = new Parser(pc);
            this.needScanAnnotation = true;
        }
        this.classParser = parser;
    }
}

