/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.factory;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.factory.Factory;
import org.glassfish.apf.impl.AnnotationProcessorImpl;
import org.glassfish.api.ContractProvider;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class SJSASFactory
extends Factory
implements ContractProvider,
PostConstruct {
    @Inject
    Habitat habitat;
    private Set<String> annotationClassNames = new HashSet<String>();
    private AnnotationProcessorImpl systemProcessor = null;

    public AnnotationProcessor getAnnotationProcessor() {
        AnnotationProcessorImpl processor = Factory.getDefaultAnnotationProcessor();
        processor.setDelegate(this.systemProcessor);
        return processor;
    }

    public Set<String> getAnnotations() {
        return (HashSet)((HashSet)this.annotationClassNames).clone();
    }

    public void postConstruct() {
        if (this.systemProcessor == null) {
            this.systemProcessor = new AnnotationProcessorImpl();
            for (final Inhabitant i : this.habitat.getInhabitants(AnnotationHandlerFor.class)) {
                String annotationTypeName = (String)i.metadata().get((Object)AnnotationHandlerFor.class.getName()).get(0);
                this.systemProcessor.pushAnnotationHandler(annotationTypeName, new AnnotationHandler(){

                    public Class<? extends Annotation> getAnnotationType() {
                        AnnotationHandler realHandler = (AnnotationHandler)i.get();
                        return realHandler.getAnnotationType();
                    }

                    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
                        AnnotationHandler realHandler = (AnnotationHandler)i.get();
                        return realHandler.processAnnotation(element);
                    }

                    public Class<? extends Annotation>[] getTypeDependencies() {
                        AnnotationHandler realHandler = (AnnotationHandler)i.get();
                        return realHandler.getTypeDependencies();
                    }
                });
                this.annotationClassNames.add("L" + annotationTypeName.replace('.', '/') + ";");
            }
        }
    }
}

