/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;

public final class MethodDescriptor
extends Descriptor {
    public static final String EJB_HOME = "Home";
    public static final String EJB_LOCALHOME = "LocalHome";
    public static final String EJB_REMOTE = "Remote";
    public static final String EJB_LOCAL = "Local";
    public static final String EJB_WEB_SERVICE = "ServiceEndpoint";
    public static final String EJB_BEAN = "Bean";
    public static final String ALL_OF_NAME = "AllOfName";
    public static final String ALL_EJB_METHODS = "*";
    public static final String ALL_METHODS = "*";
    private static final String TIMER_METHOD = "Timer";
    private static final String MESSAGE_ENDPOINT_METHOD = "MessageEndpoint";
    private String[] parameterClassNames = null;
    private String[] javaParameterClassNames = null;
    private String className = "";
    private String ejbClassSymbol;
    private String ejbName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MethodDescriptor.class);
    static final Logger _logger = DOLUtils.getDefaultLogger();
    private final int JAVA_FORMAT = 1;
    private final int XML_FORMAT = -1;
    private final int XML_JAVA_FORMAT = 0;
    private boolean isExact = false;
    private static Map javaPrimitivesTypes;

    public MethodDescriptor(String name, String description, String[] parameterClassNames, String ejbClassSymbol) {
        super(name, description);
        if (name == null) {
            super.setName("");
        }
        if (parameterClassNames != null) {
            this.convertToAppropriateFormat(parameterClassNames);
        }
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    private void convertToAppropriateFormat(String[] parameterClassNames) {
        int format = this.isJavaFormat(parameterClassNames);
        if (format == 1) {
            this.javaParameterClassNames = parameterClassNames;
            this.parameterClassNames = this.fixParamClassNames(parameterClassNames);
        } else if (format == -1) {
            this.javaParameterClassNames = this.xmlFormat2JavaClassNames(parameterClassNames);
            this.parameterClassNames = parameterClassNames;
        } else if (format == 0) {
            this.javaParameterClassNames = parameterClassNames;
            this.parameterClassNames = parameterClassNames;
        }
    }

    public MethodDescriptor(String name, String description, String ejbClassSymbol) {
        super(name, description);
        this.parameterClassNames = null;
        this.setEjbClassSymbol(ejbClassSymbol);
    }

    public MethodDescriptor(Method method, String methodIntf) {
        this(method);
        this.isExact = true;
        this.setEjbClassSymbol(methodIntf);
    }

    public MethodDescriptor(Method method) {
        super(method.getName(), "");
        Class[] paramTypes = method.getParameterTypes();
        this.parameterClassNames = this.getParameterClassNamesFor(method, paramTypes);
        this.javaParameterClassNames = this.getJavaFormatClassNamesFor(paramTypes);
        this.className = method.getDeclaringClass().getName();
    }

    public MethodDescriptor() {
    }

    public void setEmptyParameterClassNames() {
        this.parameterClassNames = new String[0];
    }

    public void addParameterClass(String parameter) {
        if (this.parameterClassNames == null) {
            this.parameterClassNames = new String[1];
        } else {
            String[] newParameterClassNames = new String[this.parameterClassNames.length + 1];
            for (int i = 0; i < this.parameterClassNames.length; ++i) {
                newParameterClassNames[i] = this.parameterClassNames[i];
            }
            this.parameterClassNames = newParameterClassNames;
        }
        this.parameterClassNames[this.parameterClassNames.length - 1] = parameter;
        this.javaParameterClassNames = this.xmlFormat2JavaClassNames(this.parameterClassNames);
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public boolean isExact() {
        if (this.isExact) {
            return true;
        }
        boolean isExactName = !this.getName().equals("*");
        boolean hasMethodIntf = this.getEjbClassSymbol() != null;
        boolean hasParamsListed = this.getParameterClassNames() != null;
        return isExactName && hasMethodIntf && hasParamsListed;
    }

    public int getStyle() {
        if (this.getName().equals("*")) {
            return 1;
        }
        if (this.getParameterClassNames() == null) {
            return 2;
        }
        return 3;
    }

    public Method getMethod(EjbDescriptor ejbDescriptor) {
        Method method;
        block41: {
            method = null;
            try {
                ClassLoader classloader = ejbDescriptor.getEjbBundleDescriptor().getClassLoader();
                String[] javaParamClassNames = this.getJavaParameterClassNames();
                if (this.ejbClassSymbol == null || this.ejbClassSymbol.equals("") || this.ejbClassSymbol.equals(EJB_BEAN) || this.ejbClassSymbol.equals(TIMER_METHOD) || this.ejbClassSymbol.equals(MESSAGE_ENDPOINT_METHOD)) {
                    try {
                        if (!this.className.equals("")) {
                            Class<?> declaringClass = classloader.loadClass(this.className);
                            return TypeUtil.getDeclaredMethod(declaringClass, classloader, this.getName(), javaParamClassNames);
                        }
                        Class<?> ejbClass = classloader.loadClass(ejbDescriptor.getEjbClassName());
                        return TypeUtil.getMethod(ejbClass, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {
                        Class<?> cl;
                        try {
                            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                                Class<?> homeClass = classloader.loadClass(ejbDescriptor.getHomeClassName());
                                return TypeUtil.getMethod(homeClass, classloader, this.getName(), javaParamClassNames);
                            }
                        }
                        catch (NoSuchMethodException nsme2) {
                            // empty catch block
                        }
                        try {
                            if (ejbDescriptor.isLocalInterfacesSupported()) {
                                cl = classloader.loadClass(ejbDescriptor.getLocalHomeClassName());
                                return TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                            }
                        }
                        catch (NoSuchMethodException nsme3) {
                            // empty catch block
                        }
                        try {
                            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                                cl = classloader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                                return TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                            }
                            break block41;
                        }
                        catch (NoSuchMethodException nsme4) {}
                        break block41;
                    }
                }
                if (this.ejbClassSymbol.equals(EJB_HOME)) {
                    try {
                        Class<?> homeClass = classloader.loadClass(ejbDescriptor.getHomeClassName());
                        method = TypeUtil.getMethod(homeClass, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                    break block41;
                }
                if (this.ejbClassSymbol.equals(EJB_LOCALHOME)) {
                    try {
                        Class<?> cl = classloader.loadClass(ejbDescriptor.getLocalHomeClassName());
                        method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {}
                    break block41;
                }
                if (this.ejbClassSymbol.equals(EJB_REMOTE)) {
                    if (ejbDescriptor.isRemoteInterfacesSupported()) {
                        try {
                            Class<?> cl = classloader.loadClass(ejbDescriptor.getRemoteClassName());
                            method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                    }
                    if (method != null || !ejbDescriptor.isRemoteBusinessInterfacesSupported()) break block41;
                    for (String intf : ejbDescriptor.getRemoteBusinessClassNames()) {
                        try {
                            Class<?> cl = classloader.loadClass(intf);
                            method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                        if (method == null) continue;
                        break block41;
                    }
                    break block41;
                }
                if (this.ejbClassSymbol.equals(EJB_LOCAL)) {
                    Class<?> cl;
                    if (ejbDescriptor.isLocalBean()) {
                        try {
                            cl = classloader.loadClass(ejbDescriptor.getEjbClassName());
                            method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                    }
                    if (method == null && ejbDescriptor.isLocalInterfacesSupported()) {
                        try {
                            cl = classloader.loadClass(ejbDescriptor.getLocalClassName());
                            method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                    }
                    if (method != null || !ejbDescriptor.isLocalBusinessInterfacesSupported()) break block41;
                    for (String intf : ejbDescriptor.getLocalBusinessClassNames()) {
                        try {
                            Class<?> cl2 = classloader.loadClass(intf);
                            method = TypeUtil.getMethod(cl2, classloader, this.getName(), javaParamClassNames);
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                        if (method == null) continue;
                        break block41;
                    }
                    break block41;
                }
                if (this.ejbClassSymbol.equals(EJB_WEB_SERVICE)) {
                    try {
                        Class<?> cl = classloader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                        method = TypeUtil.getMethod(cl, classloader, this.getName(), javaParamClassNames);
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{e.getMessage(), ejbDescriptor});
            }
        }
        return method;
    }

    public Method getMethod(Class declaringClass) {
        try {
            return TypeUtil.getMethod(declaringClass, declaringClass.getClassLoader(), this.getName(), this.getJavaParameterClassNames());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{declaringClass});
            return null;
        }
    }

    public Method getDeclaredMethod(Class declaringClass) {
        try {
            return TypeUtil.getDeclaredMethod(declaringClass, declaringClass.getClassLoader(), this.getName(), this.getJavaParameterClassNames());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{declaringClass});
            return null;
        }
    }

    public Method getDeclaredMethod(EjbDescriptor ejbDescriptor) {
        ClassLoader classloader = ejbDescriptor.getEjbBundleDescriptor().getClassLoader();
        try {
            Class[] parameterTypes = TypeUtil.paramClassNamesToTypes(this.getJavaParameterClassNames(), classloader);
            return this.getDeclaredMethod(ejbDescriptor, parameterTypes);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{ejbDescriptor});
            return null;
        }
    }

    public Method getDeclaredMethod(EjbDescriptor ejbDescriptor, Class[] javaParamClassNames) {
        try {
            ClassLoader classloader = ejbDescriptor.getEjbBundleDescriptor().getClassLoader();
            String mname = this.getName();
            for (Class<?> nextClass = classloader.loadClass(ejbDescriptor.getEjbClassName()); nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
                try {
                    return nextClass.getDeclaredMethod(mname, javaParamClassNames);
                }
                catch (NoSuchMethodException nsme) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{ejbDescriptor});
        }
        return null;
    }

    public Vector doStyleConversion(EjbDescriptor ejbDescriptor, Collection allMethods) {
        Vector<MethodDescriptor> v = new Vector<MethodDescriptor>();
        if (this.getStyle() == 1) {
            for (MethodDescriptor next : allMethods) {
                if (this.getEjbName() != null && this.getEjbName().length() > 0) {
                    next.setEjbName(ejbDescriptor.getName());
                }
                if (!next.isExact()) {
                    // empty if block
                }
                if (this.getDescription() != null && this.getDescription().length() > 0) {
                    next.setDescription(this.getDescription());
                }
                if (this.getEjbClassSymbol() == null) {
                    v.addElement(next);
                    continue;
                }
                if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
                v.addElement(next);
            }
        } else if (this.getParameterClassNames() == null) {
            v.addAll(this.getMethodDescriptorsOfName(this.getName(), allMethods));
        } else if (this.getEjbClassSymbol() == null) {
            v.addAll(this.getMethodDescriptorsOfNameAndParameters(this.getName(), this.getParameterClassNames(), allMethods));
        } else {
            v.addElement(this);
        }
        return v;
    }

    private Set getMethodDescriptorsOfNameAndParameters(String name, String[] parameterArray, Collection methodDescriptors) {
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        for (MethodDescriptor next : this.getMethodDescriptorsOfName(name, methodDescriptors)) {
            next.setEjbName(this.getEjbName());
            if (!this.stringArrayEquals(parameterArray, next.getParameterClassNames())) continue;
            methods.add(next);
        }
        return methods;
    }

    private Set getMethodDescriptorsOfName(String name, Collection methodDescriptors) {
        HashSet<MethodDescriptor> set = new HashSet<MethodDescriptor>();
        for (MethodDescriptor next : methodDescriptors) {
            next.setEjbName(this.getEjbName());
            if (!name.equals(next.getName())) continue;
            if (this.getEjbClassSymbol() == null) {
                set.add(next);
                continue;
            }
            if (!this.getEjbClassSymbol().equals(next.getEjbClassSymbol())) continue;
            set.add(next);
        }
        return set;
    }

    public String getEjbClassSymbol() {
        return this.ejbClassSymbol;
    }

    public void setEjbClassSymbol(String ejbClassSymbol) {
        this.ejbClassSymbol = ejbClassSymbol;
    }

    public String getFormattedString() {
        return this.getName() + this.getPrettyParameterString();
    }

    public String getPrettyParameterString() {
        StringBuilder prettyParameterString = new StringBuilder("(");
        if (this.parameterClassNames != null) {
            for (int i = 0; i < this.parameterClassNames.length; ++i) {
                int j = i + 1;
                if (i > 0) {
                    prettyParameterString.append(", ").append(this.parameterClassNames[i]).append(" p").append(j);
                    continue;
                }
                prettyParameterString.append(this.parameterClassNames[i]).append(" p").append(j);
            }
        }
        prettyParameterString.append(")");
        return prettyParameterString.toString();
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    public String[] getJavaParameterClassNames() {
        return this.javaParameterClassNames;
    }

    private boolean stringArrayEquals(String[] s1, String[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s2 == null && s1 != null) {
            return false;
        }
        if (s1.length == s2.length) {
            for (int i = 0; i < s1.length; ++i) {
                if (s1[i].equals(s2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        MethodDescriptor otherMethodDescriptor;
        if (other instanceof MethodDescriptor && (otherMethodDescriptor = (MethodDescriptor)((Object)other)).getName().equals(this.getName()) && this.stringArrayEquals(otherMethodDescriptor.getParameterClassNames(), this.getParameterClassNames())) {
            if (this.getEjbClassSymbol() != null && otherMethodDescriptor.getEjbClassSymbol() != null) {
                return this.getEjbClassSymbol().equals(otherMethodDescriptor.getEjbClassSymbol());
            }
            return true;
        }
        return false;
    }

    public boolean implies(Object other) {
        if (other != null && other instanceof MethodDescriptor) {
            MethodDescriptor otherMethodDescriptor = (MethodDescriptor)((Object)other);
            if ((this.getName().equals("*") || this.getName().equals(otherMethodDescriptor.getName())) && (this.getParameterClassNames() == null || this.stringArrayEquals(this.getParameterClassNames(), otherMethodDescriptor.getParameterClassNames()))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getPrettyParameterString().hashCode() + this.getName().hashCode();
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Method Descriptor").append(this.ejbName == null ? "" : " for ejb " + this.ejbName).append(" name: ").append(this.getName()).append(" params: ").append(this.getPrettyParameterString()).append(" intf: ").append(this.ejbClassSymbol);
    }

    public String prettyPrint() {
        return "Name : " + this.getName() + " Params: " + this.getPrettyParameterString() + " Intf: " + this.ejbClassSymbol;
    }

    public String[] getParameterClassNamesFor(Method method, Class[] paramTypes) {
        String[] classNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> compType = paramTypes[i].getComponentType();
            if (compType == null) {
                classNames[i] = paramTypes[i].getName();
                continue;
            }
            int dimensions = 1;
            while (compType.getComponentType() != null) {
                ++dimensions;
                compType = compType.getComponentType();
            }
            classNames[i] = compType.getName();
            for (int j = 0; j < dimensions; ++j) {
                int n = i;
                classNames[n] = classNames[n] + "[]";
            }
        }
        return classNames;
    }

    private int isJavaFormat(String[] params) {
        int ret = 0;
        for (int i = 0; i < params.length; ++i) {
            int index = params[i].indexOf(91);
            if (index != -1) {
                if (index == 0) {
                    return 1;
                }
                return -1;
            }
            ret = 0;
        }
        return ret;
    }

    private String[] getJavaFormatClassNamesFor(Class[] paramTypes) {
        String[] classNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            classNames[i] = paramTypes[i].getName();
        }
        return classNames;
    }

    private String[] fixParamClassNames(String[] paramClassNames) {
        if (paramClassNames == null) {
            return null;
        }
        String[] newParams = new String[paramClassNames.length];
        for (int i = 0; i < paramClassNames.length; ++i) {
            newParams[i] = MethodDescriptor.fixParamClassName(paramClassNames[i]);
        }
        return newParams;
    }

    private String[] xmlFormat2JavaClassNames(String[] from) {
        String[] to = new String[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = MethodDescriptor.xmlFormat2JavaClassNames(from[i]);
        }
        return to;
    }

    public static String xmlFormat2JavaClassNames(String param) {
        int indexOfArray = param.indexOf(91);
        if (indexOfArray == -1) {
            return param;
        }
        String buf = param.substring(0, indexOfArray);
        int lastIndexOf = param.lastIndexOf(93);
        int dimension = lastIndexOf - indexOfArray + 1;
        dimension /= 2;
        StringBuffer fs = new StringBuffer();
        for (int i = 0; i < dimension; ++i) {
            fs.append("[");
        }
        String javaPrimitiveType = (String)MethodDescriptor.getJavaPrimitiveTypes().get(buf);
        if (javaPrimitiveType != null) {
            fs.append(javaPrimitiveType);
        } else {
            fs.append("L");
            fs.append(buf);
            fs.append(";");
        }
        return fs.toString();
    }

    public static synchronized Map getJavaPrimitiveTypes() {
        if (javaPrimitivesTypes == null) {
            javaPrimitivesTypes = new Hashtable();
            javaPrimitivesTypes.put("char", "C");
            javaPrimitivesTypes.put("byte", "B");
            javaPrimitivesTypes.put("double", "D");
            javaPrimitivesTypes.put("float", "F");
            javaPrimitivesTypes.put("int", "I");
            javaPrimitivesTypes.put("long", "J");
            javaPrimitivesTypes.put("short", "S");
            javaPrimitivesTypes.put("boolean", "Z");
        }
        return javaPrimitivesTypes;
    }

    public static String fixParamClassName(String param) {
        if (param.charAt(0) == '[') {
            int dimensions = param.lastIndexOf(91) + 1;
            char code = param.charAt(dimensions);
            String newparam = null;
            switch (code) {
                case 'B': {
                    newparam = "byte";
                    break;
                }
                case 'C': {
                    newparam = "char";
                    break;
                }
                case 'D': {
                    newparam = "double";
                    break;
                }
                case 'F': {
                    newparam = "float";
                    break;
                }
                case 'I': {
                    newparam = "int";
                    break;
                }
                case 'J': {
                    newparam = "long";
                    break;
                }
                case 'S': {
                    newparam = "short";
                    break;
                }
                case 'Z': {
                    newparam = "boolean";
                    break;
                }
                case 'L': {
                    newparam = param.substring(dimensions + 1);
                }
            }
            for (int j = 0; j < dimensions; ++j) {
                newparam = newparam + "[]";
            }
            return newparam;
        }
        return param;
    }
}

