/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="file")
@PerLookup
public class FileArchive
extends AbstractReadableArchive
implements WritableArchive {
    private static final Level DEBUG_LEVEL = Level.FINE;
    @Inject
    ArchiveFactory archiveFactory;
    File archive = null;
    URI uri = null;
    OutputStream os = null;
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Attempt to list files in {0} failed, perhaps because that is not a valid directory or because file permissions do not allow GlassFish to access it", level="WARNING")
    private static final String FILE_LIST_FAILURE = "NCLS-DEPLOYMENT-00022";
    @LogMessageInfo(message="Ignoring {0} because the containing archive {1} recorded it as a pre-existing stale file", level="WARNING")
    private static final String STALE_FILES_SKIPPED = "NCLS-DEPLOYMENT-00023";
    private StaleFileManager staleFileManager;
    private boolean isOpenedOrCreated = false;

    public void open(URI uri) throws IOException {
        if (!uri.getScheme().equals("file")) {
            throw new IOException("Wrong scheme for FileArchive : " + uri.getScheme());
        }
        this.uri = uri;
        this.archive = new File(uri);
        if (!this.archive.exists()) {
            throw new FileNotFoundException(uri.getSchemeSpecificPart());
        }
        this.isOpenedOrCreated = true;
        this.staleFileManager = StaleFileManager.Util.getInstance(this.archive);
    }

    public void open(String uri) throws IOException {
        this.open(URI.create(uri));
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        File tmpFile = new File(this.uri);
        return tmpFile.length();
    }

    public void create(URI uri) throws IOException {
        this.uri = uri;
        this.archive = new File(uri);
        this.staleFileManager = StaleFileManager.Util.getInstance(this.archive);
        if (!this.archive.exists() && !this.archive.mkdirs()) {
            throw new IOException("Unable to create directory for " + this.archive.getAbsolutePath());
        }
        this.isOpenedOrCreated = true;
    }

    public void closeEntry(WritableArchive subArchive) throws IOException {
        subArchive.close();
    }

    public void close() throws IOException {
    }

    public boolean delete() {
        try {
            boolean result = this.deleteDir(this.archive);
            StaleFileManager.Util.markDeletedArchive((Archive)this);
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDirectory(String name) {
        File candidate = new File(this.archive, name);
        return this.isEntryValid(candidate) && candidate.isDirectory();
    }

    public Enumeration entries() {
        ArrayList<String> namesList = new ArrayList<String>();
        this.getListOfFiles(this.archive, namesList, null);
        return Collections.enumeration(namesList);
    }

    public Collection<String> getDirectories() throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        if (this.archive != null) {
            for (File f : this.archive.listFiles()) {
                if (!f.isDirectory() || !this.isEntryValid(f)) continue;
                results.add(f.getName());
            }
        }
        return results;
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> massagedNames = new ArrayList<String>();
        while (embeddedArchives.hasMoreElements()) {
            String subArchiveName = (String)embeddedArchives.nextElement();
            massagedNames.add(FileUtils.makeFriendlyFilenameExtension((String)subArchiveName));
        }
        this.getListOfFiles(this.archive, nameList, massagedNames);
        return Collections.enumeration(nameList);
    }

    public Enumeration<String> entries(String prefix) {
        prefix = prefix.replace('/', File.separatorChar);
        File file = new File(this.archive, prefix);
        ArrayList<String> namesList = new ArrayList<String>();
        this.getListOfFiles(file, namesList, null);
        return Collections.enumeration(namesList);
    }

    public boolean exists() {
        if (this.archive != null) {
            return this.archive.exists();
        }
        return false;
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        String subEntryName = this.getFileSubArchivePath(name);
        File subEntry = new File(subEntryName);
        if (subEntry.exists() && this.isEntryValid(subEntry)) {
            deplLogger.log(DEBUG_LEVEL, "FileArchive.getSubArchive for {0} found that it is valid", subEntry.getAbsolutePath());
            ReadableArchive result = this.archiveFactory.openArchive(subEntry);
            if (result instanceof AbstractReadableArchive) {
                ((AbstractReadableArchive)result).setParentArchive(this);
            }
            return result;
        }
        if (subEntry.exists()) {
            deplLogger.log(DEBUG_LEVEL, "FileArchive.getSubArchive for {0} found that it is not a valid entry; it is stale", subEntry.getAbsolutePath());
        }
        return null;
    }

    public WritableArchive createSubArchive(String name) throws IOException {
        String subEntryName = this.getFileSubArchivePath(name);
        File subEntry = new File(subEntryName);
        if (!subEntry.exists()) {
            if (!subEntry.exists() && !subEntry.mkdirs()) {
                throw new IOException("Unable to create directory for " + subEntry.getAbsolutePath());
            }
            deplLogger.log(DEBUG_LEVEL, "FileArchive.createSubArchive created dirs for {0}", subEntry.getAbsolutePath());
        } else {
            deplLogger.log(DEBUG_LEVEL, "FileArchive.createSubArchive found existing dir for {0}", subEntry.getAbsolutePath());
            this.staleFileManager().recordValidEntry(subEntry);
        }
        WritableArchive result = this.archiveFactory.createArchive(subEntry);
        if (result instanceof AbstractReadableArchive) {
            ((AbstractReadableArchive)result).setParentArchive(this);
        }
        return result;
    }

    private String getFileSubArchivePath(String name) throws IOException {
        File subDir;
        File file = new File(name = name.replace('/', File.separatorChar));
        if (file.isAbsolute()) {
            subDir = file;
        } else {
            subDir = new File(this.archive, FileUtils.makeFriendlyFilenameExtension((String)name));
            if (!subDir.exists() && !(subDir = new File(this.archive, name)).exists()) {
                subDir = new File(this.archive, FileUtils.makeFriendlyFilenameExtension((String)name));
            }
        }
        return subDir.getPath();
    }

    public boolean exists(String name) throws IOException {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        return input.exists() && this.isEntryValid(input);
    }

    public InputStream getEntry(String name) throws IOException {
        File input = this.getEntryFile(name);
        if (!input.exists() || input.isDirectory() || !this.isEntryValid(input)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(input);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            return bis;
        }
        catch (Throwable tx) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable thr) {
                    throw new IOException("Error closing FileInputStream after error opening BufferedInputStream for entry " + name, thr);
                }
            }
            throw new IOException("Error opening BufferedInputStream for entry " + name, tx);
        }
    }

    private File getEntryFile(String name) {
        name = name.replace('/', File.separatorChar);
        return new File(this.archive, name);
    }

    public long getEntrySize(String name) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists() || !this.isEntryValid(input)) {
            return 0L;
        }
        return input.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        try (InputStream is = null;){
            is = this.getEntry("META-INF/MANIFEST.MF");
            if (is != null) {
                Manifest m;
                Manifest manifest = m = new Manifest(is);
                return manifest;
            }
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean renameTo(String name) {
        return FileUtils.renameFile((File)this.archive, (File)new File(name));
    }

    private boolean isEntryValid(File entry) {
        return this.isEntryValid(entry, true, deplLogger);
    }

    private boolean isEntryValid(File entry, boolean isLogging) {
        return this.isEntryValid(entry, isLogging, deplLogger);
    }

    private boolean isEntryValid(File entry, boolean isLogging, Logger logger) {
        return this.staleFileManager().isEntryValid(entry, isLogging, logger);
    }

    private StaleFileManager myStaleFileManager() {
        if (!this.isOpenedOrCreated) {
            throw new IllegalStateException();
        }
        return this.staleFileManager;
    }

    private StaleFileManager staleFileManager() {
        ReadableArchive parent = this.getParentArchive();
        if (parent == null) {
            return this.myStaleFileManager();
        }
        if (parent instanceof FileArchive) {
            return ((FileArchive)parent).staleFileManager();
        }
        return null;
    }

    private boolean isEntryValid(String entryName, Logger logger) {
        return this.isEntryValid(this.getEntryFile(entryName), true, logger);
    }

    private boolean deleteDir(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(directory.getPath());
        }
        boolean allDeletesSucceeded = true;
        if (!Files.isSymbolicLink(directory.toPath())) {
            File[] entries = directory.listFiles();
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].isDirectory()) {
                    allDeletesSucceeded &= this.deleteDir(entries[i]);
                    continue;
                }
                if (entries[i].equals(StaleFileManager.Util.markerFile(this.archive))) continue;
                boolean fileDeleteOK = FileUtils.deleteFileWithWaitLoop((File)entries[i]);
                if (fileDeleteOK) {
                    this.myStaleFileManager().recordDeletedEntry(entries[i]);
                }
                allDeletesSucceeded &= fileDeleteOK;
            }
        }
        return allDeletesSucceeded && FileUtils.deleteFileWithWaitLoop((File)directory);
    }

    private void getListOfFiles(File directory, List<String> files, List embeddedArchives) {
        this.getListOfFiles(directory, files, embeddedArchives, deplLogger);
    }

    void getListOfFiles(File directory, List<String> files, List embeddedArchives, Logger logger) {
        if (this.archive == null || directory == null || !directory.isDirectory()) {
            return;
        }
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            deplLogger.log(Level.WARNING, FILE_LIST_FAILURE, directory.getAbsolutePath());
            return;
        }
        for (File aList : fileList) {
            String fileName = aList.getAbsolutePath().substring(this.archive.getAbsolutePath().length() + 1);
            fileName = fileName.replace(File.separatorChar, '/');
            if (!aList.isDirectory()) {
                if (fileName.equals("META-INF/MANIFEST.MF") || !this.isEntryValid(fileName, logger)) continue;
                files.add(fileName);
                continue;
            }
            if (!this.isEntryValid(fileName, logger)) continue;
            files.add(fileName);
            if (embeddedArchives != null) {
                if (embeddedArchives.contains(fileName)) continue;
                this.getListOfFiles(aList, files, null, logger);
                continue;
            }
            this.getListOfFiles(aList, files, null, logger);
        }
    }

    public boolean supportsElementsOverwriting() {
        return true;
    }

    public boolean deleteEntry(String name) {
        return this.deleteEntry(name, true);
    }

    private boolean deleteEntry(String name, boolean isLogging) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists() || !this.isEntryValid(input, isLogging)) {
            return false;
        }
        boolean result = input.delete();
        this.myStaleFileManager().recordDeletedEntry(input);
        return result;
    }

    public void closeEntry() throws IOException {
        if (this.os != null) {
            this.os.flush();
            this.os.close();
            this.os = null;
        }
    }

    public OutputStream putNextEntry(String name) throws IOException {
        String dirs;
        File dirsFile;
        File newFile = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (newFile.exists() && !this.deleteEntry(name, false) && this.uri != null) {
            deplLogger.log(Level.FINE, "Could not delete file {0} in FileArchive {1} during putNextEntry; continuing", new Object[]{name, this.uri.toASCIIString()});
        }
        if (name.lastIndexOf(File.separatorChar) != -1 && !(dirsFile = new File(this.archive, dirs = name.substring(0, name.lastIndexOf(File.separatorChar)))).exists() && !dirsFile.mkdirs()) {
            throw new IOException("Unable to create directory for " + dirsFile.getAbsolutePath());
        }
        this.staleFileManager().recordValidEntry(newFile);
        this.os = new BufferedOutputStream(new FileOutputStream(newFile));
        return this.os;
    }

    public String getName() {
        return Util.getURIName(this.getURI());
    }

    private static class StaleFileManagerImpl
    implements StaleFileManager {
        private static final String LINE_SEP = System.getProperty("line.separator");
        private final File archiveFile;
        private final URI archiveURI;
        private final Collection<String> staleEntryNames;
        private final File markerFile;

        private StaleFileManagerImpl(File archive) throws FileNotFoundException, IOException {
            this.archiveFile = archive;
            this.archiveURI = archive.toURI();
            this.markerFile = StaleFileManager.Util.markerFile(archive);
            this.staleEntryNames = StaleFileManagerImpl.readStaleEntryNames(this.markerFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Collection<String> readStaleEntryNames(File markerFile) throws FileNotFoundException, IOException {
            ArrayList<String> result = new ArrayList<String>();
            if (!markerFile.exists()) {
                return result;
            }
            try (BufferedReader reader = null;){
                String line;
                StringBuffer entriesToSkip;
                reader = new LineNumberReader(new FileReader(markerFile));
                boolean isShowEntriesToBeSkipped = deplLogger.isLoggable(DEBUG_LEVEL);
                StringBuffer stringBuffer = entriesToSkip = isShowEntriesToBeSkipped ? new StringBuffer() : null;
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    result.add(line);
                    if (!isShowEntriesToBeSkipped) continue;
                    entriesToSkip.append(line).append(LINE_SEP);
                }
                if (isShowEntriesToBeSkipped) {
                    deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager will skip following file(s): {0}{1}", new Object[]{LINE_SEP, entriesToSkip.toString()});
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging) {
            return this.isEntryValid(f, isLogging, deplLogger);
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging, Logger logger) {
            boolean result;
            boolean bl = result = !this.isEntryMarkerFile(f) && !this.staleEntryNames.contains(this.archiveURI.relativize(f.toURI()).getPath());
            if (!result && !this.isEntryMarkerFile(f) && isLogging) {
                deplLogger.log(Level.WARNING, FileArchive.STALE_FILES_SKIPPED, new Object[]{this.archiveURI.relativize(f.toURI()).toASCIIString(), this.archiveFile.getAbsolutePath()});
            }
            return result;
        }

        @Override
        public boolean isEntryMarkerFile(File f) {
            return this.markerFile.equals(f);
        }

        @Override
        public void recordValidEntry(File f) {
            if (this.updateStaleEntry(f, "FileArchive.StaleFileManager marking formerly stale entry {0} as active")) {
                do {
                    f = f.getParentFile();
                    this.updateStaleEntry(f, "FileArchive.StaleFileManager marking formerly stale ancestor {0} as active");
                } while (!f.equals(this.archiveFile));
                this.flush();
            }
        }

        @Override
        public void recordDeletedEntry(File f) {
            if (this.updateStaleEntry(f, "FileArchive.StaleFileManager recording deletion of entry {0}")) {
                do {
                    if (this.isStaleEntryInDir(f.getParentFile())) {
                        return;
                    }
                    this.updateStaleEntry(f, "FileArchive.StaleFileManager recording that formerly stale directory {0} is no longer stale");
                } while (!(f = f.getParentFile()).equals(this.archiveFile));
                this.flush();
            }
        }

        private boolean isStaleEntryInDir(File dir) {
            String dirURIPath = this.archiveURI.relativize(dir.toURI()).getPath();
            for (String staleEntryName : this.staleEntryNames) {
                if (!staleEntryName.startsWith(dirURIPath) || staleEntryName.equals(dirURIPath)) continue;
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.isStaleEntryInDir found remaining stale entry {0} in {1}", new Object[]{staleEntryName, dir.getAbsolutePath()});
                return true;
            }
            return false;
        }

        private boolean updateStaleEntry(File f, String msg) {
            if (this.staleEntryNames.isEmpty()) {
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.updateStaleEntry finds staleEntryNames is empty; skipping");
                return false;
            }
            String entryName = this.archiveURI.relativize(f.toURI()).toASCIIString();
            boolean wasStale = this.staleEntryNames.remove(entryName);
            if (wasStale) {
                deplLogger.log(DEBUG_LEVEL, msg, entryName);
            } else {
                deplLogger.log(DEBUG_LEVEL, "updateStaleEntry did not find {0} in the stale entries {1}", new Object[]{entryName, this.staleEntryNames.toString()});
            }
            return wasStale;
        }

        @Override
        public void flush() {
            if (this.staleEntryNames.isEmpty()) {
                deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.flush deleting marker file; no more stale entries");
                File marker = StaleFileManager.Util.markerFile(this.archiveFile);
                if (!marker.exists() || marker.delete()) {
                    return;
                }
                deplLogger.log(Level.FINE, "FileArchive.StatleFileManager.flush could not delete marker file {0}; continuing by writing out an empty marker file", marker.getAbsolutePath());
            }
            PrintStream ps = null;
            try {
                ps = new PrintStream(StaleFileManager.Util.markerFile(this.archiveFile));
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            for (String staleEntryName : this.staleEntryNames) {
                ps.println(staleEntryName);
            }
            ps.close();
            deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager.flush rewrote on-disk file {0} containing {1}", new Object[]{this.markerFile.getAbsolutePath(), this.staleEntryNames.toString()});
        }
    }

    private static class StaleFileManagerImplNoop
    implements StaleFileManager {
        private StaleFileManagerImplNoop() {
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging) {
            return true;
        }

        @Override
        public boolean isEntryValid(File f, boolean isLogging, Logger logger) {
            return true;
        }

        @Override
        public boolean isEntryMarkerFile(File f) {
            return false;
        }

        @Override
        public void recordValidEntry(File f) {
        }

        @Override
        public void recordDeletedEntry(File f) {
        }

        @Override
        public void flush() {
        }
    }

    public static interface StaleFileManager {
        public boolean isEntryValid(File var1, boolean var2);

        public boolean isEntryValid(File var1, boolean var2, Logger var3);

        public boolean isEntryMarkerFile(File var1);

        public void recordValidEntry(File var1);

        public void recordDeletedEntry(File var1);

        public void flush();

        public static class Util {
            private static final String MARKER_FILE_PATH = ".glassfishStaleFiles";

            private static File markerFile(File archive) {
                return new File(archive, MARKER_FILE_PATH);
            }

            public static void markDeletedArchive(Archive archive) {
                if (!(archive instanceof FileArchive)) {
                    return;
                }
                File archiveFile = new File(archive.getURI());
                Util.markDeletedArchive(archiveFile);
            }

            public static void markDeletedArchive(File archiveFile) {
                if (!archiveFile.exists()) {
                    return;
                }
                Iterator<File> staleFileIt = Util.findFiles(archiveFile);
                if (!staleFileIt.hasNext()) {
                    return;
                }
                URI archiveURI = archiveFile.toURI();
                PrintStream ps = null;
                try {
                    ps = new PrintStream(Util.markerFile(archiveFile));
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                while (staleFileIt.hasNext()) {
                    URI relativeURI = archiveURI.relativize(staleFileIt.next().toURI());
                    ps.println(relativeURI);
                    deplLogger.log(DEBUG_LEVEL, "FileArchive.StaleFileManager recording left-over file {0}", relativeURI);
                }
                ps.close();
            }

            private static Iterator<File> findFiles(final File dir) {
                return new Iterator<File>(){
                    private final List<File> fileList;
                    private final ListIterator<File> fileListIt;
                    {
                        this.fileList = new ArrayList<File>(Arrays.asList(dir.listFiles(new MarkerExcluderFileFilter())));
                        this.fileListIt = this.fileList.listIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fileListIt.hasNext();
                    }

                    @Override
                    public File next() {
                        File result = this.fileListIt.next();
                        if (result.isDirectory()) {
                            for (File f : result.listFiles(new MarkerExcluderFileFilter())) {
                                this.fileListIt.add(f);
                                this.fileListIt.previous();
                            }
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public static StaleFileManager getInstance(File archive) throws IOException {
                if (archive.exists()) {
                    return new StaleFileManagerImpl(archive);
                }
                return new StaleFileManagerImplNoop();
            }

            private static final class MarkerExcluderFileFilter
            implements FileFilter {
                private MarkerExcluderFileFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return !pathname.getName().equals(Util.MARKER_FILE_PATH);
                }
            }
        }
    }
}

