/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.ReadableArchiveFactory;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ArchiveFactory
implements ContractProvider {
    @Inject
    Habitat habitat;
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public WritableArchive createArchive(File path) throws IOException {
        try {
            return this.createArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public WritableArchive createArchive(String protocol, File path) throws IOException {
        try {
            return this.createArchive(protocol, ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ReadableArchive openArchive(File path) throws IOException {
        try {
            return this.openArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public WritableArchive createArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        return this.createArchive(protocol, path);
    }

    public WritableArchive createArchive(String protocol, URI path) throws IOException {
        try {
            WritableArchive archive = (WritableArchive)this.habitat.getComponent(WritableArchive.class, protocol);
            if (archive == null) {
                logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol);
                throw new MalformedURLException("Protocol not supported : " + protocol);
            }
            archive.create(path);
            return archive;
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol, e);
            throw new MalformedURLException("Protocol not supported : " + protocol);
        }
    }

    public ReadableArchive openArchive(File path, DeployCommandParameters properties) throws IOException {
        URI uri;
        try {
            uri = ArchiveFactory.prepareArchiveURI(path);
        }
        catch (URISyntaxException e) {
            return null;
        }
        for (ReadableArchiveFactory fac : this.habitat.getAllByContract(ReadableArchiveFactory.class)) {
            ReadableArchive archive = null;
            try {
                archive = fac.open(uri, properties);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (archive == null) continue;
            return archive;
        }
        return this.openArchive(path);
    }

    public ReadableArchive openArchive(URI path) throws IOException {
        String provider = path.getScheme();
        if (provider.equals("file")) {
            File f = new File(path);
            if (!f.exists()) {
                throw new FileNotFoundException(f.getPath());
            }
            if (f.isFile()) {
                provider = "jar";
            }
        }
        try {
            ReadableArchive archive = (ReadableArchive)this.habitat.getComponent(ReadableArchive.class, provider);
            if (archive == null) {
                logger.log(Level.SEVERE, "Cannot find an archive implementation for " + provider);
                throw new MalformedURLException("Protocol not supported : " + provider);
            }
            archive.open(path);
            return archive;
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot find an archive implementation for " + provider, e);
            throw new MalformedURLException("Protocol not supported : " + provider);
        }
    }

    static URI prepareArchiveURI(File path) throws URISyntaxException, UnsupportedEncodingException, IOException {
        URI archiveURI = path.toURI();
        URI answer = new URI(archiveURI.getScheme(), null, archiveURI.getPath(), null, null);
        return answer;
    }
}

