/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.deployment.autodeploy.AutoDeployConstants;
import org.glassfish.deployment.autodeploy.AutoDeployedFilesManager;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.DirectoryScanner;

public class AutoDeployDirectoryScanner
implements DirectoryScanner {
    public static final Logger deplLogger = AutoDeployer.deplLogger;
    private static final String EXCEPTION_OCCURRED = "NCLS-DEPLOYMENT-00040";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutoDeployDirectoryScanner.class);

    @Override
    public void deployedEntity(File autodeployDir, File deployedEntity) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.setDeployedFileInfo(deployedEntity);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    @Override
    public void undeployedEntity(File autodeployDir, File undeployedEntity) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.deleteDeployedFileInfo(undeployedEntity);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    @Override
    public boolean hasNewDeployableEntity(File autodeployDir) {
        boolean newFilesExist = false;
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            if (adfm.getFilesForDeployment(this.getListOfFiles(autodeployDir)).length > 0) {
                newFilesExist = true;
            }
        }
        catch (Exception e) {
            this.printException(e);
            return false;
        }
        return newFilesExist;
    }

    @Override
    public File[] getAllFilesForUndeployment(File autodeployDir, boolean includeSubdir) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            return adfm.getFilesForUndeployment(this.getListOfFiles(autodeployDir, includeSubdir));
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
    }

    @Override
    public File[] getAllDeployableModules(File autodeployDir, boolean includeSubDir) {
        AutoDeployedFilesManager adfm = null;
        try {
            adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
        return adfm.getFilesForDeployment(this.getListOfFiles(autodeployDir, includeSubDir));
    }

    protected void printException(Exception e) {
        LogRecord lr = new LogRecord(Level.SEVERE, EXCEPTION_OCCURRED);
        Object[] args = new Object[]{e.getMessage()};
        lr.setParameters(args);
        lr.setThrown(e);
        deplLogger.log(lr);
    }

    protected File[] getListOfFiles(File dir) {
        return this.getListOfFiles(dir, false);
    }

    protected File[] getListOfFiles(File dir, boolean includeSubDir) {
        Set<File> fileSet = AutoDeployDirectoryScanner.getListOfFilesAsSet(dir, includeSubDir);
        return fileSet.toArray(new File[fileSet.size()]);
    }

    static Set<File> getListOfFilesAsSet(File dir, boolean includeSubDir) {
        File[] dirFiles;
        HashSet<File> result = new HashSet<File>();
        for (File dirFile : dirFiles = dir.listFiles()) {
            String name = dirFile.getName();
            String fileType = name.substring(name.lastIndexOf(".") + 1);
            if (!dirFile.isDirectory()) {
                if (fileType == null || fileType.equals("") || AutoDeployDirectoryScanner.typeIsMarkerType(fileType)) continue;
                result.add(dirFile);
                continue;
            }
            if (dirFile.getName().equals(".autodeploystatus")) continue;
            if (includeSubDir) {
                result.addAll(AutoDeployDirectoryScanner.getListOfFilesAsSet(dirFile, true));
                continue;
            }
            result.add(dirFile);
        }
        return result;
    }

    private static boolean typeIsMarkerType(String fileType) {
        for (String markerSuffix : AutoDeployConstants.MARKER_FILE_SUFFIXES) {
            if (!fileType.endsWith(markerSuffix)) continue;
            return true;
        }
        return false;
    }
}

