/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service(name="_postundeploy")
@Supplemental(value="undeploy", ifFailure=FailurePolicy.Warn, on=Supplemental.Timing.AfterReplication)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class PostUndeployCommand
extends UndeployCommandParameters
implements AdminCommand {
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        Logger logger = context.getLogger();
        logger.log(Level.INFO, "PostUndeployCommand starting");
        try {
            ActionReport report = context.getActionReport();
            DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
            if (suppInfo == null) {
                return;
            }
            ExtendedDeploymentContext dc = suppInfo.deploymentContext();
            InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, (DeploymentContext)dc);
            try {
                notifier.ensureAfterReported(ExtendedDeploymentContext.Phase.REPLICATION);
                logger.log(Level.INFO, "PostUndeployCommand done successfully");
            }
            catch (Exception e) {
                report.failure(logger, e.getMessage());
                logger.log(Level.SEVERE, "Error in inner PostUndeployCommand", e);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in outer PostUndeployCommand", e);
        }
    }
}

