/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
@Scoped(value=PerLookup.class)
public class PostStateCommand
implements AdminCommand {
    @Inject
    protected Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        try {
            logger.log(Level.INFO, "PostState starting: " + this.getClass().getName());
            DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
            ExtendedDeploymentContext dc = suppInfo.deploymentContext();
            InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, (DeploymentContext)dc);
            try {
                notifier.ensureAfterReported(ExtendedDeploymentContext.Phase.REPLICATION);
                logger.log(Level.INFO, "PostStateCommand: " + this.getClass().getName() + " finished successfully");
            }
            catch (Exception e) {
                report.failure(logger, e.getMessage());
                logger.log(Level.SEVERE, "Error during inner PostState: " + this.getClass().getName(), e);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error duirng outer PostState: " + this.getClass().getName(), e);
        }
    }
}

