/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.concurrent.ContextService;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.InvocationContext;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.internal.deployment.Deployment;

public class ContextSetupProviderImpl
implements ContextSetupProvider {
    private transient InvocationManager invocationManager;
    private transient Deployment deployment;
    private transient Applications applications;
    private transient JavaEETransactionManager transactionManager;
    private static final Logger logger = LogFacade.getLogger();
    static final long serialVersionUID = -1095988075917755802L;
    private boolean classloading;
    private boolean security;
    private boolean naming;
    private boolean workArea;

    public ContextSetupProviderImpl(InvocationManager invocationManager, Deployment deployment, Applications applications, JavaEETransactionManager transactionManager, CONTEXT_TYPE ... contextTypes) {
        this.invocationManager = invocationManager;
        this.deployment = deployment;
        this.applications = applications;
        this.transactionManager = transactionManager;
        block6: for (CONTEXT_TYPE contextType : contextTypes) {
            switch (contextType) {
                case CLASSLOADING: {
                    this.classloading = true;
                    continue block6;
                }
                case SECURITY: {
                    this.security = true;
                    continue block6;
                }
                case NAMING: {
                    this.naming = true;
                    continue block6;
                }
                case WORKAREA: {
                    this.workArea = true;
                }
            }
        }
    }

    public ContextHandle saveContext(ContextService contextService) {
        return this.saveContext(contextService, null);
    }

    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        ComponentInvocation currentInvocation;
        ClassLoader contextClassloader = null;
        SecurityContext currentSecurityContext = null;
        ComponentInvocation savedInvocation = null;
        if (this.classloading) {
            contextClassloader = Utility.getClassLoader();
        }
        if (this.security) {
            currentSecurityContext = SecurityContext.getCurrent();
        }
        if ((currentInvocation = this.invocationManager.getCurrentInvocation()) != null) {
            savedInvocation = this.createComponentInvocation(currentInvocation);
        }
        boolean useTransactionOfExecutionThread = this.transactionManager == null && this.useTransactionOfExecutionThread(contextObjectProperties);
        return new InvocationContext(savedInvocation, contextClassloader, currentSecurityContext, useTransactionOfExecutionThread);
    }

    public ContextHandle setup(ContextHandle contextHandle) throws IllegalStateException {
        ComponentInvocation invocation;
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return null;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        String appName = null;
        if (handle.getInvocation() != null) {
            appName = handle.getInvocation().getAppName();
        }
        if (!this.isApplicationEnabled(appName)) {
            throw new IllegalStateException("Module " + appName + " is disabled");
        }
        ClassLoader resetClassLoader = null;
        SecurityContext resetSecurityContext = null;
        if (handle.getContextClassLoader() != null) {
            resetClassLoader = Utility.setContextClassLoader((ClassLoader)handle.getContextClassLoader());
        }
        if (handle.getSecurityContext() != null) {
            resetSecurityContext = SecurityContext.getCurrent();
            SecurityContext.setCurrent((SecurityContext)handle.getSecurityContext());
        }
        if ((invocation = handle.getInvocation()) != null && !handle.isUseTransactionOfExecutionThread()) {
            invocation.setResourceTableKey((Object)new PairKey(invocation.getInstance(), Thread.currentThread()));
            this.invocationManager.preInvoke(invocation);
        }
        if (this.transactionManager != null) {
            this.transactionManager.clearThreadTx();
        }
        return new InvocationContext(invocation, resetClassLoader, resetSecurityContext, handle.isUseTransactionOfExecutionThread());
    }

    public void reset(ContextHandle contextHandle) {
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        if (handle.getContextClassLoader() != null) {
            Utility.setContextClassLoader((ClassLoader)handle.getContextClassLoader());
        }
        if (handle.getSecurityContext() != null) {
            SecurityContext.setCurrent((SecurityContext)handle.getSecurityContext());
        }
        if (handle.getInvocation() != null && !handle.isUseTransactionOfExecutionThread()) {
            this.invocationManager.postInvoke(((InvocationContext)contextHandle).getInvocation());
        }
        if (this.transactionManager != null) {
            JavaEETransaction transaction = this.transactionManager.getCurrentTransaction();
            if (transaction != null) {
                try {
                    int status = transaction.getStatus();
                    if (status == 0) {
                        this.transactionManager.commit();
                    } else if (status == 1) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.toString());
                }
            }
            this.transactionManager.clearThreadTx();
        }
    }

    private boolean isApplicationEnabled(String appId) {
        Application app;
        if (appId != null && (app = this.applications.getApplication(appId)) != null) {
            return this.deployment.isAppEnabled(app);
        }
        return false;
    }

    private ComponentInvocation createComponentInvocation(ComponentInvocation currInv) {
        ComponentInvocation newInv = new ComponentInvocation(currInv.getComponentId(), ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, currInv.getContainer(), currInv.getAppName(), currInv.getModuleName());
        newInv.instance = currInv.getInstance();
        if (this.naming) {
            newInv.setJNDIEnvironment(currInv.getJNDIEnvironment());
        }
        return newInv;
    }

    private boolean useTransactionOfExecutionThread(Map<String, String> executionProperties) {
        return "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(this.getTransactionExecutionProperty(executionProperties));
    }

    private String getTransactionExecutionProperty(Map<String, String> executionProperties) {
        if (executionProperties != null && executionProperties.get("javax.enterprise.concurrent.TRANSACTION") != null) {
            return executionProperties.get("javax.enterprise.concurrent.TRANSACTION");
        }
        return "SUSPEND";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.transactionManager == null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean nullTransactionManager = in.readBoolean();
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.invocationManager = concurrentRuntime.getInvocationManager();
        this.deployment = concurrentRuntime.getDeployment();
        this.applications = concurrentRuntime.getApplications();
        if (!nullTransactionManager) {
            this.transactionManager = concurrentRuntime.getTransactionManager();
        }
    }

    private static class PairKey {
        private Object instance = null;
        private Thread thread = null;
        int hCode = 0;

        private PairKey(Object inst, Thread thr) {
            this.instance = inst;
            this.thread = thr;
            if (inst != null) {
                this.hCode = 7 * inst.hashCode();
            }
            if (thr != null) {
                this.hCode += thr.hashCode();
            }
        }

        public int hashCode() {
            return this.hCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            boolean eq = false;
            if (obj != null && obj instanceof PairKey) {
                PairKey p = (PairKey)obj;
                if (this.instance != null) {
                    eq = this.instance.equals(p.instance);
                } else {
                    boolean bl = eq = p.instance == null;
                }
                if (eq) {
                    eq = this.thread != null ? this.thread.equals(p.thread) : p.thread == null;
                }
            }
            return eq;
        }
    }

    static enum CONTEXT_TYPE {
        CLASSLOADING,
        SECURITY,
        NAMING,
        WORKAREA;

    }
}

